/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;

public class SchemaPanel
extends BaseInfoPanel
implements ItemListener {
    private GridBagLayout layCenter;
    private JLabel m_lblSchemaName;
    private JTextField m_txtSchemaName;
    private DBObjectRenderer renderer;

    private void $init$() {
        this.layCenter = new GridBagLayout();
        this.m_lblSchemaName = new JLabel();
        this.m_txtSchemaName = new JTextField();
        this.renderer = new DBObjectRenderer();
    }

    public SchemaPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        ResourceUtils.resLabel((JLabel)this.m_lblSchemaName, (Component)this.m_txtSchemaName, (String)UIArb.getString(380));
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_txtSchemaName, new GridBagConstraints(20, 20, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIArb.getString(378);
    }

    public String getHeaderDescription() {
        return UIArb.getString(379);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Schema schema = (Schema)traversableContext.find("NewObject");
        this.init(dBObjectProvider, schema);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            wizardCallbacks.wizardSetInitialFocus((Component)this.m_txtSchemaName);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Schema schema = (Schema)traversableContext.find("NewObject");
        String string = this.m_txtSchemaName.getText();
        if (dBObjectProvider != null) {
            if (!dBObjectProvider.isValidName("SCHEMA", string)) {
                throw new TraversalException(UIArb.format(419, string), UIArb.getString(381));
            }
            if (schema != null) {
                schema.setName(dBObjectProvider.getInternalName(string));
            }
        }
    }

    private void init(DBObjectProvider dBObjectProvider, Schema schema) {
        super.init(dBObjectProvider, null);
        this.renderer.setProvider(dBObjectProvider);
        this.m_txtSchemaName.setText(this.getExternalName(schema.getName()));
        this.m_txtSchemaName.setEnabled(true);
    }
}

