/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.MDDEditorPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PanelLibrary {
    public static final String KEY = "PANEL_LIBRARY";
    private String m_type;
    private boolean m_flatten;
    private Map<String, Navigable> m_panels;
    private Map<String, String> m_helpIDs;
    private Navigable[] m_defaultPanels;

    private void $init$() {
        this.m_panels = new HashMap<String, Navigable>();
    }

    protected PanelLibrary(String string) {
        this(string, null);
    }

    protected PanelLibrary(String string, Map<String, String> map) {
        this.$init$();
        this.m_type = string;
        this.m_helpIDs = map;
    }

    public String getType() {
        return this.m_type;
    }

    public final void setDefaultPanels(Navigable[] navigableArray) {
        this.m_defaultPanels = navigableArray;
    }

    private void addDefaultPanels(List<Navigable> list) {
        if (this.m_defaultPanels != null) {
            int n = 0;
            while (n < this.m_defaultPanels.length) {
                list.add(this.m_defaultPanels[n]);
                ++n;
            }
        }
    }

    protected Class<? extends Traversable> getHeader() {
        if (this.getSimpleTitles() != null) {
            return NameAndSchemaAdvancedEditor.class;
        }
        return NameAndSchemaEditor.class;
    }

    public final Traversable getMainDialogPanel(DBObject dBObject, DBObjectProvider dBObjectProvider, DBObject dBObject2, Navigable[] navigableArray) {
        String string = this.getStartPage(dBObject2);
        Traversable traversable = null;
        try {
            traversable = this.getHeader().newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.createMainPanel(traversable, navigableArray, string);
    }

    protected Traversable createMainPanel(Traversable traversable, Navigable[] navigableArray, String string) {
        int n;
        List<Navigable> list = this.getSimpleNavigables();
        int n2 = n = list == null ? 0 : list.size();
        if (n > 0 && navigableArray.length > n) {
            return new MDDEditorPanel(traversable, navigableArray, string, n);
        }
        return new TabbedEditorPanel(traversable, navigableArray, string);
    }

    public final List<Navigable> getCreateNavigables(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        List<Navigable> list = this.getNavigables(this.getTitles(dBObject, dBObjectProvider, false), false);
        if (list != null && list.size() > 0) {
            this.addDefaultPanels(list);
        }
        return list;
    }

    public final Map<String, Class> getCreateVerifiers() {
        return this.getVerifiers(false);
    }

    public final List<Navigable> getEditNavigables(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        List<Navigable> list = this.getNavigables(this.getTitles(dBObject, dBObjectProvider, true), false);
        if (list != null && list.size() > 0) {
            this.addDefaultPanels(list);
        }
        return list;
    }

    public final Map<String, Class> getEditVerifiers() {
        return this.getVerifiers(true);
    }

    public final List<Navigable> getSimpleNavigables() {
        List<String> list = this.getSimpleTitles();
        if (list != null) {
            return this.getNavigables(list, true);
        }
        return null;
    }

    public final DBObject getObjectForCreate(Schema schema, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        String string = this.getUniqueName(this.m_type);
        String string2 = dBObjectProvider.getUniqueName(this.m_type, (DBObject)(dBObject == null ? schema : dBObject), string);
        DBObject dBObject2 = this.newDBObject(dBObject);
        dBObject2.setName(string2);
        if (dBObject2 instanceof SchemaObject) {
            ((SchemaObject)dBObject2).setSchema(schema);
        }
        dBObject2.setID(TemporaryObjectID.createID((DBObject)dBObject2));
        return dBObject2;
    }

    protected String getUniqueName(String string) {
        String string2 = string;
        if (string2.indexOf(" ") >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(string3.substring(0, 1));
                    continue;
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return string2 + 1;
    }

    public String getStartPage(DBObject dBObject) {
        return null;
    }

    protected abstract DBObject newDBObject(DBObject var1);

    protected abstract List<String> getTitles(DBObject var1, DBObjectProvider var2, boolean var3);

    protected abstract Map<String, Class> getVerifiers(boolean var1);

    protected List<String> getSimpleTitles() {
        return null;
    }

    private final List<Navigable> getNavigables(List<String> list, boolean bl) {
        if (list == null) {
            return null;
        }
        ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
        for (String string : list) {
            Navigable navigable = this.m_panels.get(string);
            if (navigable == null && bl && this.m_defaultPanels != null) {
                int n = 0;
                while (n < this.m_defaultPanels.length) {
                    if (string.equals(this.m_defaultPanels[n].getShortLabel())) {
                        navigable = this.m_defaultPanels[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.m_helpIDs != null && this.m_helpIDs.containsKey(string)) {
                navigable.setHelpID(this.m_helpIDs.get(string));
            }
            arrayList.add(navigable);
        }
        return arrayList;
    }

    protected final Navigable addPanel(String string, Class clazz, String string2) {
        return this.addPanel(string, clazz, string2, null, null);
    }

    protected final Navigable addPanel(String string, Class clazz, String string2, Class[] classArray, Object[] objectArray) {
        Navigable navigable = new Navigable(string, clazz, classArray, objectArray, null);
        navigable.setHelpID(string2);
        this.addNavigable(string, navigable);
        return navigable;
    }

    protected final void addNavigable(String string, Navigable navigable) {
        this.m_panels.put(string, navigable);
    }

    public Dimension getSize() {
        return null;
    }

    public abstract String getCreateText();

    public abstract String getCreateTitle();

    public abstract String getEditTitle();

    public interface HeaderPanelListener {
        public void panelSetChange(String var1, Navigable[] var2) throws TraversalException;
    }

    public interface HeaderPanel {
        public static final String HEADER_PANEL_KEY = "HEADER_PANEL";
        public static final String DEFAULT_PANEL_KEY = "DEFAULT_PANEL";

        public void addHeaderPanelListener(HeaderPanelListener var1);

        public boolean removeHeaderPanelListener(HeaderPanelListener var1);
    }
}

