/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.verifiers.DatabaseLinkInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.dialogs.ExceptionDialog;

public class DatabaseLinkPanel
extends DefaultTraversablePanel
implements ActionListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String PUBLIC = "PUBLIC";
    private static final int LOAD_NOT_ATTEMPTED = 0;
    private static final int LOAD_COMPLETED = 1;
    private JLabel dbLinkNameLabel;
    private JTextField dbLinkNameTextField;
    private JLabel serviceNameLabel;
    private JTextField serviceNameTextField;
    private JRadioButton currentUserRadioBtn;
    private JRadioButton fixedUserRadioBtn;
    private JLabel fixedUserNameLabel;
    private JLabel fixedUserPasswordLabel;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JCheckBox publicCheckBox;
    private JCheckBox sharedCheckBox;
    private JLabel authenUserNameLabel;
    private JLabel authenPasswordLabel;
    private JTextField authenTextFeild;
    private JPasswordField authenPasswordField;
    private JLabel currentUserLabel;
    private JLabel fixedUser;
    private JLabel publicLabel;
    private JLabel SharedLabel;
    private JCheckBox preserveCaseCheckBox;
    private JLabel preserveCaseLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel authenticationLabel;
    private JLabel jLabel1;
    private ButtonGroup userTypeButtonGroup;
    private HashMap m_loadingSchemas;
    private int m_ObjectStatus;
    private ProgressBar m_progressBar;
    private static final String[] DATABASELINK_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "DATABASE LINK"};
    private static final String ACMD_FORSCHEMACHANGED = "ForSchemaChanged";
    private static final String ACMD_OBJECTCHANGED = "ObjectChanged";
    private static final String ACMD_SETOBJECTBASED = "SetObjectBased";
    private static final String ACMD_SETNAMEBASED = "SetNameBased";
    private static final String ACMD_FIXEDUSER = "FixedUser";
    private static final String ACMD_SHARED = "Shared";
    protected DBObjectProvider m_prov;
    protected DatabaseLink m_dblink;
    protected Schema m_forSchema;
    protected String m_savedName;
    private Schema[] m_schemas;
    private Schema m_originalSchema;
    private GridBagLayout layCenter;
    private JLabel m_lblFor;
    private JLabel m_lblForSchemaName;
    private JComboBox m_cmbObject;
    private JTextField m_txtName;
    private JRadioButton m_rdbObjectBased;
    private JRadioButton m_rdbNameBased;
    private ButtonGroup m_rbgBased;
    private JMultiLineLabel m_lblDanglingBlather;
    private SchemaPicker m_cmbForSchema;
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap;
    private DatabaseLinkInfoVerifier m_verifier;
    private boolean m_isDefaultObject;
    private boolean m_isNewDblinkObject;
    private boolean m_isInit;
    private static final String DBLINK_HOST_NAME = UIArb.getString(727);
    private static final String DBLINK_HOST_NAME_TOOLTIP = UIArb.getString(728);
    private static final String DBLINK_CURRENT_USER = UIArb.getString(729);
    private static final String DBLINK_CURRENT_USER_TOOLTIP = UIArb.getString(730);
    private static final String DBLINK_FIXED_USER = UIArb.getString(731);
    private static final String DBLINK_FIXED_USER_TOOLTIP = UIArb.getString(732);
    private static final String DBLINK_FIXED_USER_NAME = UIArb.getString(733);
    private static final String DBLINK_FIXED_USER_PW = UIArb.getString(734);
    private static final String DBLINK_AUTHEN_USER_NAME = UIArb.getString(735);
    private static final String DBLINK_AUTHEN_USER_PW = UIArb.getString(736);
    private static final String DBLINK_SHARED = UIArb.getString(737);
    private static final String DBLINK_AUTHENTICATION = UIArb.getString(738);
    private static final String DBLINK_CONNECT_TO = UIArb.getString(739);

    private void $init$() {
        this.dbLinkNameLabel = new JLabel();
        this.dbLinkNameTextField = new JTextField();
        this.serviceNameLabel = new JLabel();
        this.serviceNameTextField = new JTextField();
        this.currentUserRadioBtn = new JRadioButton();
        this.fixedUserRadioBtn = new JRadioButton();
        this.fixedUserNameLabel = new JLabel();
        this.fixedUserPasswordLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.passwordField = new JPasswordField();
        this.publicCheckBox = new JCheckBox();
        this.sharedCheckBox = new JCheckBox();
        this.authenUserNameLabel = new JLabel();
        this.authenPasswordLabel = new JLabel();
        this.authenTextFeild = new JTextField();
        this.authenPasswordField = new JPasswordField();
        this.currentUserLabel = new JLabel();
        this.fixedUser = new JLabel();
        this.publicLabel = new JLabel();
        this.SharedLabel = new JLabel();
        this.preserveCaseCheckBox = new JCheckBox();
        this.preserveCaseLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.authenticationLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.userTypeButtonGroup = new ButtonGroup();
        this.m_loadingSchemas = new HashMap();
        this.m_ObjectStatus = 0;
        this.m_progressBar = null;
        this.m_prov = null;
        this.m_dblink = null;
        this.m_forSchema = null;
        this.m_savedName = null;
        this.m_schemas = null;
        this.m_originalSchema = null;
        this.layCenter = new GridBagLayout();
        this.m_lblFor = new JLabel();
        this.m_lblForSchemaName = new JLabel();
        this.m_cmbObject = new JComboBox();
        this.m_txtName = new JTextField();
        this.m_rdbObjectBased = new JRadioButton();
        this.m_rdbNameBased = new JRadioButton();
        this.m_rbgBased = new ButtonGroup();
        this.m_lblDanglingBlather = new JMultiLineLabel();
        this.m_cmbForSchema = new SchemaPicker();
        this.m_schemaMap = new HashMap();
        this.m_isDefaultObject = true;
        this.m_isNewDblinkObject = true;
        this.m_isInit = false;
    }

    public DatabaseLinkPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setSize(new Dimension(330, 300));
        this.serviceNameLabel.setText(DBLINK_HOST_NAME);
        this.serviceNameLabel.setBounds(new Rectangle(10, 10, 125, 25));
        this.serviceNameLabel.setToolTipText(DBLINK_HOST_NAME_TOOLTIP);
        this.serviceNameTextField.setBounds(new Rectangle(180, 10, 120, 20));
        this.currentUserRadioBtn.setBounds(new Rectangle(90, 30, 15, 20));
        this.currentUserRadioBtn.setHorizontalTextPosition(0);
        this.currentUserRadioBtn.setHorizontalAlignment(0);
        this.currentUserRadioBtn.setSelected(true);
        this.currentUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.currentUserRadioBtn.addActionListener(this);
        this.fixedUserRadioBtn.setToolTipText(DBLINK_CURRENT_USER_TOOLTIP);
        this.fixedUserRadioBtn.setText("");
        this.fixedUserRadioBtn.setBounds(new Rectangle(90, 50, 15, 20));
        this.fixedUserRadioBtn.setToolTipText(DBLINK_FIXED_USER_TOOLTIP);
        this.fixedUserRadioBtn.setHorizontalTextPosition(0);
        this.fixedUserRadioBtn.setHorizontalAlignment(0);
        this.fixedUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.fixedUserRadioBtn.addActionListener(this);
        this.userTypeButtonGroup.add(this.fixedUserRadioBtn);
        this.userTypeButtonGroup.add(this.currentUserRadioBtn);
        this.fixedUserNameLabel.setText(DBLINK_FIXED_USER_NAME);
        this.fixedUserNameLabel.setBounds(new Rectangle(100, 75, 75, 20));
        this.fixedUserNameLabel.setEnabled(false);
        this.fixedUserPasswordLabel.setText(DBLINK_FIXED_USER_PW);
        this.fixedUserPasswordLabel.setBounds(new Rectangle(100, 100, 75, 20));
        this.fixedUserPasswordLabel.setEnabled(false);
        this.userNameTextField.setBounds(new Rectangle(180, 75, 120, 20));
        this.userNameTextField.setEnabled(false);
        this.passwordField.setBounds(new Rectangle(180, 100, 120, 20));
        this.passwordField.setEnabled(false);
        this.sharedCheckBox.setBounds(new Rectangle(90, 160, 15, 20));
        this.sharedCheckBox.setHorizontalTextPosition(2);
        this.sharedCheckBox.setActionCommand(ACMD_SHARED);
        this.sharedCheckBox.addActionListener(this);
        this.authenUserNameLabel.setText(DBLINK_AUTHEN_USER_NAME);
        this.authenUserNameLabel.setBounds(new Rectangle(100, 195, 75, 20));
        this.authenUserNameLabel.setEnabled(false);
        this.authenPasswordLabel.setText(DBLINK_AUTHEN_USER_PW);
        this.authenPasswordLabel.setBounds(new Rectangle(100, 215, 60, 25));
        this.authenPasswordLabel.setEnabled(false);
        this.authenTextFeild.setBounds(new Rectangle(180, 195, 120, 20));
        this.authenTextFeild.setEnabled(false);
        this.authenPasswordField.setBounds(new Rectangle(180, 220, 120, 20));
        this.authenPasswordField.setEnabled(false);
        this.currentUserLabel.setText(DBLINK_CURRENT_USER);
        this.currentUserLabel.setBounds(new Rectangle(10, 30, 65, 20));
        this.currentUserLabel.setSize(new Dimension(85, 20));
        this.fixedUser.setText(DBLINK_FIXED_USER);
        this.fixedUser.setBounds(new Rectangle(10, 50, 55, 20));
        this.fixedUser.setSize(new Dimension(85, 20));
        this.SharedLabel.setText(DBLINK_SHARED);
        this.SharedLabel.setBounds(new Rectangle(10, 160, 50, 20));
        this.jSeparator1.setBounds(new Rectangle(5, 0, 315, 10));
        this.jSeparator2.setBounds(new Rectangle(5, 130, 315, 5));
        this.authenticationLabel.setText(DBLINK_AUTHENTICATION);
        this.authenticationLabel.setBounds(new Rectangle(195, 180, 95, 10));
        this.jLabel1.setText(DBLINK_CONNECT_TO);
        this.jLabel1.setBounds(new Rectangle(200, 50, 90, 15));
        this.add(this.authenticationLabel, null);
        this.add(this.jSeparator2, null);
        this.add(this.SharedLabel, null);
        this.add(this.publicLabel, null);
        this.add(this.fixedUser, null);
        this.add(this.currentUserLabel, null);
        this.add(this.authenPasswordField, null);
        this.add(this.authenTextFeild, null);
        this.add(this.authenPasswordLabel, null);
        this.add(this.authenUserNameLabel, null);
        this.add(this.sharedCheckBox, null);
        this.add(this.publicCheckBox, null);
        this.add(this.passwordField, null);
        this.add(this.userNameTextField, null);
        this.add(this.fixedUserPasswordLabel, null);
        this.add(this.fixedUserNameLabel, null);
        this.add(this.fixedUserRadioBtn, null);
        this.add(this.currentUserRadioBtn, null);
        this.add(this.serviceNameTextField, null);
        this.add(this.serviceNameLabel, null);
    }

    private void currentUserRadioBtn_actionPerformed(ActionEvent actionEvent) {
    }

    private void fixedUserRadioBtn_actionPerformed(ActionEvent actionEvent) {
    }

    public String getHeaderTitle() {
        return UIArb.getString(669);
    }

    public String getHeaderDescription() {
        return UIArb.getString(670);
    }

    protected boolean isDangling(DBObjectID dBObjectID) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_prov = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this.m_dblink = (DatabaseLink)traversableContext.find("NewObject");
        this.m_verifier = (DatabaseLinkInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.init(this.m_dblink, this.m_verifier, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DatabaseLink databaseLink = (DatabaseLink)traversableContext.find("NewObject");
        if (databaseLink == null) {
            databaseLink = new DatabaseLink();
        }
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.commit(databaseLink, schemaArray, traversableContext.getDirection() != 2);
    }

    private void init(DatabaseLink databaseLink, DatabaseLinkInfoVerifier databaseLinkInfoVerifier, Schema[] schemaArray) {
        if (this.m_isInit) {
            return;
        }
        this.m_isInit = true;
        this.m_schemas = schemaArray;
        if (this.isDangling(databaseLink.getID())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_forSchema = this.m_originalSchema = databaseLink.getSchema();
        DBObjectID dBObjectID = databaseLink.getID();
        if (dBObjectID != null) {
            this.m_isNewDblinkObject = false;
            SchemaObject schemaObject = null;
            try {
                schemaObject = (SchemaObject)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (schemaObject == null) {
                this.setForSchemaAndName(dBObjectID);
            } else {
                this.m_forSchema = schemaObject.getSchema();
            }
        }
        SchemaObject schemaObject = null;
        if (dBObjectID != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof SchemaObject) {
                    schemaObject = (SchemaObject)dBObject;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (schemaObject != null) {
            this.m_isDefaultObject = false;
            this.m_forSchema = schemaObject.getSchema();
        }
        this.m_cmbForSchema.init(this.m_prov, this.m_forSchema, schemaArray);
        boolean bl = false;
        if (this.m_loadingSchemas.containsKey(this.m_forSchema.getName()) || dBObjectID != null && schemaObject == null) {
            bl = true;
            this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (!this.populateObjectField()) {
                bl = true;
            }
            if (this.m_cmbObject.getModel().getSize() < 1) {
                bl = true;
            }
            if (schemaObject != null) {
                this.m_cmbObject.setSelectedItem(schemaObject.getName());
            }
        }
        this.setEnabledFields(bl);
        this.m_lblFor.setEnabled(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeSchema());
        this.m_cmbForSchema.setEditable(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canCreateSchema());
        this.m_rdbNameBased.setEnabled(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference());
        this.m_cmbObject.setEnabled(!bl && (databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference()));
        this.m_txtName.setEditable(bl && (databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference()));
        this.m_txtName.setEnabled(bl && (databaseLinkInfoVerifier == null || databaseLinkInfoVerifier.canChangeReference()));
        this.m_isNewDblinkObject = false;
    }

    private void commit(DatabaseLink databaseLink, Schema[] schemaArray, boolean bl) throws TraversalException {
        DatabaseLinkInfoVerifier databaseLinkInfoVerifier = this.m_verifier;
        this.m_forSchema = this.m_cmbForSchema.getSchema();
        Object var5_5 = null;
        if (bl && databaseLinkInfoVerifier != null) {
            databaseLinkInfoVerifier.verifyDblink();
        }
        databaseLink.setHost(this.serviceNameTextField.getText());
        databaseLink.setCurrentUser(this.currentUserRadioBtn.isSelected());
        databaseLink.setUsername(this.userNameTextField.getText());
        databaseLink.setPassword(new String(this.passwordField.getPassword()));
        databaseLink.setShared(this.sharedCheckBox.isSelected());
        databaseLink.setAuthentificationPassword(new String(this.authenPasswordField.getPassword()));
        databaseLink.setAuthentificationUsername(this.authenTextFeild.getText());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.m_rdbNameBased.isSelected();
        if (ACMD_FIXEDUSER.equals(actionEvent.getActionCommand())) {
            if (this.fixedUserRadioBtn.isSelected()) {
                this.userNameTextField.setEnabled(true);
                this.passwordField.setEnabled(true);
                this.fixedUserNameLabel.setEnabled(true);
                this.fixedUserPasswordLabel.setEnabled(true);
            } else {
                this.userNameTextField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.fixedUserNameLabel.setEnabled(false);
                this.fixedUserPasswordLabel.setEnabled(false);
            }
        } else if (ACMD_SHARED.equals(actionEvent.getActionCommand())) {
            if (this.sharedCheckBox.isSelected()) {
                this.authenUserNameLabel.setEnabled(true);
                this.authenPasswordLabel.setEnabled(true);
                this.authenTextFeild.setEnabled(true);
                this.authenPasswordField.setEnabled(true);
            } else {
                this.authenUserNameLabel.setEnabled(false);
                this.authenPasswordLabel.setEnabled(false);
                this.authenTextFeild.setEnabled(false);
                this.authenPasswordField.setEnabled(false);
            }
        } else if (ACMD_FORSCHEMACHANGED.equals(actionEvent.getActionCommand())) {
            try {
                this.m_forSchema = this.m_cmbForSchema.getSchema();
                if (this.m_rdbObjectBased.isSelected() && !this.populateObjectField()) {
                    bl = true;
                }
            }
            catch (TraversalException traversalException) {}
        } else if (ACMD_OBJECTCHANGED.equals(actionEvent.getActionCommand())) {
            int n = this.m_cmbObject.getSelectedIndex();
            this.m_isDefaultObject = this.m_isNewDblinkObject || n == -1;
        } else if (ACMD_SETOBJECTBASED.equals(actionEvent.getActionCommand())) {
            if (!this.populateObjectField()) {
                bl = true;
            } else {
                SchemaObject schemaObject;
                this.m_savedName = this.m_txtName.getText();
                if (ModelUtil.hasLength((String)this.m_savedName) && (schemaObject = this.findObject(this.m_savedName)) != null) {
                    this.m_cmbObject.setSelectedItem(schemaObject.getName());
                }
                this.m_txtName.setText(null);
            }
        } else {
            SchemaObject schemaObject = this.findObject((String)this.m_cmbObject.getSelectedItem());
            if (!this.m_isDefaultObject && schemaObject != null) {
                this.m_txtName.setText(schemaObject.getName());
            } else if (this.m_savedName != null && this.m_savedName.length() > 0) {
                this.m_txtName.setText(this.m_savedName);
            }
            bl = true;
        }
        this.setEnabledFields(bl);
    }

    private void setEnabledFields(boolean bl) {
        this.m_rdbNameBased.setSelected(bl);
        this.m_rdbObjectBased.setSelected(bl ^ true);
        this.m_txtName.setEditable(bl);
        this.m_txtName.setEnabled(bl);
        this.m_cmbObject.setEnabled(bl ^ true);
    }

    private void getAllDblinkObjects(Schema schema) {
        try {
            SchemaObject[] schemaObjectArray = this.m_prov.listObjects(DATABASELINK_TYPES, schema);
            SchemaObject schemaObject = this.m_verifier.getOriginalObject();
            String string = schemaObject != null ? schemaObject.getName() : null;
            Schema schema2 = schemaObject != null ? schemaObject.getSchema() : null;
            NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
            int n = 0;
            while (n < schemaObjectArray.length) {
                if (!(schemaObject != null && "DATABASE LINK".equals(schemaObjectArray[n].getType()) && ModelUtil.areEqual((Object)schema2, (Object)schema) && ModelUtil.areEqual((Object)string, (Object)schemaObjectArray[n].getName()))) {
                    nonNullableComboBoxModel.addElement(schemaObjectArray[n].getName());
                }
                ++n;
            }
            this.m_schemaMap.put(schema.getName(), nonNullableComboBoxModel);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema schema) {
        DefaultComboBoxModel defaultComboBoxModel = null;
        if (this.m_verifier == null || this.m_verifier.canChangeReference()) {
            defaultComboBoxModel = (DefaultComboBoxModel)this.m_schemaMap.get(schema.getName());
        } else if (this.m_dblink != null) {
            defaultComboBoxModel = new NonNullableComboBoxModel();
        }
        this.m_cmbObject.setModel(defaultComboBoxModel != null ? defaultComboBoxModel : EMPTY_MDL_OBJECT);
        return defaultComboBoxModel != null;
    }

    private SchemaObject findObject(String string) {
        SchemaObject schemaObject = null;
        if (string != null) {
            int n = 0;
            while (n < DATABASELINK_TYPES.length) {
                try {
                    schemaObject = this.m_prov.getObject(DATABASELINK_TYPES[n], this.m_forSchema, string);
                    if (schemaObject != null) {
                        break;
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return schemaObject;
    }

    private boolean populateObjectField() {
        Schema schema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(schema.getName())) {
            this.loadObjectModel(schema);
        }
        return this.setObjectModel(schema);
    }

    protected void setForSchemaAndName(DBObjectID dBObjectID) {
        if (dBObjectID instanceof NameBasedRefID) {
            NameBasedRefID nameBasedRefID = (NameBasedRefID)dBObjectID;
            String string = nameBasedRefID.getSchemaName();
            if (string != null) {
                try {
                    Schema schema = this.m_prov.getSchema(string);
                    this.m_forSchema = schema == null ? new Schema(string) : schema;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this.m_savedName = nameBasedRefID.getName();
        }
    }

    private void loadObjectModel(Schema schema) {
        if (!this.m_loadingSchemas.containsKey(schema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(schema);
            this.m_loadingSchemas.put(schema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(schema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return UIArb.getString(671);
    }

    public String getProgressText() {
        return UIArb.getString(672);
    }

    static HashMap ra$m_loadingSchemas(DatabaseLinkPanel databaseLinkPanel) {
        return databaseLinkPanel.m_loadingSchemas;
    }

    static void mav$getAllDblinkObjects(DatabaseLinkPanel databaseLinkPanel, Schema schema) {
        databaseLinkPanel.getAllDblinkObjects(schema);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (DatabaseLinkPanel.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), DatabaseLinkPanel.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(DatabaseLinkPanel.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar progressBar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (DatabaseLinkPanel.ra$m_loadingSchemas(DatabaseLinkPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        DatabaseLinkPanel.mav$getAllDblinkObjects(DatabaseLinkPanel.this, this.m_schema);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)exception.getMessage());
                    }
                    DatabaseLinkPanel.ra$m_loadingSchemas(DatabaseLinkPanel.this).remove(this.m_schema.getName());
                }
                if (progressBar != null) {
                    progressBar.setDoneStatus();
                }
            }
        }
    }
}

