/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;

public class DataTypePanel
extends JPanel {
    private DataTypeUsage m_usage;
    private DataType m_dataType;
    private DBObjectProvider m_prov;
    private Column m_col;
    private boolean m_nestedTable;
    private HashMap m_componentMap;
    private JPanel m_panel;
    private JScrollPane m_scrollPane;
    private static Long LONG_0 = new Long(0L);

    private void $init$() {
        this.m_componentMap = new HashMap();
        this.m_panel = new JPanel();
        this.m_scrollPane = new JScrollPane(20, 31);
    }

    public DataTypePanel() {
        this.$init$();
        this.setLayout(new BorderLayout());
        this.m_panel.setLayout(new GridBagLayout());
    }

    public void initialise(DataTypeUsage dataTypeUsage, DBObjectProvider dBObjectProvider, Column column) {
        this.m_usage = dataTypeUsage;
        this.m_prov = dBObjectProvider;
        this.m_col = column;
        this.m_nestedTable = false;
        this.removeAll();
        this.m_panel.removeAll();
        this.m_componentMap.clear();
        if (this.m_usage != null) {
            try {
                this.m_dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_usage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            DataTypeAttribute[] dataTypeAttributeArray = this.m_dataType.getDataTypeAttributes();
            if (this.m_usage instanceof ObjectTypeUsage) {
                ObjectType objectType = null;
                try {
                    objectType = (ObjectType)this.m_usage.getDataTypeID().resolveID();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (objectType != null && "TABLE".equals(objectType.getCollectionType())) {
                    this.m_nestedTable = true;
                    dataTypeAttributeArray = this.pseudoNestedTableAttributes();
                }
            }
            if (dataTypeAttributeArray != null && dataTypeAttributeArray.length > 0) {
                int n = 0;
                int n2 = 0;
                while (n2 < dataTypeAttributeArray.length) {
                    if (dataTypeAttributeArray[n2].isDeclarable()) {
                        JLabel jLabel = new JLabel();
                        Component component = this.getComponent(dataTypeAttributeArray[n2]);
                        this.m_componentMap.put(dataTypeAttributeArray[n2].getName(), component);
                        if (component instanceof JCheckBox) {
                            ResourceUtils.resButton((AbstractButton)((JCheckBox)component), (String)dataTypeAttributeArray[n2].getLabel());
                            this.m_panel.add(component, new GridBagConstraints(0, n2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
                        } else {
                            ResourceUtils.resLabel((JLabel)jLabel, (Component)component, (String)(dataTypeAttributeArray[n2].getLabel() + ':'));
                            this.m_panel.add((Component)jLabel, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
                            this.m_panel.add(component, new GridBagConstraints(1, n2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
                        }
                        ++n;
                    }
                    ++n2;
                }
                if (n > 0) {
                    this.m_panel.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++n2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
                    if (n > 2) {
                        this.m_scrollPane.setViewportView(this.m_panel);
                        this.add((Component)this.m_scrollPane, "Center");
                    } else {
                        this.add((Component)this.m_panel, "Center");
                    }
                }
            }
        }
        this.validate();
        this.repaint();
    }

    public DataTypeUsage commit(Column column) {
        boolean bl = false;
        if (this.m_usage instanceof ObjectTypeUsage) {
            ObjectType objectType = null;
            try {
                objectType = (ObjectType)this.m_usage.getDataTypeID().resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (objectType != null && "TABLE".equals(objectType.getCollectionType())) {
                OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
                if (oracleColumnProperties == null) {
                    oracleColumnProperties = new OracleColumnProperties();
                }
                OracleNestedTableProperties oracleNestedTableProperties = new OracleNestedTableProperties();
                JTextField jTextField = (JTextField)this.m_componentMap.get("NestedTable");
                JComboBox jComboBox = (JComboBox)this.m_componentMap.get("ReturnAs");
                oracleNestedTableProperties.setTableName(this.m_prov.getInternalName(jTextField.getText()));
                oracleNestedTableProperties.setReturnAs((String)jComboBox.getSelectedItem());
                oracleColumnProperties.setNestedTableProperties(oracleNestedTableProperties);
                column.setProperty("OracleColumnProperties", (Object)oracleColumnProperties);
                bl = true;
            }
        }
        if (this.m_usage != null && !bl) {
            for (String string : this.m_componentMap.keySet()) {
                Component component = (Component)this.m_componentMap.get(string);
                if (component instanceof NumberField) {
                    Number number = ((NumberField)((Object)component)).getNumber();
                    if (number == null) {
                        this.m_usage.deleteAttributeValue(string);
                        continue;
                    }
                    this.m_usage.putAttributeValue(string, (Object)number);
                    continue;
                }
                if (component instanceof JTextField) {
                    String string2 = ((JTextField)component).getText();
                    if (string2.length() == 0 && !this.m_dataType.getDataTypeAttribute(string).isMandatory()) {
                        this.m_usage.deleteAttributeValue(string);
                        continue;
                    }
                    if (this.m_usage instanceof ObjectTypeUsage && string.equals("NestedTable")) {
                        string2 = this.m_prov.getInternalName(string2);
                    }
                    this.m_usage.putAttributeValue(string, (Object)string2);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    if (((JCheckBox)component).isSelected()) {
                        this.m_usage.putAttributeValue(string, (Object)this.m_dataType.getDataTypeAttribute(string).getValues()[0]);
                        continue;
                    }
                    this.m_usage.deleteAttributeValue(string);
                    continue;
                }
                if (!(component instanceof JComboBox)) continue;
                String string3 = (String)((JComboBox)component).getSelectedItem();
                if (string3 == null) {
                    this.m_usage.deleteAttributeValue(string);
                    continue;
                }
                this.m_usage.putAttributeValue(string, (Object)string3);
            }
        }
        return this.m_usage;
    }

    private Component getComponent(DataTypeAttribute dataTypeAttribute) {
        return dataTypeAttribute.getValueType() == 1 ? this.getNumberTextField(dataTypeAttribute) : this.getStringComponent(dataTypeAttribute);
    }

    private Component getNumberTextField(DataTypeAttribute dataTypeAttribute) {
        NumberField numberField = new NumberField(dataTypeAttribute);
        Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)this.m_usage, (String)dataTypeAttribute.getName());
        if (l == null && dataTypeAttribute.isMandatory() && (l = (Long)dataTypeAttribute.getDefaultValue()) == null) {
            l = dataTypeAttribute.getMinValue();
        }
        if (l != null) {
            numberField.setNumber(l);
        }
        return numberField;
    }

    private Component getStringComponent(DataTypeAttribute dataTypeAttribute) {
        String[] stringArray = dataTypeAttribute.getValues();
        if (stringArray == null) {
            return this.getTextField(dataTypeAttribute);
        }
        if (stringArray.length == 1 && !dataTypeAttribute.isExtensible() && dataTypeAttribute.getDefaultValue() == null) {
            return this.getCheckBox(dataTypeAttribute);
        }
        return this.getComboBox(dataTypeAttribute);
    }

    private Component getTextField(DataTypeAttribute dataTypeAttribute) {
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(true);
        Object object = null;
        if (this.m_nestedTable && "NestedTable".equals(dataTypeAttribute.getName())) {
            OracleNestedTableProperties oracleNestedTableProperties;
            OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties");
            if (oracleColumnProperties != null && (oracleNestedTableProperties = oracleColumnProperties.getNestedTableProperties()) != null) {
                object = this.m_prov.getExternalName(oracleNestedTableProperties.getTableName());
            }
        } else {
            object = this.m_usage.getAttributeValue(dataTypeAttribute.getName());
        }
        if (object == null && dataTypeAttribute.isMandatory()) {
            object = (String)dataTypeAttribute.getDefaultValue();
        }
        if (object != null) {
            String string = object.toString();
            jTextField.setText(string);
        }
        return jTextField;
    }

    private Component getCheckBox(DataTypeAttribute dataTypeAttribute) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setEnabled(true);
        Object object = this.m_usage.getAttributeValue(dataTypeAttribute.getName());
        jCheckBox.setSelected(object != null);
        return jCheckBox;
    }

    private Component getComboBox(DataTypeAttribute dataTypeAttribute) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(dataTypeAttribute.getValues());
        Object object = null;
        if (this.m_nestedTable && "ReturnAs".equals(dataTypeAttribute.getName())) {
            OracleNestedTableProperties oracleNestedTableProperties;
            OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties");
            if (oracleColumnProperties != null && (oracleNestedTableProperties = oracleColumnProperties.getNestedTableProperties()) != null) {
                object = oracleNestedTableProperties.getReturnAs();
            }
        } else {
            object = this.m_usage.getAttributeValue(dataTypeAttribute.getName());
        }
        if (dataTypeAttribute.isMandatory()) {
            if (object == null && (object = (String)dataTypeAttribute.getDefaultValue()) == null) {
                object = dataTypeAttribute.getValues()[0];
            }
        } else if (defaultComboBoxModel.getIndexOf(null) < 0) {
            defaultComboBoxModel.insertElementAt(null, 0);
        }
        defaultComboBoxModel.setSelectedItem(object == null ? null : object.toString());
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setEnabled(true);
        jComboBox.setEditable(dataTypeAttribute.isExtensible());
        return jComboBox;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_scrollPane.setEnabled(bl);
        this.m_panel.setEnabled(bl);
        Component[] componentArray = this.m_panel.getComponents();
        int n = 0;
        while (componentArray != null && n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    private DataTypeAttribute[] pseudoNestedTableAttributes() {
        DataTypeAttribute[] dataTypeAttributeArray = new DataTypeAttribute[2];
        String[] stringArray = new String[]{"VALUE", "LOCATOR"};
        dataTypeAttributeArray[0] = new DataTypeAttribute("NestedTable", 128, "", true);
        dataTypeAttributeArray[1] = new DataTypeAttribute("ReturnAs", 129, stringArray, stringArray[0], false, true);
        return dataTypeAttributeArray;
    }

    static Long ra$LONG_0() {
        return LONG_0;
    }

    private static class NumberField
    extends NumberTextField {
        private DataTypeAttribute m_attribute;

        public NumberField(DataTypeAttribute dataTypeAttribute) {
            this.setDataType(Long.class);
            this.setEnabled(true);
            this.setSigned(dataTypeAttribute.getMinValue() == null || dataTypeAttribute.getMinValue().compareTo(DataTypePanel.ra$LONG_0()) < 0);
            this.m_attribute = dataTypeAttribute;
        }

        public void setNumber(Number number) {
            if (this.m_attribute != null) {
                if (!this.m_attribute.isDeclarable()) {
                    number = null;
                } else if (number == null && this.m_attribute.isMandatory()) {
                    number = (Long)this.m_attribute.getDefaultValue();
                }
            }
            super.setNumber(number);
        }

        protected boolean validateNumber(Number number) {
            long l = number.longValue();
            Long l2 = this.m_attribute.getMinValue();
            Long l3 = this.m_attribute.getMaxValue();
            return l3 == null || l2 != null && l >= l2 && l <= l3;
        }
    }
}

