/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class CustomTabbedPanel
extends JPanel
implements ListSelectionListener,
Traversable {
    private Navigable[] m_navs;
    private int m_selectedIdx;
    private TraversableContext m_data;
    private CustomTab m_customTab;
    private JPanel m_cardPanel;
    private CardLayout m_cardLayout;
    private Map<String, Traversable> m_mapPanelSets;

    private void $init$() {
        this.m_selectedIdx = -1;
        this.m_mapPanelSets = new HashMap<String, Traversable>();
    }

    public CustomTabbedPanel(Navigable[] navigableArray) {
        this(navigableArray, 1);
    }

    public CustomTabbedPanel(Navigable[] navigableArray, int n) {
        this.$init$();
        this.m_navs = navigableArray;
        this.m_customTab = new CustomTab((ListModel)this.createListModel(navigableArray), n);
        this.m_customTab.setCompressible(true);
        this.m_customTab.setGradientHighlight(true);
        this.m_cardLayout = new CardLayout();
        this.m_cardPanel = new JPanel(this.m_cardLayout);
        this.m_cardPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_customTab, "North");
        this.add((Component)this.m_cardPanel, "Center");
        this.m_customTab.addSelectionListener((ListSelectionListener)this);
    }

    private DefaultListModel createListModel(Navigable[] navigableArray) {
        DefaultListModel<DefaultCustomTabPage> defaultListModel = new DefaultListModel<DefaultCustomTabPage>();
        Navigable[] navigableArray2 = navigableArray;
        int n = 0;
        while (n < navigableArray2.length) {
            Navigable navigable = navigableArray2[n];
            defaultListModel.addElement(new DefaultCustomTabPage(navigable.getIcon(), navigable.getShortLabel(), (Object)navigable));
            ++n;
        }
        return defaultListModel;
    }

    public void setSelectedIndex(int n) throws TraversalException {
        String string;
        Traversable traversable;
        Traversable traversable2;
        if (this.m_selectedIdx >= 0 && (traversable2 = this.m_mapPanelSets.get(this.m_navs[this.m_selectedIdx].getShortLabel())) != null) {
            traversable2.onExit(this.m_data);
        }
        if ((traversable = this.m_mapPanelSets.get(string = this.m_navs[n].getShortLabel())) == null) {
            traversable = this.m_navs[n].newTraversable(null);
            this.m_mapPanelSets.put(string, traversable);
            this.m_cardPanel.add(traversable.getComponent(), string);
        }
        this.m_cardLayout.show(this.m_cardPanel, string);
        traversable.onEntry(this.m_data);
        this.m_selectedIdx = n;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_data = traversableContext;
        if (this.m_navs.length > 0) {
            if (this.m_selectedIdx >= 0) {
                String string = this.m_navs[this.m_selectedIdx].getShortLabel();
                Traversable traversable = this.m_mapPanelSets.get(string);
                if (traversable == null) {
                    throw new IllegalStateException("entering without a traversable");
                }
                traversable.onEntry(traversableContext);
            } else {
                this.m_customTab.setSelectedPage(0);
            }
        }
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_selectedIdx >= 0) {
            String string = this.m_navs[this.m_selectedIdx].getShortLabel();
            Traversable traversable = this.m_mapPanelSets.get(string);
            if (traversable == null) {
                throw new IllegalStateException("exiting without a traversable");
            }
            traversable.onExit(traversableContext);
        }
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        Navigable navigable = this.m_navs[this.m_selectedIdx];
        String string = navigable.getShortLabel();
        Traversable traversable = this.m_mapPanelSets.get(string);
        return MetaTraversable.findHelpID((MetaTraversable)navigable, (Traversable)traversable);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_customTab.getSelectedPage();
        if (n != this.m_selectedIdx) {
            try {
                this.setSelectedIndex(n);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)this);
                this.m_customTab.setSelectedPage(this.m_selectedIdx);
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.GRAY);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.m_customTab.getBounds();
        int n = (int)rectangle2.getMaxY();
        int n2 = (int)rectangle.getMaxY() - 1;
        int n3 = 0;
        int n4 = (int)rectangle.getMaxX() - 1;
        graphics.drawLine(n3, n, n3, n2);
        graphics.drawLine(n3, n2, n4, n2);
        graphics.drawLine(n4, n2, n4, n);
        graphics.setColor(color);
    }
}

