/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;

public abstract class BaseInfoPanel
extends DefaultTraversablePanel {
    public static final String TABLESPACES_KEY = "Tablespaces";
    private DBObjectProvider _prov;
    private Verifier _verifier;
    private static final String QUERY_USER_TABLESPACES = "select tablespace_name from sys.user_tablespaces where contents = 'PERMANENT' order by tablespace_name";

    protected BaseInfoPanel() {
    }

    protected final void init(DBObjectProvider dBObjectProvider, Verifier verifier) {
        this._prov = dBObjectProvider;
        this._verifier = verifier;
    }

    protected final DBObjectProvider getProvider() {
        return this._prov;
    }

    protected final Verifier getVerifier() {
        return this._verifier;
    }

    protected final String getInternalName(String string) throws TraversalException {
        if (this._verifier != null) {
            this._verifier.verifyName(string);
        }
        return this._prov.getInternalName(string);
    }

    protected final String getExternalName(String string) {
        return this._prov.getExternalName(string);
    }

    protected static String getUniqueName(String string, DefaultListModel defaultListModel) {
        int n = defaultListModel.size();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            Object e = defaultListModel.getElementAt(n2);
            hashSet.add(e.toString());
            ++n2;
        }
        int n3 = 0;
        String string2 = null;
        while (hashSet.contains(string2 = string + ++n3)) {
        }
        return string2;
    }

    protected String[] getTablespaces(TraversableContext traversableContext, DBObjectProvider dBObjectProvider) {
        String[] stringArray = (String[])traversableContext.find(TABLESPACES_KEY);
        if (stringArray == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (dBObjectProvider instanceof Database) {
                QueryWrapper queryWrapper = new QueryWrapper((Database)dBObjectProvider, QUERY_USER_TABLESPACES);
                try {
                    ResultSet resultSet = queryWrapper.executeQuery();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            traversableContext.put(TABLESPACES_KEY, (Object)stringArray);
        }
        return stringArray;
    }
}

