/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;

public class DBExceptionDialog
extends SQLErrorDialog {
    private JMultiLineLabel _label;
    private JPanel _panel;
    private JLabel _desc;
    private JLabel _object;

    private void $init$() {
        this._label = new JMultiLineLabel();
        this._panel = new JPanel();
        this._desc = new JLabel();
        this._object = new JLabel();
    }

    protected DBExceptionDialog() {
        this.$init$();
    }

    private void setError(DBException dBException) {
        ArrayList<DBException> arrayList = new ArrayList<DBException>();
        while (dBException != null) {
            arrayList.add(dBException);
            dBException = dBException.getNextException();
        }
        if (arrayList.size() > 1) {
            this._desc.setText(UIArb.getString(70));
        } else {
            this._desc.setText(UIArb.getString(71));
        }
        this.setErrors(arrayList);
    }

    protected Component getExceptionComponent() {
        this._panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0);
        this._panel.add((Component)this._desc, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this._panel.add((Component)this._object, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this._label.setPreferredAspectRatio(5.0f);
        this._panel.add((Component)this._label, gridBagConstraints);
        return this._panel;
    }

    protected void updateExceptionComponent(Exception exception) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        DBObject dBObject = ((DBException)((Object)exception)).getObject();
        if (dBObject != null) {
            this._object.setIcon(DBTypeDisplayRegistry.getNodeIcon(dBObject.getType()));
            this._object.setText(DBUtil.getFullyQualifiedName((DBObject)dBObject));
        } else {
            this._object.setIcon(null);
            this._object.setText(null);
        }
        fastStringBuffer.append(exception.getMessage());
        this._label.setText(fastStringBuffer.toString());
    }

    public static void showErrorDialog(Component component, String string, DBException dBException) {
        DBExceptionDialog dBExceptionDialog = new DBExceptionDialog();
        dBExceptionDialog.setError(dBException);
        dBExceptionDialog.runErrorDialog(component, string, null);
    }

    public static boolean showConfirmDialog(Component component, String string, DBException dBException) {
        return DBExceptionDialog.showConfirmDialog(component, string, null, dBException);
    }

    public static boolean showConfirmDialog(Component component, String string, String string2, DBException dBException) {
        DBExceptionDialog dBExceptionDialog = new DBExceptionDialog();
        dBExceptionDialog.setError(dBException);
        return dBExceptionDialog.runConfirmDialog(component, string, string2);
    }
}

