/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;

public class DBEditorFactoryRegistry {
    private static List<Entry> m_factories = new ArrayList<Entry>();

    private DBEditorFactoryRegistry() {
    }

    public static void registerDBEditorFactory(Class clazz, DBEditorFactory dBEditorFactory) {
        m_factories.add(new Entry(clazz, dBEditorFactory));
    }

    public static DBEditorFactory getCreateFactory(DBObjectProvider dBObjectProvider, String string) {
        if (dBObjectProvider != null) {
            Class<?> clazz = dBObjectProvider.getClass();
            ListIterator<Entry> listIterator = m_factories.listIterator(m_factories.size());
            while (listIterator.hasPrevious()) {
                Entry entry = listIterator.previous();
                if (!entry.m_providerClass.isAssignableFrom(clazz) || !entry.m_factory.isCreateSupported(string)) continue;
                return entry.m_factory;
            }
        }
        return null;
    }

    public static DBEditorFactory getEditFactory(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider != null) {
            Class<?> clazz = dBObjectProvider.getClass();
            ListIterator<Entry> listIterator = m_factories.listIterator(m_factories.size());
            while (listIterator.hasPrevious()) {
                Entry entry = listIterator.previous();
                if (!entry.m_providerClass.isAssignableFrom(clazz) || !entry.m_factory.canEditDBObject((DBObject)schemaObject, dBObjectProvider)) continue;
                return entry.m_factory;
            }
        }
        return null;
    }

    private static class Entry {
        Class m_providerClass;
        DBEditorFactory m_factory;

        Entry(Class clazz, DBEditorFactory dBEditorFactory) {
            this.m_providerClass = clazz;
            this.m_factory = dBEditorFactory;
        }
    }
}

