/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDBEditorFactory
implements DBEditorFactory {
    private Map<String, Object> m_libraries;
    private boolean m_updatable;

    private void $init$() {
        this.m_libraries = new HashMap<String, Object>();
        this.m_updatable = true;
    }

    protected BaseDBEditorFactory() {
        this.$init$();
    }

    protected PanelLibrary getPanelLibrary(String string) {
        Object object = this.m_libraries.get(string);
        if (object instanceof Class) {
            try {
                PanelLibrary panelLibrary = (PanelLibrary)((Class)object).newInstance();
                this.initializeLibrary(panelLibrary);
                this.m_libraries.put(string, panelLibrary);
                PanelLibrary panelLibrary2 = panelLibrary;
                return panelLibrary2;
            }
            catch (Exception exception) {
                DBUtil.logStackTrace((Throwable)exception);
            }
        } else if (object instanceof PanelLibrary) {
            return (PanelLibrary)object;
        }
        return null;
    }

    protected void initializeLibrary(PanelLibrary panelLibrary) {
    }

    private boolean purgeLibraryCache() {
        for (String string : this.m_libraries.keySet()) {
            Object object = this.m_libraries.get(string);
            if (!(object instanceof PanelLibrary)) continue;
            this.m_libraries.put(string, object.getClass());
        }
        return true;
    }

    protected void registerLibrary(String string, Class<? extends PanelLibrary> clazz) {
        this.m_libraries.put(string, clazz);
    }

    @Override
    public String[] listSupportedTypes() {
        return this.m_libraries.keySet().toArray(new String[this.m_libraries.size()]);
    }

    @Override
    public boolean isCreateSupported(String string) {
        return this.m_libraries.containsKey(string);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        if (this.m_libraries.containsKey(string)) {
            if (dBObjectProvider instanceof Database) {
                return ((Database)dBObjectProvider).hasPriviledge(string, schema, "CREATE");
            }
            return true;
        }
        return false;
    }

    @Override
    public SchemaObject createDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        return (SchemaObject)this.createDBObject(schema, dBObjectProvider, string, null, true);
    }

    @Override
    public DBObject createDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string, DBObject dBObject, boolean bl) {
        PanelLibrary panelLibrary = this.getPanelLibrary(string);
        if (panelLibrary != null) {
            try {
                schema = schema == null ? dBObjectProvider.getDefaultSchema() : schema;
            }
            catch (DBException dBException) {
                // empty catch block
            }
            DBObject dBObject2 = panelLibrary.getObjectForCreate(schema, dBObjectProvider, dBObject);
            if (this.createDBObject(dBObject2, dBObjectProvider)) {
                return dBObject2;
            }
        }
        return null;
    }

    @Override
    public boolean createDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        Traversable traversable;
        List<Navigable> list;
        PanelLibrary panelLibrary = this.getPanelLibrary(dBObject.getType());
        if (panelLibrary != null && (list = panelLibrary.getCreateNavigables(dBObject, dBObjectProvider)) != null && (traversable = panelLibrary.getMainDialogPanel(dBObject, dBObjectProvider, null, list.toArray(new Navigable[list.size()]))) != null) {
            Map<String, Class> map = panelLibrary.getCreateVerifiers();
            Namespace namespace = this.createNamespace(dBObjectProvider, dBObject, null, map, false);
            namespace.put("PANEL_LIBRARY", (Object)panelLibrary);
            return this.launchDialog(namespace, panelLibrary.getCreateTitle(), traversable, panelLibrary.getSize());
        }
        return false;
    }

    @Override
    public boolean canEditDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        List<Navigable> list;
        String string = dBObject.getType();
        PanelLibrary panelLibrary = this.getPanelLibrary(string);
        if (panelLibrary != null && (list = panelLibrary.getEditNavigables(dBObject, dBObjectProvider)) != null) {
            if (dBObjectProvider instanceof Database) {
                return ((Database)dBObjectProvider).hasPriviledge(string, DBUtil.getSchema((DBObject)dBObject), "MODIFY");
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return this.editDBObject(dBObject, dBObjectProvider, null);
    }

    @Override
    public boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider, DBObject dBObject2) {
        Traversable traversable;
        List<Navigable> list;
        PanelLibrary panelLibrary = this.getPanelLibrary(dBObject.getType());
        if (panelLibrary != null && (list = panelLibrary.getEditNavigables(dBObject, dBObjectProvider)) != null && (traversable = panelLibrary.getMainDialogPanel(dBObject, dBObjectProvider, dBObject2, list.toArray(new Navigable[list.size()]))) != null) {
            Map<String, Class> map = panelLibrary.getEditVerifiers();
            Namespace namespace = this.createNamespace(dBObjectProvider, dBObject, dBObject2, map, true);
            namespace.put("PANEL_LIBRARY", (Object)panelLibrary);
            return this.launchDialog(namespace, panelLibrary.getEditTitle(), traversable, panelLibrary.getSize());
        }
        return false;
    }

    @Override
    public String getCreateLabel(String string) {
        PanelLibrary panelLibrary = this.getPanelLibrary(string);
        if (panelLibrary != null) {
            return panelLibrary.getCreateText();
        }
        return null;
    }

    protected Namespace createNamespace(DBObjectProvider dBObjectProvider, DBObject dBObject, DBObject dBObject2, Map<String, Class> map, boolean bl) {
        DBObject dBObject3 = null;
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)dBObjectProvider);
        if (dBObject != null) {
            DBObject dBObject4;
            if (bl) {
                dBObject3 = dBObject.copyTo(null, true);
                namespace.put("OriginalObject", (Object)dBObject);
                namespace.put("NewObject", (Object)dBObject3);
            } else {
                namespace.put("NewObject", (Object)dBObject);
            }
            if (dBObject2 != null && dBObject3 != null && (dBObject4 = DBUtil.findChildInCopy((DBObject)dBObject, (DBObject)dBObject3, (DBObject)dBObject2)) != null) {
                namespace.put("DefaultChild", (Object)dBObject4);
            }
            try {
                Schema schema = DBUtil.getSchema((DBObject)dBObject);
                namespace.put("Schema", (Object)schema);
                Schema[] schemaArray = dBObjectProvider.listSchemas();
                namespace.put("SchemaList", (Object)schemaArray);
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), UIArb.getString(76), (SQLException)throwable);
                }
                DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), UIArb.getString(76), dBException);
            }
            if (map != null) {
                for (String string : map.keySet()) {
                    Class clazz = map.get(string);
                    try {
                        Object t = clazz.newInstance();
                        if (t instanceof Verifier) {
                            SchemaObject schemaObject = dBObject instanceof SchemaObject ? (SchemaObject)dBObject : DBUtil.getSchemaObject((DBObject)dBObject);
                            Verifier verifier = (Verifier)t;
                            if (dBObject3 == null) {
                                verifier.initializeVerifier(dBObjectProvider, null, schemaObject);
                            } else {
                                SchemaObject schemaObject2 = dBObject3 instanceof SchemaObject ? (SchemaObject)dBObject3 : DBUtil.getSchemaObject((DBObject)dBObject3);
                                verifier.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
                            }
                            verifier.setEditable(this.m_updatable);
                        }
                        namespace.put(string, t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return namespace;
    }

    private boolean launchDialog(Namespace namespace, String string, Traversable traversable, Dimension dimension) {
        TDialogLauncher tDialogLauncher;
        Frame frame = IdeUtil.getMainWindow();
        if (dimension == null) {
            tDialogLauncher = new TDialogLauncher((Component)frame, string, traversable, namespace, (DialogRunnerCallback)new SizeKeeperCallback("edit.object"));
        } else {
            tDialogLauncher = new TDialogLauncher((Component)frame, string, traversable, namespace);
            tDialogLauncher.setInitialSize(dimension);
        }
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        return tDialogLauncher.showDialog();
    }
}

