/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;

public class TablePicker
extends AbstractPicker {
    private DBObjectProvider m_prov;
    private Schema m_schema;
    private Verifier m_verifier;

    public TablePicker() {
        Handler handler = new Handler(null);
        super.setEncoder((AbstractPicker.PickerValueEncoder)handler);
        super.setValidator((AbstractPicker.PickerResultValidator)handler);
        super.setEditor((ComboBoxEditor)new Editor(this.getEditor()));
        super.setRenderer((ListCellRenderer)new DBObjectRenderer());
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_prov = dBObjectProvider;
    }

    public DBObjectProvider getProvider() {
        return this.m_prov;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public void setVerifier(Verifier verifier) {
        this.m_verifier = verifier;
    }

    public Verifier getVerifier() {
        return this.m_verifier;
    }

    protected void doBrowse() {
    }

    public void setSelectedItem(Object object) {
        if (object instanceof String) {
            MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.getModel();
            int n = 0;
            while (n < mutableComboBoxModel.getSize()) {
                String string = (String)mutableComboBoxModel.getElementAt(n);
                if (string.equals(object)) {
                    object = string;
                    break;
                }
                ++n;
            }
        }
        super.setSelectedItem(object);
    }

    public Table getTable() throws TraversalException {
        String string = (String)this.getSelectedItem();
        Table table = null;
        if (this.m_schema != null) {
            try {
                table = (Table)this.m_prov.getObject("TABLE", this.m_schema, string);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (table == null) {
            throw new TraversalException(null, UIArb.getString(381));
        }
        return table;
    }

    static DBObjectProvider ra$m_prov(TablePicker tablePicker) {
        return tablePicker.m_prov;
    }

    private class Handler
    implements AbstractPicker.PickerResultValidator,
    AbstractPicker.PickerValueEncoder {
        public Object encodeValue(Object object) {
            Object object2 = null;
            if (object instanceof Table) {
                object2 = object;
            }
            return object2;
        }

        public boolean isResultValid(Object object) {
            return object instanceof Table;
        }

        public String getInvalidValueMsg(Object object) {
            return "";
        }

        private Handler() {
        }

        Handler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Editor
    implements ComboBoxEditor {
        private ComboBoxEditor m_editor;

        public Editor(ComboBoxEditor comboBoxEditor) {
            this.m_editor = comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.m_editor.getEditorComponent();
        }

        public void setItem(Object object) {
            Component component;
            this.m_editor.setItem(object);
            if (object != null && (component = this.m_editor.getEditorComponent()) instanceof JTextField && TablePicker.ra$m_prov(TablePicker.this) != null) {
                String string = null;
                string = object instanceof DBObject ? TablePicker.ra$m_prov(TablePicker.this).getExternalName(((DBObject)object).getName()) : object.toString();
                ((JTextField)component).setText(string);
            }
        }

        public Object getItem() {
            return this.m_editor.getItem();
        }

        public void selectAll() {
            this.m_editor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.m_editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.m_editor.removeActionListener(actionListener);
        }
    }
}

