/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SearchableTextArea
extends JTextArea {
    public static final String PREFS_KEY = "oracle.ide.db.controls.SearchableTextArea";
    public static final String PREFS_CASE_KEY = "oracle.ide.db.controls.SearchableTextArea.CASE";

    public SearchableTextArea() {
        this((String)null);
    }

    public SearchableTextArea(String string) {
        super(string);
        this.addKeyListener(new KL(null));
    }

    private class KL
    extends KeyAdapter {
        private JEWTDialog m_dialog;
        private JComboBox m_search;
        private DefaultComboBoxModel m_searchModel;
        private JCheckBox m_case;

        private List getPrefs() {
            DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
            return databaseIdePreferences.getProperties().getOrCreateListStructure(SearchableTextArea.PREFS_KEY);
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.isControlDown() && 70 == n) {
                if (this.m_dialog == null) {
                    this.m_searchModel = new DefaultComboBoxModel();
                    Iterator iterator = this.getPrefs().iterator();
                    while (iterator.hasNext()) {
                        this.m_searchModel.addElement(iterator.next());
                    }
                    this.m_search = new JComboBox(this.m_searchModel);
                    this.m_search.setEditable(true);
                    this.m_dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)SearchableTextArea.this), (String)"Find Text", (int)3);
                    this.m_case = new JCheckBox();
                    this.m_case.setSelected(DatabaseIdePreferences.getPreferences().getProperties().getBoolean(SearchableTextArea.PREFS_CASE_KEY, false));
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new GridBagLayout());
                    JLabel jLabel = new JLabel();
                    ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_search, (String)"&Text to Search For:");
                    ResourceUtils.resButton((AbstractButton)this.m_case, (String)"&Match Case");
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.insets.left = 10;
                    gridBagConstraints.insets.bottom = 10;
                    jPanel.add((Component)jLabel, gridBagConstraints);
                    gridBagConstraints.gridy = 1;
                    jPanel.add((Component)this.m_case, gridBagConstraints);
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    jPanel.add((Component)this.m_search, gridBagConstraints);
                    this.m_dialog.setContent((Component)jPanel);
                    this.m_dialog.setPreferredSize(300, 150);
                    this.m_dialog.setInitialFocus((Component)this.m_search);
                }
                if (this.m_dialog.runDialog()) {
                    String string = (String)this.m_search.getSelectedItem();
                    if (ModelUtil.hasLength((String)string)) {
                        boolean bl = false;
                        List list = this.getPrefs();
                        int n2 = 0;
                        while (n2 < this.m_searchModel.getSize()) {
                            String string2 = (String)this.m_searchModel.getElementAt(n2);
                            boolean bl2 = bl = bl || string.equals(string2);
                            if (!list.contains(string2) && list.size() > 15) {
                                list.add(string2);
                            }
                            ++n2;
                        }
                        if (!bl) {
                            this.m_searchModel.insertElementAt(string, 0);
                            if (!list.contains(string)) {
                                if (list.size() == 0) {
                                    list.add(string);
                                } else {
                                    list.add(0, string);
                                }
                            }
                        }
                        this.doSearch(true);
                    }
                    DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
                    databaseIdePreferences.getProperties().putBoolean(SearchableTextArea.PREFS_CASE_KEY, this.m_case.isSelected());
                }
                keyEvent.consume();
            } else if (114 == n && this.m_dialog != null) {
                this.doSearch(keyEvent.isShiftDown() ^ true);
                keyEvent.consume();
            }
        }

        private void doSearch(boolean bl) {
            try {
                String string = (String)this.m_search.getSelectedItem();
                if (ModelUtil.hasLength((String)string)) {
                    String string2 = SearchableTextArea.this.getText();
                    if (!this.m_case.isSelected()) {
                        string = string.toUpperCase();
                        string2 = string2.toUpperCase();
                    }
                    int n = -1;
                    if (bl) {
                        n = string2.indexOf(string, SearchableTextArea.this.getCaretPosition());
                    } else {
                        int n2 = SearchableTextArea.this.getSelectionStart() - 1;
                        if (n2 < 0) {
                            n2 = SearchableTextArea.this.getCaretPosition() - 1;
                        }
                        if (n2 >= 0) {
                            n = string2.lastIndexOf(string, n2);
                        }
                    }
                    if (n >= 0) {
                        SearchableTextArea.this.setCaretPosition(n);
                        SearchableTextArea.this.setSelectionStart(n);
                        SearchableTextArea.this.setSelectionEnd(n + string.length());
                    } else {
                        MessageDialog.error((Component)SearchableTextArea.this, (Object)"The search text was not found", (String)"Find Result", null);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private KL() {
        }

        KL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

