/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import javax.swing.JComboBox;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;

public class SchemaPicker
extends JComboBox {
    private DBObjectProvider m_prov;
    private Schema[] m_schemas;

    public SchemaPicker() {
        this.setModel(new NonNullableComboBoxModel());
    }

    private DBObjectProvider getProvider() {
        if (this.m_prov == null) {
            throw new IllegalStateException("schema picker hasn't been initialized with a provider");
        }
        return this.m_prov;
    }

    public Schema getSchema() throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        Schema schema = null;
        if (!(dBObjectProvider instanceof JdbcDatabase) || ((JdbcDatabase)dBObjectProvider).isUseSchema()) {
            String string = (String)this.getSelectedItem();
            if (!dBObjectProvider.isValidName("SCHEMA", string)) {
                String string2 = UIArb.format(419, string);
                throw new TraversalException(string2, UIArb.getString(381));
            }
            string = dBObjectProvider.getInternalName(string);
            if (this.m_schemas == null) {
                try {
                    this.m_schemas = dBObjectProvider.listSchemas();
                }
                catch (DBException dBException) {
                    String string3 = dBException.getMessage();
                    throw new TraversalException(string3, UIArb.getString(381));
                }
            }
            int n = 0;
            while (n < this.m_schemas.length) {
                if (string.equals(this.m_schemas[n].getName())) {
                    schema = this.m_schemas[n];
                    break;
                }
                ++n;
            }
            if (schema == null) {
                try {
                    schema = dBObjectProvider.getSchema(string);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (schema == null) {
                schema = new Schema(string);
                try {
                    dBObjectProvider.validateObject((DBObject)schema);
                }
                catch (ValidationException validationException) {
                    String string4 = validationException.getMessage();
                    throw new TraversalException(string4, UIArb.getString(381));
                }
            }
        }
        return schema;
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema) {
        Schema[] schemaArray = null;
        try {
            schemaArray = dBObjectProvider.listSchemas();
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog((Component)this, UIArb.getString(381), dBException);
        }
        this.init(dBObjectProvider, schema, schemaArray);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, Schema[] schemaArray) {
        this.m_prov = dBObjectProvider;
        this.m_schemas = schemaArray;
        this.removeAllItems();
        boolean bl = false;
        if (this.m_schemas != null) {
            int n = 0;
            while (n < this.m_schemas.length) {
                this.addItem(this.m_schemas[n]);
                if (!bl && schema != null && this.m_schemas[n].getName().equals(schema.getName())) {
                    bl = true;
                }
                ++n;
            }
        }
        if (schema == null) {
            try {
                schema = dBObjectProvider.getDefaultSchema();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (schema != null) {
            if (!bl) {
                this.addItem(schema);
            }
            this.setSelectedItem(schema);
        }
    }

    public void initWithOneSchema(DBObjectProvider dBObjectProvider, Schema schema) {
        this.m_prov = dBObjectProvider;
        this.removeAllItems();
        this.addItem(schema);
        this.setSelectedItem(schema);
    }

    public void addItem(Object object) {
        super.addItem(this.convertToString(object));
    }

    public void removeItem(Object object) {
        super.removeItem(this.convertToString(object));
    }

    public void setSelectedItem(Object object) {
        super.setSelectedItem(this.convertToString(object));
    }

    private String convertToString(Object object) {
        if (object instanceof Schema) {
            object = this.getProvider().getExternalName(((Schema)object).getName());
        } else if (object != null) {
            object = object.toString();
        }
        return (String)object;
    }
}

