/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectListPicker;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;

public class SchemaObjectTargetPicker
extends DBObjectListPicker
implements Traversable,
ShuttleListener,
ListSelectionListener,
DocumentListener {
    private JPanel m_panel;
    private JLabel m_label;
    private JTextField m_newName;
    private boolean m_rename;
    private int m_current;
    private boolean m_commitPending;
    private boolean m_ignoreList;
    private boolean m_ignoreField;
    private DBObjectProvider m_provider;

    private void $init$() {
        this.m_current = -1;
    }

    public SchemaObjectTargetPicker() {
        this(new JList());
    }

    public SchemaObjectTargetPicker(JList jList) {
        super(jList);
        this.$init$();
    }

    private void setupRenamePanel() {
        this.m_panel = new JPanel();
        this.m_label = new JLabel();
        this.m_newName = new JTextField();
        ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_newName, (String)UIArb.getString(181));
        this.getList().addListSelectionListener(this);
        this.m_panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.m_panel.add(super.getComponent(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.m_panel.add((Component)this.m_label, gridBagConstraints);
        this.m_newName.getDocument().addDocumentListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_newName, gridBagConstraints);
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    public void setCanRename(boolean bl) {
        this.m_rename = bl;
    }

    private void populateName() {
        this.m_ignoreField = true;
        try {
            this.m_newName.setText(null);
            SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)this.getList().getSelectedValue();
            Object[] objectArray = this.getList().getSelectedValues();
            if (schemaObjectDescriptor != null && objectArray != null && objectArray.length == 1) {
                this.m_newName.setEnabled(true);
                String string = schemaObjectDescriptor.getName();
                this.m_newName.setText(this.m_provider != null ? this.m_provider.getExternalName(string) : string);
                this.m_current = this.getList().getSelectedIndex();
            } else {
                this.m_newName.setEnabled(false);
                this.m_newName.setText(null);
                this.m_current = -1;
            }
        }
        finally {
            this.m_commitPending = false;
            this.m_ignoreField = false;
        }
    }

    private boolean commitName(boolean bl) {
        SchemaObjectDescriptor schemaObjectDescriptor;
        if (this.m_current > -1 && this.m_commitPending && (schemaObjectDescriptor = (SchemaObjectDescriptor)this.getList().getModel().getElementAt(this.m_current)) != null) {
            Collection collection;
            boolean bl2;
            String string;
            boolean bl3 = false;
            String string2 = this.m_newName.getText().trim();
            String string3 = schemaObjectDescriptor.getOriginalName();
            if (this.m_provider != null) {
                try {
                    this.m_provider.validateName(schemaObjectDescriptor.getType(), string2);
                }
                catch (InvalidNameException invalidNameException) {
                    if (bl) {
                        MessageDialog.error((Component)this.getList(), (Object)invalidNameException.getMessage(), (String)UIArb.getString(188), null);
                    }
                    bl3 = true;
                }
            }
            String string4 = string = this.m_provider != null ? this.m_provider.getInternalName(string2) : string2;
            if (!bl3 && ModelUtil.areDifferent((Object)string, (Object)string3) && (bl2 = (collection = this.getExistingNames(schemaObjectDescriptor)).contains(string))) {
                if (bl) {
                    MessageDialog.error((Component)this.getList(), (Object)UIArb.format(187, schemaObjectDescriptor.getName()), (String)UIArb.getString(188), null);
                }
                bl3 = true;
            }
            if (bl3) {
                this.m_ignoreList = true;
                try {
                    this.getList().setSelectedIndex(this.m_current);
                    this.m_newName.requestFocusInWindow();
                }
                finally {
                    this.m_ignoreList = false;
                }
                return false;
            }
            if (ModelUtil.hasLength((String)string) && ModelUtil.areDifferent((Object)string, (Object)schemaObjectDescriptor.getOriginalName())) {
                schemaObjectDescriptor.setName(string);
            } else {
                schemaObjectDescriptor.setName(null);
            }
            this.getList().repaint();
        }
        return true;
    }

    private Collection getExistingNames(SchemaObjectDescriptor schemaObjectDescriptor) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        int n = 0;
        while (n < defaultListModel.size()) {
            SchemaObjectDescriptor schemaObjectDescriptor2 = (SchemaObjectDescriptor)defaultListModel.get(n);
            if (schemaObjectDescriptor == null || schemaObjectDescriptor != schemaObjectDescriptor2) {
                arrayList.add(schemaObjectDescriptor2.getName());
            }
            ++n;
        }
        return arrayList;
    }

    public Component getComponent() {
        if (this.m_panel == null && this.m_rename) {
            this.setupRenamePanel();
        }
        if (this.m_panel != null) {
            return this.m_panel;
        }
        return super.getComponent();
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (!this.commitName(false)) {
            return false;
        }
        if (!(this.getList().getModel() instanceof DefaultListModel)) {
            return false;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        ListSelectionModel listSelectionModel = this.getList().getSelectionModel();
        this.m_ignoreList = true;
        listSelectionModel.clearSelection();
        this.m_ignoreList = false;
        int n = defaultListModel.getSize();
        int n2 = 0;
        int n3 = 0;
        while (n3 < transferableArray.length) {
            if (transferableArray[n3] instanceof DBObjectTransferable) {
                this.cachePath((DBObjectTransferable)transferableArray[n3]);
                DBObject dBObject = ((DBObjectTransferable)transferableArray[n3]).getDBObject();
                if (dBObject instanceof SchemaObject) {
                    String string;
                    Collection collection;
                    SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor((SchemaObject)dBObject);
                    if (this.m_rename && (collection = this.getExistingNames(null)).contains(string = schemaObjectDescriptor.getName())) {
                        boolean bl = true;
                        Table table = null;
                        MaterializedViewLog materializedViewLog = null;
                        String string2 = null;
                        if (dBObject instanceof Table) {
                            table = (Table)dBObject;
                            string2 = "MATERIALIZED VIEW LOG";
                        } else if (dBObject instanceof MaterializedViewLog) {
                            materializedViewLog = (MaterializedViewLog)dBObject;
                            string2 = "TABLE";
                        }
                        if (string2 != null) {
                            int n4 = 0;
                            while (n4 < defaultListModel.size()) {
                                SchemaObjectDescriptor schemaObjectDescriptor2 = (SchemaObjectDescriptor)defaultListModel.get(n4);
                                if (schemaObjectDescriptor2.getObject().getType().equals(string2) && schemaObjectDescriptor2.getName().equals(dBObject.getName())) {
                                    bl = false;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (bl) {
                            schemaObjectDescriptor.setName(DBUtil.getUniqueName((Collection)collection, (String)string));
                        }
                    }
                    int n5 = defaultListModel.getSize();
                    defaultListModel.add(n5, schemaObjectDescriptor);
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            this.m_ignoreList = true;
            listSelectionModel.setSelectionInterval(n, n + n2 - 1);
            this.m_ignoreList = false;
        }
        return true;
    }

    public void removeSelectedItems() {
        this.m_current = -1;
        super.removeSelectedItems();
    }

    public void removeAllSelectableItems() {
        this.m_current = -1;
        super.removeAllSelectableItems();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this.commitName(true)) {
            throw new TraversalException(null);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_provider = (DBObjectProvider)traversableContext.get("TargetDBObjectProvider");
        if (this.m_rename && this.m_newName != null) {
            this.populateName();
        }
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public String getHelpID() {
        return null;
    }

    public Object getExitTransition() {
        return null;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.m_ignoreList && this.commitName(true)) {
            this.populateName();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        if (this.getList().getSelectedIndex() != this.m_current) {
            this.populateName();
        }
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.populateName();
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
        this.populateName();
    }
}

