/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public class SchemaObjectComboBox
extends JComboBox
implements ListCellRenderer {
    private DBObjectProvider _pro;
    private DefaultListCellRenderer _delegate;
    private boolean _showIcon;

    private void $init$() {
        this._pro = null;
        this._delegate = new DefaultListCellRenderer();
        this._showIcon = false;
    }

    public SchemaObjectComboBox() {
        this.$init$();
        this.setRenderer(this);
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, String ... stringArray) {
        this._pro = dBObjectProvider;
        this._showIcon = stringArray.length > 1;
        this.removeAllItems();
        SchemaObject[] schemaObjectArray = new SchemaObject[]{};
        try {
            schemaObjectArray = dBObjectProvider.listObjects(stringArray, schema);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        SchemaObject[] schemaObjectArray2 = schemaObjectArray;
        int n = 0;
        while (n < schemaObjectArray2.length) {
            SchemaObject schemaObject = schemaObjectArray2[n];
            SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor(schemaObject);
            this.addItem(schemaObjectDescriptor);
            ++n;
        }
    }

    public void initWithOneItem(SchemaObject schemaObject) {
        this.removeAllItems();
        SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor(schemaObject);
        this.addItem(schemaObjectDescriptor);
        this.setSelectedItem(schemaObjectDescriptor);
    }

    public SchemaObject getSchemaObject() {
        SchemaObject schemaObject = null;
        SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)super.getSelectedItem();
        if (schemaObjectDescriptor != null) {
            try {
                schemaObject = schemaObjectDescriptor.unwrapDescriptor(this._pro);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        String string = schemaObject == null ? "" : schemaObject.getName();
        String string2 = schemaObject == null ? "" : schemaObject.getType();
        ComboBoxModel comboBoxModel = this.getModel();
        boolean bl = false;
        int n = 0;
        while (n < comboBoxModel.getSize()) {
            String string3;
            SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)comboBoxModel.getElementAt(n);
            String string4 = schemaObjectDescriptor == null ? "" : schemaObjectDescriptor.getName();
            String string5 = string3 = schemaObjectDescriptor == null ? "" : schemaObjectDescriptor.getType();
            if (string4.equals(string) && string3.equals(string2)) {
                bl = true;
                break;
            }
            ++n;
        }
        SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor(schemaObject);
        if (bl) {
            this.removeItem(schemaObjectDescriptor);
        }
        this.addItem(schemaObjectDescriptor);
        this.setSelectedItem(schemaObjectDescriptor);
    }

    public void setShowIcon(boolean bl) {
        this._showIcon = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)object;
        String string = schemaObjectDescriptor == null ? null : schemaObjectDescriptor.getName();
        JLabel jLabel = (JLabel)this._delegate.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        if (this._showIcon && schemaObjectDescriptor != null) {
            jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon(schemaObjectDescriptor.getType()));
        }
        return jLabel;
    }

    public void addItem(Object object) {
        super.addItem(object);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        super.setModel(comboBoxModel);
    }
}

