/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;

public class NameTextField
extends JTextField
implements DocumentListener {
    private boolean m_listening;
    private Timer m_timer;
    private LiveValidationController m_vController;
    private DBObject m_originalObject;
    private DBObject m_dbObject;
    private DBObjectProvider m_pro;

    public NameTextField() {
        this.setColumns(30);
        this.getDocument().addDocumentListener(this);
        this.m_vController = new LiveValidationController(this);
    }

    public void init(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        this.init(dBObject, null, dBObjectProvider);
    }

    public void init(DBObject dBObject, DBObject dBObject2, DBObjectProvider dBObjectProvider) {
        this.m_originalObject = dBObject2;
        this.m_pro = dBObjectProvider;
        this.m_dbObject = dBObject;
        this.setText(dBObjectProvider.getExternalName(dBObject.getName(), dBObject.getType()));
        this.m_listening = true;
    }

    public void commit() throws TraversalException {
        String string = this.commitIdentifier();
        if (string != null) {
            throw new TraversalException(string);
        }
        this.m_listening = false;
    }

    protected Timer getTimer() {
        if (this.m_timer == null) {
            1 var1_1 = new 1();
            this.m_timer = new Timer(1500, var1_1);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    private String commitIdentifier() {
        this.getTimer().stop();
        if (this.m_dbObject != null && this.m_listening) {
            Object object;
            String string;
            boolean bl;
            String string2 = this.m_dbObject.getType();
            String string3 = this.m_dbObject.getName();
            String string4 = this.getText();
            try {
                this.m_pro.validateName(string2, string4);
            }
            catch (ValidationException validationException) {
                String string5 = validationException.getLocalizedMessage();
                return string5;
            }
            string4 = this.m_pro.getInternalName(string4, string2);
            this.m_dbObject.setName(string4);
            if (this.m_dbObject instanceof SchemaObject) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.m_dbObject, "name", string3, string4);
                DBObjectChange.firePropertyChanged((SchemaObject)((SchemaObject)this.m_dbObject), (PropertyChangeEvent)propertyChangeEvent);
            }
            boolean bl2 = bl = this.m_originalObject != null && string4.equals(this.m_originalObject.getName());
            if (!bl && !string4.equals(string = this.m_pro.getUniqueName(string2, object = this.m_dbObject instanceof SchemaObject ? ((SchemaObject)this.m_dbObject).getSchema() : this.m_dbObject.getParent(), string4))) {
                return UIArb.getString(77);
            }
        }
        return null;
    }

    protected void showNameError(String string) {
        this.m_vController.showError(string);
    }

    public void setEnabled(boolean bl) {
        this.m_vController.hidePopup();
        super.setEnabled(bl);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.m_listening) {
            this.getTimer().restart();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.m_listening) {
            this.getTimer().restart();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.m_listening) {
            this.getTimer().restart();
        }
    }

    static String mav$commitIdentifier(NameTextField nameTextField) {
        return nameTextField.commitIdentifier();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NameTextField.this.showNameError(NameTextField.mav$commitIdentifier(NameTextField.this));
        }
    }
}

