/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameTextField;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;

public class NameAndSchemaEditor
extends DefaultTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list;
    private final SchemaPicker _cmbOwner;
    private final NameTextField _fldName;
    private JLabel _lblPlsqlLowerCase;
    private JCheckBox _chkPlsqlLowerCase;
    protected boolean _listening;
    private SchemaObject _originalObject;
    private Schema[] _schemas;
    private SchemaObject _schemaObject;
    private DBObjectProvider _pro;
    private SchemaObjectInfoVerifier _verifier;

    private void $init$() {
        this.m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
        this._cmbOwner = new SchemaPicker();
        this._fldName = new NameTextField();
        this._lblPlsqlLowerCase = new JLabel();
        this._chkPlsqlLowerCase = new JCheckBox();
        this._verifier = null;
    }

    public NameAndSchemaEditor() {
        this.$init$();
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._cmbOwner.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbOwner, (String)UIArb.getString(72));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._fldName, (String)UIArb.getString(73));
        this._fldName.setColumns(15);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._fldName, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this._chkPlsqlLowerCase, (String)UIArb.getString(726));
        jPanel.add((Component)this._chkPlsqlLowerCase, new GridBagConstraints(0, 100, 0, 0, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void commitSchema() throws TraversalException {
        Schema schema = this._schemaObject.getSchema();
        Schema schema2 = this._cmbOwner.getSchema();
        this._schemaObject.setSchema(schema2);
        DBObjectChange.firePropertyChanged((SchemaObject)this._schemaObject, (PropertyChangeEvent)new PropertyChangeEvent(this._schemaObject, "schema", schema, schema2));
    }

    private Schema[] validateSchemaPermissions(Schema[] schemaArray) {
        if (this._pro instanceof Database) {
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            String string = this._schemaObject.getType();
            int n = 0;
            while (n < schemaArray.length) {
                if (this._pro.hasPriviledge(string, schemaArray[n], this.isEditing() ? "MODIFY" : "CREATE")) {
                    arrayList.add(schemaArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new Schema[arrayList.size()]);
        }
        return schemaArray;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this._verifier;
    }

    protected SchemaPicker getSchemaPicker() {
        return this._cmbOwner;
    }

    protected DBObjectProvider getProvider() {
        return this._pro;
    }

    protected SchemaObject getSchemaObject() {
        return this._schemaObject;
    }

    protected boolean isEditing() {
        return this._originalObject != null;
    }

    protected void init(SchemaObject schemaObject, SchemaObject schemaObject2, SchemaObjectInfoVerifier schemaObjectInfoVerifier, DBObjectProvider dBObjectProvider, Schema[] schemaArray) {
        this._originalObject = schemaObject2;
        this._pro = dBObjectProvider;
        this._schemaObject = schemaObject;
        this._schemas = schemaArray;
        this._verifier = schemaObjectInfoVerifier;
        this._cmbOwner.init(this._pro, schemaObject.getSchema(), this.validateSchemaPermissions(this._schemas));
        this._fldName.init((DBObject)schemaObject, (DBObject)schemaObject2, dBObjectProvider);
        this._cmbOwner.setEnabled(this._verifier == null || this._verifier.canChangeSchema());
        this._cmbOwner.setEditable(this._verifier == null && !(dBObjectProvider instanceof Database) || this._verifier != null && this._verifier.canCreateSchema());
        this._fldName.setEnabled(this._verifier == null || this._verifier.canChangeName());
        this._listening = true;
        if (this._schemaObject instanceof SourceObject) {
            this._lblPlsqlLowerCase.setVisible(true);
            this._chkPlsqlLowerCase.setVisible(true);
            this._chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
        } else {
            this._lblPlsqlLowerCase.setVisible(false);
            this._chkPlsqlLowerCase.setVisible(false);
        }
    }

    public void commit() throws TraversalException {
        this._listening = false;
        this.commitSchema();
        this._fldName.commit();
        if (this._schemaObject instanceof SourceObject) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this._chkPlsqlLowerCase.isSelected());
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Schema[] schemaArray = (Schema[])traversableContext.get("SchemaList");
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        SchemaObjectInfoVerifier schemaObjectInfoVerifier = (SchemaObjectInfoVerifier)traversableContext.get("SchemaObjectInfoVerifier");
        this.init(schemaObject, schemaObject2, schemaObjectInfoVerifier, dBObjectProvider, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._listening) {
            try {
                this.commitSchema();
                this._fldName.getTimer().restart();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        this.m_list.add(headerPanelListener);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        return this.m_list.remove(headerPanelListener);
    }

    protected final void changePanels(String string, Navigable[] navigableArray) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener headerPanelListener : this.m_list) {
            headerPanelListener.panelSetChange(string, navigableArray);
        }
    }
}

