/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.HashStructure;

public class NameAndSchemaAdvancedEditor
extends NameAndSchemaEditor
implements PanelLibrary.HeaderPanel {
    protected static final String SIMPLE = "Simple";
    private JCheckBox m_advanced;
    private boolean m_enteredOnce;
    private PanelLibrary m_panels;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_advanced = new JCheckBox();
        this.m_enteredOnce = false;
    }

    public NameAndSchemaAdvancedEditor() {
        this.$init$();
        this.m_advanced.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this.m_advanced, (String)UIArb.getString(407));
        this.add(this.m_advanced, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_advanced.addActionListener(this);
    }

    static {
        $assertionsDisabled = NameAndSchemaAdvancedEditor.class.desiredAssertionStatus() ^ true;
    }

    public void onEntry(TraversableContext traversableContext) {
        block7: {
            super.onEntry(traversableContext);
            if (!this.m_enteredOnce) {
                this.m_enteredOnce = true;
                this.m_panels = (PanelLibrary)traversableContext.find("PANEL_LIBRARY");
                if (this.isEditing()) {
                    this.m_advanced.setVisible(false);
                } else {
                    this.m_advanced.setVisible(true);
                    if (this.getAdvancedPreference()) {
                        this.m_advanced.setSelected(true);
                    } else {
                        this.m_advanced.setSelected(false);
                        try {
                            this.showSimplePanel();
                        }
                        catch (TraversalException traversalException) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)traversalException.getMessage());
                        }
                    }
                }
            }
        }
    }

    protected void showSimplePanel() throws TraversalException {
        this.changePanels(SIMPLE, this.getSimpleNavigables());
    }

    protected final Navigable[] getSimpleNavigables() {
        List<Navigable> list = this.getPanelLibrary().getSimpleNavigables();
        return list == null ? new Navigable[]{} : list.toArray(new Navigable[list.size()]);
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.changePanels("DEFAULT_PANEL", null);
    }

    protected boolean isAdvancedLayout() {
        return this.m_advanced.isSelected();
    }

    protected PanelLibrary getPanelLibrary() {
        if (!this.m_enteredOnce) {
            throw new IllegalStateException("can't get panel library until onEntry has been called");
        }
        return this.m_panels;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_advanced) {
            if (this.m_advanced.isSelected()) {
                try {
                    this.showAdvancedPanel();
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(false);
                }
            } else {
                try {
                    this.showSimplePanel();
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(true);
                }
            }
            this.saveAdvancedPreference();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this.saveAdvancedPreference();
    }

    private void saveAdvancedPreference() {
        DatabaseIdePreferences databaseIdePreferences;
        String string = this.getAdvancedPropertyKey();
        if (string != null && (databaseIdePreferences = DatabaseIdePreferences.getPreferences()) != null) {
            HashStructure hashStructure = databaseIdePreferences.getProperties();
            hashStructure.putBoolean(string, this.m_advanced.isSelected());
        }
    }

    private boolean getAdvancedPreference() {
        DatabaseIdePreferences databaseIdePreferences;
        String string = this.getAdvancedPropertyKey();
        if (string != null && (databaseIdePreferences = DatabaseIdePreferences.getPreferences()) != null) {
            HashStructure hashStructure = databaseIdePreferences.getProperties();
            return hashStructure.getBoolean(string, false);
        }
        return false;
    }

    protected final String getAdvancedPropertyKey() {
        return this.getPanelLibrary().getType() + "_ADVANCED_EDITOR";
    }
}

