/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.DatabaseLink;

public class NameAndPublicSchemaEditor
extends NameAndSchemaEditor {
    public static final String PUBLIC = "PUBLIC";
    private Schema m_lastSchema;
    private JCheckBox m_chkPublic;

    private void $init$() {
        this.m_chkPublic = new JCheckBox();
    }

    public NameAndPublicSchemaEditor() {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.m_chkPublic, (String)UIArb.getString(246));
        this.m_chkPublic.addActionListener(this);
        this.add(this.m_chkPublic, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void commit() throws TraversalException {
        super.commit();
        boolean bl = this.m_chkPublic.isSelected();
        this.commitPublic(bl);
    }

    private void commitPublic(boolean bl) {
        SchemaObject schemaObject = this.getSchemaObject();
        if (schemaObject instanceof Synonym) {
            ((Synonym)schemaObject).setPublic(bl);
        } else if (schemaObject instanceof DatabaseLink) {
            ((DatabaseLink)schemaObject).setPublic(bl);
        }
    }

    public void init(SchemaObject schemaObject, SchemaObject schemaObject2, SchemaObjectInfoVerifier schemaObjectInfoVerifier, DBObjectProvider dBObjectProvider, Schema[] schemaArray) {
        super.init(schemaObject, schemaObject2, schemaObjectInfoVerifier, dBObjectProvider, schemaArray);
        boolean bl = false;
        if (schemaObject instanceof Synonym) {
            bl = ((Synonym)schemaObject).isPublic();
        } else if (schemaObject instanceof DatabaseLink) {
            bl = ((DatabaseLink)schemaObject).isPublic();
        }
        this.setSchema(bl);
        this.m_chkPublic.setEnabled(schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canChangeSchema());
    }

    private void setSchema(boolean bl) {
        this.m_chkPublic.setSelected(bl);
        SchemaPicker schemaPicker = this.getSchemaPicker();
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (bl) {
            this.m_lastSchema = this.getSchemaObject().getSchema();
            Schema schema = null;
            try {
                schema = this.getProvider().getSchema(PUBLIC);
            }
            catch (DBException dBException) {
                DBUtil.getLogger().log(Level.WARNING, "error finding PUBLIC schema", dBException);
            }
            if (schema == null) {
                schema = new Schema(PUBLIC);
            }
            schemaPicker.setEditable(true);
            schemaPicker.setSelectedItem(schema);
            schemaPicker.setEnabled(false);
            schemaPicker.setEditable(false);
        } else {
            SchemaObjectInfoVerifier schemaObjectInfoVerifier = this.getVerifier();
            boolean bl2 = schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canChangeSchema();
            boolean bl3 = schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canCreateSchema();
            schemaPicker.setEnabled(bl2);
            schemaPicker.setEditable(bl3);
            if (this.m_lastSchema == null || PUBLIC.equals(this.m_lastSchema.getName())) {
                try {
                    this.m_lastSchema = dBObjectProvider.getDefaultSchema();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (this.m_lastSchema != null) {
                schemaPicker.setSelectedItem(this.m_lastSchema);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        SchemaPicker schemaPicker = this.getSchemaPicker();
        if (object2 == this.m_chkPublic) {
            boolean bl = this.m_chkPublic.isSelected();
            this.setSchema(bl);
            this.commitPublic(bl);
        } else if (object2 == schemaPicker && (object = schemaPicker.getSelectedItem()) instanceof Schema && ((Schema)object).getName().equals(PUBLIC)) {
            this.setSchema(true);
        }
        super.actionPerformed(actionEvent);
    }
}

