/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectPicker;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public class DBObjectSourcePicker
extends DBObjectPicker
implements Runnable {
    private String[] m_types;
    private DBObjectProvider m_pro;
    private Schema m_schema;
    private String m_filter;
    private ProgressBar m_bar;
    private JPanel m_component;
    private JWrappedLabel m_emptyLabel;

    private void $init$() {
        this.m_component = new JPanel();
    }

    public DBObjectSourcePicker(DBObjectProvider dBObjectProvider, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.$init$();
        this.m_pro = dBObjectProvider;
        this.showEmptyUI();
    }

    private void showEmptyUI() {
        if (this.m_emptyLabel == null) {
            this.m_emptyLabel = new JWrappedLabel(UIArb.getString(186));
            this.m_component.removeAll();
            this.m_component.setLayout(new GridBagLayout());
            this.m_component.setBorder(BorderFactory.createEtchedBorder());
            this.m_component.add((Component)this.m_emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.m_component.validate();
        }
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        if (this.m_pro != dBObjectProvider) {
            this.m_pro = dBObjectProvider;
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
            this.showEmptyUI();
        }
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void setTypes(String[] stringArray) {
        this.m_types = stringArray;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public boolean setFilter(String string) {
        if (!ModelUtil.areEqual((Object)this.m_filter, (Object)string)) {
            this.m_filter = string;
            return true;
        }
        return false;
    }

    public void query() {
        boolean bl = false;
        if (this.m_pro instanceof Database) {
            this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(184), (Runnable)this, true);
            this.m_bar.start(UIArb.getString(185), null);
            bl = this.m_bar.hasUserCancelled() ^ true;
            this.m_bar = null;
        } else {
            this.doQuery();
            bl = true;
        }
        if (bl) {
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
            if (this.m_emptyLabel != null) {
                this.m_component.removeAll();
                this.m_component.add(super.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_component.setBorder(null);
                this.m_component.validate();
                this.m_emptyLabel = null;
            }
        }
    }

    private void doQuery() {
        try {
            if (this.m_types != null && this.m_types.length > 0) {
                ProgressBar progressBar = this.m_bar;
                if (progressBar != null && progressBar.hasUserCancelled()) {
                    return;
                }
                SchemaObject[] schemaObjectArray = this.m_pro.listObjects(this.m_types, this.m_schema, this.m_filter);
                if (progressBar != null && progressBar.hasUserCancelled()) {
                    return;
                }
                schemaObjectArray = this.filterAndSort(schemaObjectArray);
                this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
                int n = 0;
                while (n < schemaObjectArray.length) {
                    if (progressBar != null && progressBar.hasUserCancelled()) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode((DBObject)schemaObjectArray[n]);
                    this.m_top.add(defaultMutableTreeNode);
                    ++n;
                }
            }
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            ExceptionDialog.showExceptionDialog((Context)Context.newIdeContext(), (Throwable)dBException);
        }
        if (this.m_bar != null) {
            this.m_bar.setDoneStatus();
        }
    }

    protected SchemaObject[] filterAndSort(SchemaObject[] schemaObjectArray) {
        Arrays.sort(schemaObjectArray, this.m_dbRenderer);
        return schemaObjectArray;
    }

    public void run() {
        this.doQuery();
    }

    public Component getComponent() {
        return this.m_component;
    }
}

