/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;

public class DBObjectPicker
extends AbstractTreePicker {
    protected static final Transferable[] EMPTY = new DBObjectTransferable[0];
    private PropertyChangeSupport m_pcs;
    private ActionListener m_actionListener;
    private Transferable[] m_selectionTrans;
    protected DBObjectRenderer m_dbRenderer;
    protected TreeNodeMaker m_nodeMaker;
    protected DefaultMutableTreeNode m_top;
    protected DefaultTreeModel m_treeModel;
    protected JTree m_tree;
    protected boolean m_remove;

    private void $init$() {
        this.m_dbRenderer = new DBObjectRenderer();
        this.m_nodeMaker = new TreeNodeMaker();
        this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
        this.m_treeModel = new DefaultTreeModel(this.m_top);
        this.m_tree = new JTree(this.m_treeModel);
    }

    public DBObjectPicker(boolean bl, boolean bl2) {
        this.$init$();
        this.setTree(this.m_tree);
        this.m_remove = bl2;
        this.m_nodeMaker.setShowChildren(bl);
        this.setupTree();
    }

    public TreeNodeMaker getNodeMaker() {
        return this.m_nodeMaker;
    }

    public void reloadTree() {
        this.m_treeModel.reload();
    }

    private void setupTree() {
        this.m_tree.setRootVisible(false);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_tree.setShowsRootHandles(this.m_nodeMaker.getShowChildren());
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.getSelectionModel().setSelectionMode(4);
    }

    public void clear() {
        this.m_tree.removeAll();
        this.m_treeModel.reload();
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_top, this.m_top.getChildCount());
    }

    public void addDBObjects(DBObject[] dBObjectArray) {
        int n = 0;
        while (n < dBObjectArray.length) {
            if (dBObjectArray[n] != null) {
                this.findOrAddChild(this.m_top, dBObjectArray[n], null);
            }
            ++n;
        }
    }

    public void addDBObjectPaths(DBObject[][] dBObjectArray) {
        int n = 0;
        while (n < dBObjectArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.m_top;
            int n2 = 0;
            while (n2 < dBObjectArray[n].length) {
                defaultMutableTreeNode = this.findOrAddChild(defaultMutableTreeNode, dBObjectArray[n][n2], null);
                ++n2;
            }
            ++n;
        }
    }

    protected DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode defaultMutableTreeNode, DBObject dBObject, List list) {
        return this.findOrAddChild(defaultMutableTreeNode, dBObject, list, false);
    }

    private DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode defaultMutableTreeNode, DBObject dBObject, List list, boolean bl) {
        int n = defaultMutableTreeNode.getChildCount();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            int n3 = this.m_dbRenderer.compare((Object)dBObject, defaultMutableTreeNode2.getUserObject());
            if (n3 == 0) {
                if (bl) {
                    n = n2;
                    this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode2);
                    break;
                }
                return defaultMutableTreeNode2;
            }
            if (n3 < 1) {
                n = n2;
            }
            ++n2;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.m_nodeMaker.createTreeNode(dBObject);
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, n);
        TreePath treePath = new TreePath(defaultMutableTreeNode3.getPath());
        if (list != null) {
            list.add(treePath);
        }
        return defaultMutableTreeNode3;
    }

    private DBObject[] trimPath(Object[] objectArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2].equals(this.m_top.getUserObject())) {
                n = n2;
                break;
            }
            ++n2;
        }
        int n3 = objectArray.length - (n + 1);
        DBObject[] dBObjectArray = new DBObject[n3];
        System.arraycopy(objectArray, n + 1, dBObjectArray, 0, n3);
        return dBObjectArray;
    }

    private void removeFromParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode != this.m_top) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
            if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getChildCount() < 1) {
                this.removeFromParent(defaultMutableTreeNode2);
            }
        }
    }

    public void setSelectedItems(DBObject[] dBObjectArray) {
        TreeSelectionModel treeSelectionModel = this.m_tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        int n = 0;
        while (n < dBObjectArray.length) {
            if (dBObjectArray[n] != null) {
                this.setSelected(dBObjectArray[n], this.m_top, treeSelectionModel);
            }
            ++n;
        }
    }

    private void setSelected(DBObject dBObject, DefaultMutableTreeNode defaultMutableTreeNode, TreeSelectionModel treeSelectionModel) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!dBObject.equals(defaultMutableTreeNode2.getUserObject())) continue;
            treeSelectionModel.addSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            return;
        }
    }

    public boolean isSelectableItemPresent() {
        return this.m_top.getChildCount() > 0;
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (this.m_remove) {
            this.m_tree.clearSelection();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < transferableArray.length) {
                try {
                    DBObjectTransferable dBObjectTransferable = (DBObjectTransferable)transferableArray[n];
                    DefaultMutableTreeNode defaultMutableTreeNode = this.m_top;
                    DBObject[] dBObjectArray = dBObjectTransferable.getPath();
                    if (dBObjectArray != null && dBObjectArray.length > 1) {
                        int n2 = 0;
                        while (n2 < dBObjectArray.length) {
                            defaultMutableTreeNode = this.findOrAddChild(defaultMutableTreeNode, dBObjectArray[n2], null, n2 == dBObjectArray.length - 1);
                            ++n2;
                        }
                    } else {
                        DBObject dBObject = dBObjectTransferable.getDBObject();
                        this.findOrAddChild(defaultMutableTreeNode, dBObject, arrayList, true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            int n3 = arrayList.size();
            if (n3 > 0) {
                TreePath[] treePathArray = arrayList.toArray(new TreePath[n3]);
                this.m_tree.setSelectionPaths(treePathArray);
            }
        }
        return true;
    }

    public void removeSelectedItems() {
        if (this.m_remove) {
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            int n = 0;
            while (treePathArray != null && n < treePathArray.length) {
                if (treePathArray[n] != null) {
                    this.removeFromParent((DefaultMutableTreeNode)treePathArray[n].getLastPathComponent());
                }
                ++n;
            }
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_remove) {
            this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
        }
    }

    public Transferable createTransferable(TreePath treePath) {
        DBObjectTransferable dBObjectTransferable = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        if (object != null && object instanceof DBObject) {
            if (objectArray == null) {
                dBObjectTransferable = new DBObjectTransferable((DBObject)object);
            } else {
                DBObject[] dBObjectArray = this.trimPath(objectArray);
                dBObjectTransferable = new DBObjectTransferable((DBObject)object, dBObjectArray);
            }
        }
        return dBObjectTransferable;
    }

    public Transferable[] getAllSelectableItems() {
        ArrayList<DBObjectTransferable> arrayList = new ArrayList<DBObjectTransferable>();
        Enumeration<TreeNode> enumeration = this.m_top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            DBObject dBObject = (DBObject)defaultMutableTreeNode.getUserObject();
            arrayList.add(new DBObjectTransferable(dBObject));
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return EMPTY;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] transferableArray = this.getSelectedItems();
        if (transferableArray != null) {
            DataFlavor[] dataFlavorArray = new DataFlavor[transferableArray.length];
            int n = 0;
            while (n < dataFlavorArray.length) {
                dataFlavorArray[n] = ((DBObjectTransferable)transferableArray[n]).getPrimaryFlavor();
                ++n;
            }
            return dataFlavorArray;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            Class<?> clazz;
            if (dataFlavorArray[n] != null && ModelUtil.areEqual(clazz = dataFlavorArray[n].getDefaultRepresentationClass(), DBObjectTransferable.class)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.m_selectionTrans = null;
        super.valueChanged(treeSelectionEvent);
    }
}

