/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.relation.RelationInfoVerifier;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public class CommentEditor
extends JPanel
implements Traversable {
    public static int NO_LABEL = 0;
    public static int LABEL_ABOVE = 1;
    public static int LABEL_LEFT = 2;
    private JLabel m_label;
    private JScrollPane m_scrollPane;
    private JTextArea m_textArea;

    private void $init$() {
        this.m_label = new JLabel();
        this.m_scrollPane = new JScrollPane();
        this.m_textArea = new JTextArea();
    }

    public CommentEditor() {
        this(LABEL_ABOVE);
    }

    public CommentEditor(int n) {
        this.$init$();
        this.m_scrollPane.setVerticalScrollBarPolicy(22);
        this.m_scrollPane.setHorizontalScrollBarPolicy(31);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setWrapStyleWord(true);
        this.m_scrollPane.getViewport().add((Component)this.m_textArea, null);
        this.setLayout(new GridBagLayout());
        int n2 = 0;
        int n3 = 0;
        if (n > NO_LABEL) {
            ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_textArea, (String)UIArb.getString(400));
            this.add((Component)this.m_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
            if (n == LABEL_ABOVE) {
                ++n3;
            } else {
                ++n2;
            }
        }
        this.add((Component)this.m_scrollPane, new GridBagConstraints(n2, n3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(DBObject dBObject) {
        this.init(dBObject, null);
    }

    public void init(DBObject dBObject, RelationInfoVerifier relationInfoVerifier) {
        this.m_textArea.setText((String)dBObject.getProperty("Comment"));
        this.setEnabled(relationInfoVerifier == null || relationInfoVerifier.canChangeComment());
    }

    public void commit(DBObject dBObject) {
        String string = this.m_textArea.getText();
        dBObject.setProperty("Comment", (Object)(ModelUtil.hasLength((String)string.trim()) ? string : null));
    }

    public void setEnabled(boolean bl) {
        this.m_label.setEnabled(bl);
        this.m_textArea.setEnabled(bl);
    }

    public void onEntry(TraversableContext traversableContext) {
        SchemaObject schemaObject = (SchemaObject)traversableContext.find("NewObject");
        RelationInfoVerifier relationInfoVerifier = (RelationInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        this.init((DBObject)schemaObject, relationInfoVerifier);
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SchemaObject schemaObject = (SchemaObject)traversableContext.find("NewObject");
        this.commit((DBObject)schemaObject);
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return null;
    }
}

