/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;

public abstract class AbstractTreePicker
implements ItemPicker,
ActionListener,
TreeSelectionListener,
FocusListener,
MouseListener {
    private PropertyChangeSupport m_pcs;
    private ActionListener m_actionListener;
    private JTree m_tree;
    private JScrollPane m_component;

    public AbstractTreePicker() {
    }

    public AbstractTreePicker(JTree jTree) {
        this.setTree(jTree);
    }

    public void setTree(JTree jTree) {
        this.m_tree = jTree;
        this.m_component = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.m_tree.registerKeyboardAction(this, keyStroke, 0);
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public boolean isItemSelected() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        int n = 0;
        while (treePathArray != null && n < treePathArray.length) {
            if (this.createTransferable(treePathArray[n]) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void deselectAll() {
        this.m_tree.getSelectionModel().setSelectionPath(null);
    }

    public Transferable[] getSelectedItems() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            int n = 0;
            while (n < treePathArray.length) {
                Transferable transferable = this.createTransferable(treePathArray[n]);
                if (transferable != null) {
                    arrayList.add(transferable);
                }
                ++n;
            }
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return null;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public JScrollPane getScrollPane() {
        return this.m_component;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] transferableArray = this.getSelectedItems();
        if (transferableArray != null) {
            DataFlavor[] dataFlavorArray = new DataFlavor[transferableArray.length];
            int n = 0;
            while (n < transferableArray.length) {
                dataFlavorArray[n] = transferableArray[n] == null ? null : transferableArray[n].getTransferDataFlavors()[0];
                ++n;
            }
            return dataFlavorArray;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        return true;
    }

    public abstract Transferable[] getAllSelectableItems();

    public abstract boolean addSelectedItems(Transferable[] var1);

    public abstract void removeSelectedItems();

    public abstract void removeAllSelectableItems();

    public abstract Transferable createTransferable(TreePath var1);

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, actionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_pcs == null) {
            this.m_pcs = new PropertyChangeSupport(this);
        }
        this.m_pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, actionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_pcs != null) {
            this.m_pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected boolean handleDefaultAction(TreePath treePath) {
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_actionListener != null) {
            Transferable transferable;
            Object object;
            TreePath treePath;
            int n = this.m_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                int n2 = mouseEvent.getModifiers();
                if ((n2 & 2) != 2 && (n2 & 1) != 1) {
                    this.deselectAll();
                }
            } else if (mouseEvent.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(mouseEvent) && !this.handleDefaultAction(treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) && (!((object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) || ((DefaultMutableTreeNode)object).isLeaf()) && (transferable = this.createTransferable(treePath)) != null) {
                this.m_actionListener.actionPerformed(new ActionEvent(this, mouseEvent.getID(), null, mouseEvent.getModifiers()));
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() == this.m_tree && this.handleDefaultAction(this.m_tree.getSelectionPath()) || this.m_actionListener == null)) {
            this.m_actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.m_tree.getSelectionCount() == 0 && this.m_tree.getRowCount() > 0) {
            this.m_tree.setSelectionRow(0);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.m_pcs != null) {
            this.m_pcs.firePropertyChange("selection", null, null);
        }
    }
}

