/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.db.DBIcons;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideri.util.Product;

class DefaultDBTypeRegistry
implements DBTypeDisplayRegistry.RegistryEntry {
    private static Map<String, TypeEntry> typeEntries = new HashMap<String, TypeEntry>();

    public String getDisplayName(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        return typeEntry != null ? typeEntry.getDisplayName() : string;
    }

    public Icon getNodeIcon(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        return typeEntry != null ? typeEntry.getNodeIcon() : null;
    }

    public Icon getFolderIcon(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        Icon icon = typeEntry != null ? typeEntry.getFolderIcon() : null;
        return icon != null ? icon : IdeIcons.getIcon((int)4);
    }

    public static void registerType(String string, String string2, Icon icon, Icon icon2) {
        typeEntries.put(string, new DefaultTypeEntry(string2, icon, icon2));
    }

    public static void registerType(String string, String string2, ArrayResourceBundle arrayResourceBundle, int n, ArrayResourceBundle arrayResourceBundle2, int n2) {
        typeEntries.put(string, new DeferredTypeEntry(string2, arrayResourceBundle, n, arrayResourceBundle2, n2));
    }

    static {
        DefaultDBTypeRegistry.registerType("TABLE", UIArb.getString(5), null, -1, DBIcons.getInstance(), 29);
        DefaultDBTypeRegistry.registerType("COLUMN", UIArb.getString(20), null, -1, DBIcons.getInstance(), 11);
        DefaultDBTypeRegistry.registerType("INDEX", UIArb.getString(16), null, -1, DBIcons.getInstance(), 17);
        DefaultDBTypeRegistry.registerType("SCHEMA", UIArb.getString(14), null, -1, DBIcons.getInstance(), 25);
        DefaultDBTypeRegistry.registerType("FUNCTION", UIArb.getString(2), null, -1, DBIcons.getInstance(), 21);
        DefaultDBTypeRegistry.registerType("PROCEDURE", UIArb.getString(3), null, -1, DBIcons.getInstance(), 23);
        DefaultDBTypeRegistry.registerType("PACKAGE", UIArb.getString(1), null, -1, DBIcons.getInstance(), 22);
        DefaultDBTypeRegistry.registerType("TYPE", UIArb.getString(4), null, -1, DBIcons.getInstance(), 14);
        DefaultDBTypeRegistry.registerType("JAVA CLASS", UIArb.getString(8), null, -1, DBIcons.getInstance(), 18);
        DefaultDBTypeRegistry.registerType("JAVA SOURCE", UIArb.getString(10), null, -1, DBIcons.getInstance(), 18);
        DefaultDBTypeRegistry.registerType("JAVA RESOURCE", UIArb.getString(9), null, -1, DBIcons.getInstance(), 19);
        DefaultDBTypeRegistry.registerType("JAVA", UIArb.getString(8), null, -1, DBIcons.getInstance(), 19);
        DefaultDBTypeRegistry.registerType("SEQUENCE", UIArb.getString(11), null, -1, DBIcons.getInstance(), 26);
        DefaultDBTypeRegistry.registerType("SYNONYM", UIArb.getString(12), null, -1, DBIcons.getInstance(), 27);
        DefaultDBTypeRegistry.registerType("PUBLIC_SYNONYM", UIArb.getString(13), null, -1, DBIcons.getInstance(), 28);
        DefaultDBTypeRegistry.registerType("TRIGGER", UIArb.getString(7), null, -1, DBIcons.getInstance(), 30);
        DefaultDBTypeRegistry.registerType("BLOCK", UIArb.getString(19), null, -1, DBIcons.getInstance(), 23);
        DefaultDBTypeRegistry.registerType("VIEW", UIArb.getString(6), null, -1, DBIcons.getInstance(), 32);
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW", UIArb.getString(23), null, -1, DBIcons.getInstance(), 32);
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW LOG", UIArb.getString(24), null, -1, DBIcons.getInstance(), 32);
        DefaultDBTypeRegistry.registerType("RECYCLEBIN", UIArb.getString(25), DBIcons.getInstance(), 16, IdeArb.getInstance(), 226);
        DefaultDBTypeRegistry.registerType("DATABASE LINK", UIArb.getString(26), null, -1, DBIcons.getInstance(), 13);
        DefaultDBTypeRegistry.registerType("DIRECTORY", UIArb.getString(27), null, -1, DBIcons.getInstance(), 19);
        DefaultDBTypeRegistry.registerType("XML SCHEMA", UIArb.getString(28), null, -1, DBIcons.getInstance(), 33);
        DefaultDBTypeRegistry.registerType("INDEXTYPE", UIArb.getString(29), null, -1, DBIcons.getInstance(), 34);
        DefaultDBTypeRegistry.registerType("Connections", Product.isRaptor() ? ModelArb.getString((int)45) : UIArb.getString(0), null, null);
    }

    private static interface TypeEntry {
        public String getDisplayName();

        public Icon getFolderIcon();

        public Icon getNodeIcon();
    }

    private static class DefaultTypeEntry
    implements TypeEntry {
        private String displayName;
        private Icon folderIcon;
        private Icon nodeIcon;
        private Class bundle;
        private String folderKey;
        private String nodeKey;

        DefaultTypeEntry(String string, Icon icon, Icon icon2) {
            this.displayName = string;
            this.folderIcon = icon;
            this.nodeIcon = icon2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getFolderIcon() {
            return this.folderIcon;
        }

        public Icon getNodeIcon() {
            return this.nodeIcon;
        }
    }

    private static class DeferredTypeEntry
    implements TypeEntry {
        private String m_displayName;
        private ArrayResourceBundle m_folderBundle;
        private ArrayResourceBundle m_nodeBundle;
        private int m_folderKey;
        private int m_nodeKey;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = DeferredTypeEntry.class.desiredAssertionStatus() ^ true;
        }

        DeferredTypeEntry(String string, ArrayResourceBundle arrayResourceBundle, int n, ArrayResourceBundle arrayResourceBundle2, int n2) {
            if (!$assertionsDisabled && arrayResourceBundle != null && n < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && arrayResourceBundle2 != null && n2 < 0) {
                throw new AssertionError();
            }
            this.m_displayName = string;
            this.m_folderBundle = arrayResourceBundle;
            this.m_nodeBundle = arrayResourceBundle2;
            this.m_folderKey = n;
            this.m_nodeKey = n2;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public Icon getFolderIcon() {
            return this.m_folderBundle != null ? this.m_folderBundle.getIconImpl(this.m_folderKey) : null;
        }

        public Icon getNodeIcon() {
            return this.m_nodeBundle != null ? this.m_nodeBundle.getIconImpl(this.m_nodeKey) : null;
        }
    }
}

