/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.math.BigDecimal;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class XPathConstantExpr
extends XSLExprBase {
    OXMLItem priExprValue = new XPathItem();
    String normalizedStr;
    boolean emptySeq = false;

    XPathConstantExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XPathConstantExpr xPathConstantExpr = null;
        int n = xSLParseString.peekToken();
        if (n == 109) {
            xPathConstantExpr = new XPathConstantExpr();
            xSLParseString.nextToken();
            int n2 = xSLParseString.getLiteralType();
            if (n2 == 303) {
                xPathConstantExpr.setExprType(2);
                xPathConstantExpr.normalizedStr = xSLParseString.getLiteralValue();
                xPathConstantExpr.priExprValue.setString(OXMLSequenceType.TSTRING, xPathConstantExpr.normalizedStr);
                xPathConstantExpr.normalizedStr = "\"" + xPathConstantExpr.normalizedStr + "\"";
            } else if (n2 == 302) {
                String string = xSLParseString.getLiteralValue();
                xPathConstantExpr.setExprType(32);
                if (XSLExpr.isXPath20Compatible(xSLParseString)) {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    xPathConstantExpr.priExprValue.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                } else {
                    double d = Double.parseDouble(string);
                    xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d);
                }
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            } else if (n2 == 301) {
                String string = xSLParseString.getLiteralValue();
                xPathConstantExpr.setExprType(16);
                double d = Double.parseDouble(string);
                xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d);
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            } else if (n2 == 300) {
                String string = xSLParseString.getLiteralValue();
                xPathConstantExpr.setExprType(0x100000);
                if (XSLExpr.isXPath20Compatible(xSLParseString)) {
                    double d = Double.parseDouble(string);
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        xPathConstantExpr.priExprValue.setInt(OXMLSequenceType.TINTEGER, (int)d);
                    } else {
                        xPathConstantExpr.priExprValue.setDecimal(OXMLSequenceType.TINTEGER, new BigDecimal(d));
                    }
                } else {
                    double d = Double.parseDouble(string);
                    xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d);
                }
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            }
        } else if (n == 113) {
            String string = xSLParseString.getLocalName();
            if (xSLParseString.getFunctionType() == 600 && (string.equals("true") || string.equals("false"))) {
                xSLParseString.nextToken();
                xPathConstantExpr = new XPathConstantExpr();
                ((XPathItem)xPathConstantExpr.priExprValue).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
                int n3 = xSLParseString.lookUp(string, XSLParseString.functionnames);
                xPathConstantExpr.normalizedStr = n3 + "()";
                xPathConstantExpr.priExprValue.setBoolean(OXMLSequenceType.TBOOLEAN, string.equals("true"));
                if (xSLParseString.nextToken() != 26) {
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
            }
        }
        xPathConstantExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        return xPathConstantExpr;
    }

    XSLExprBase createCachedExpr() {
        return this;
    }

    void cacheSubExpr() {
    }

    boolean canCacheExpr() {
        return true;
    }

    String getNormalizedExpr() {
        return this.normalizedStr;
    }

    void setEmptySequence() {
        this.emptySeq = true;
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        if (this.emptySeq) {
            xSLTContext.pushExprValue().reset();
            return;
        }
        XPathItem xPathItem = xSLTContext.allocItem();
        xPathItem.copyItem(this.priExprValue);
        xSLTContext.pushExprValue().appendItem(xPathItem);
    }

    int getPositionValue() {
        if (super.isExprType(1048632)) {
            return (int)XPathItem.getNumberValue(this.priExprValue);
        }
        return 0;
    }

    boolean checkPosLastFN() {
        return false;
    }

    OXMLItem getValue() {
        return this.priExprValue;
    }
}

