/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.NodeReference;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLText
extends CharData
implements Text,
Externalizable {
    static QxName CLASS_QNAME = QxNameHash.create("", "#text", "", "#text");
    static final int WHITESPACE_NODE = 65536;
    static final int CHAR_ARRAY_VALUE = 131072;
    static final int LAZY_TEXT = 262144;
    static final int LARGE_TEXT = 4096;
    private static final int TEXT_PARENT = 0;
    private static final int TEXT_VALUE = 1;
    private static final int TEXT_NEXTNODE = 2;
    private static final int TEXT_PREVNODE = 3;
    private static final int TEXT_OFFSET = 4;
    private static final int TEXT_READER = 5;
    private static final int TEXT_DATASZ = 4;

    public XMLText() {
    }

    public XMLText(String string) {
        this.setNodeValue(string);
    }

    protected XMLText(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    XMLText(char[] cArray, int n, int n2) {
        this.addText(cArray, n, n2);
    }

    public short getNodeType() {
        return 3;
    }

    public QxName getQName() {
        return CLASS_QNAME;
    }

    public String getNodeName() {
        return "#text";
    }

    public boolean checkTypeNSName(int n, String string, String string2) {
        return n == 3;
    }

    public Text splitText(int n) throws DOMException {
        XMLText xMLText;
        this.checkReadOnly();
        String string = this.getNodeValue();
        try {
            this.setData(string.substring(0, n));
            XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
            xMLText = (XMLText)xMLDocument.createTextNode(string.substring(n, string.length()));
            Node node = this.getParentNode();
            if (node != null) {
                if (((XMLNode)node).isScalable()) {
                    ((XMLNode)node).xdkKeepNode();
                }
                node.replaceChild(xMLText, this);
                xMLText.getParentNode().insertBefore(this, xMLText);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string.length()));
        }
        return xMLText;
    }

    public boolean isElementContentWhitespace() {
        switch (this.flags & 3) {
            case 1: {
                if (this.getParentNode() == null) {
                    return false;
                }
                char[] cArray = this.getTextChars();
                if (this.isNodeFlag(65536)) {
                    return true;
                }
                for (int i = 0; i < cArray.length; ++i) {
                    if (!XMLUtil.isWhiteSpaceChar(cArray[i])) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    public String getWholeText() {
        switch (this.flags & 3) {
            case 1: {
                Node node = this;
                Node node2 = null;
                while ((node2 = this.getPreviousSibling()) != null && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    node = node2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    stringBuffer.append(node.getNodeValue());
                } while ((node = node.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4));
                return stringBuffer.toString();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public Text replaceWholeText(String string) throws DOMException {
        if (string == null || string == "") {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                Node node = null;
                Node node2 = this.getParentNode();
                while ((node = this.getPreviousSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                while ((node = this.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                this.xdkSetNodeValue(string);
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                return this;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public boolean isWhiteSpaceNode() {
        this.getTextChars();
        return this.isNodeFlag(65536);
    }

    public void addText(char[] cArray, int n, int n2) {
        switch (this.flags & 3) {
            case 1: {
                char[] cArray2 = this.getTextChars();
                if (this.isNodeFlag(65536)) {
                    int n3 = n + n2;
                    for (int i = n; i < n3; ++i) {
                        if (XMLUtil.isWhiteSpaceChar(cArray[i])) continue;
                        this.resetNodeFlag(65536);
                        break;
                    }
                }
                if (cArray2 != null) {
                    char[] cArray3 = cArray2;
                    cArray2 = new char[n2 + cArray2.length];
                    System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                    System.arraycopy(cArray, n, cArray2, cArray3.length, n2);
                } else {
                    cArray2 = new char[n2];
                    System.arraycopy(cArray, n, cArray2, 0, n2);
                }
                this.xdkSetTextArray(cArray2);
                return;
            }
            case 2: {
                this.appendData(new String(cArray, n, n2));
            }
        }
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.getData();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    void reportSAXEvents(boolean bl, ContentHandler contentHandler) throws SAXException {
        String string = this.getData();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public short isWhitespaceOnly() {
        switch (this.flags & 3) {
            case 1: {
                if (this.isWhiteSpaceNode()) {
                    return 5;
                }
                return 6;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canSetData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, string) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(string);
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canAppendData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.getNodeValue());
                    stringBuffer.append(string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canReplaceData(int n, int n2, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canReplaceData(n, n2, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.replace(n, n + n2, string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canInsertData(int n, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canInsertData(n, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.insert(n, string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canDeleteData(int n, int n2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canDeleteData(n, n2);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.delete(n, n + n2);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string = xSDElement.getFixedVal();
                    if (string != null && xSDSimpleType.compareValues(string, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        String string = this.xdkGetNodeValue();
        if (string == null) {
            return;
        }
        infosetWriter.createEvent(4);
        infosetWriter.setValue(this.xdkGetNodeValue());
        infosetWriter.save();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }

    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        this.setNodeFlag(65536, infosetReader.getEventType() == 6);
        if (infosetReader.getDataLength() <= 4096 || !this.isScalable()) {
            this.xdkSetNodeValue(infosetReader.getValue());
        } else {
            this.setNodeFlag(262144);
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        XMLNode xMLNode;
        char[] cArray = this.getTextChars();
        if (cArray == null) {
            return;
        }
        if (this.isNodeFlag(65536) && (xMLNode = (XMLNode)this.getParentNode()) != null && xMLNode.isNodeFlag(131072)) {
            return;
        }
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '&') {
                xMLOutputStream.writeChars("&amp;");
                continue;
            }
            if (cArray[i] == '<') {
                xMLOutputStream.writeChars("&lt;");
                continue;
            }
            if (i > 1 && cArray[i] == '>') {
                if (bl || cArray[i - 1] == ']' && cArray[i - 2] == ']') {
                    xMLOutputStream.writeChars("&gt;");
                    continue;
                }
                xMLOutputStream.write(62);
                continue;
            }
            xMLOutputStream.write(cArray[i]);
        }
        xMLOutputStream.flush();
    }

    private char[] getTextChars() {
        char[] cArray = null;
        switch (this.flags & 3) {
            case 1: {
                if (this.isNodeFlag(131072)) {
                    cArray = this.xdkGetTextArray();
                    break;
                }
                String string = this.xdkGetNodeValue();
                if (string != null) {
                    cArray = string.toCharArray();
                }
                this.xdkSetTextArray(cArray);
                break;
            }
            case 2: {
                String string = this.getNodeValue();
                if (string == null) break;
                cArray = string.toCharArray();
            }
        }
        if (cArray == null) {
            return null;
        }
        boolean bl = true;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (XMLUtil.isWhiteSpaceChar(cArray[i])) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.setNodeFlag(65536);
        }
        return cArray;
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        return (XMLText)xMLDocument.createTextNode(this.xdkGetNodeValue());
    }

    XMLNode xdkGetParentNode() {
        return (XMLNode)this.data[(int)this.nodeId + 0];
    }

    void xdkSetParentNode(XMLNode xMLNode) {
        this.data[(int)this.nodeId + 0] = xMLNode;
    }

    String xdkGetNodeValue() {
        if (this.isNodeFlag(131072)) {
            char[] cArray = this.xdkGetTextArray();
            if (cArray != null) {
                this.xdkSetNodeValue(new String(cArray, 0, cArray.length));
            }
        } else if (this.isNodeFlag(262144)) {
            InfosetReader infosetReader = this.xdkGetReader();
            infosetReader.seek(this.xdkGetOffset());
            this.resetNodeFlag(262144);
            this.xdkSetNodeValue(infosetReader.getValue());
        }
        return (String)this.data[(int)this.nodeId + 1];
    }

    void xdkSetNodeValue(String string) {
        this.resetNodeFlag(131072);
        this.data[(int)this.nodeId + 1] = string;
    }

    char[] xdkGetTextArray() {
        String string;
        if (!this.isNodeFlag(131072) && (string = this.xdkGetNodeValue()) != null) {
            this.xdkSetTextArray(string.toCharArray());
        }
        return (char[])this.data[(int)this.nodeId + 1];
    }

    void xdkSetTextArray(char[] cArray) {
        this.setNodeFlag(131072);
        this.data[(int)this.nodeId + 1] = cArray;
    }

    XMLNode xdkGetNextNode() {
        InfosetReader.Offset offset;
        NodeReference nodeReference;
        Object object = this.data[(int)this.nodeId + 2];
        if (!this.isNodeFlag(2048)) {
            return (XMLNode)object;
        }
        if (object instanceof NodeReference) {
            nodeReference = (NodeReference)object;
            if ((object = nodeReference.get()) != null) {
                return (XMLNode)object;
            }
            offset = nodeReference.offset;
        } else if (object instanceof InfosetReader.Offset) {
            offset = (InfosetReader.Offset)object;
        } else {
            if (object instanceof XMLNode) {
                return (XMLNode)object;
            }
            return null;
        }
        XMLNode xMLNode = this.xdkGetParentNode();
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode2 = xMLDocument.createNodeFromOffset(offset, this.xdkGetReader(), xMLNode);
        xMLNode.updateNext();
        if (xMLDocument.scalable) {
            nodeReference = new NodeReference(xMLNode2, offset);
            this.xdkSetNextNode(nodeReference);
            xMLNode.xdkSetLastChild(nodeReference);
        } else {
            this.xdkSetNextNode(xMLNode2);
            xMLNode.xdkSetLastChild(xMLNode2);
        }
        xMLNode2.xdkSetParentNode(xMLNode);
        if (!xMLDocument.isNodeFlag(0x200000)) {
            xMLNode2.xdkSetPrevNode(this);
        }
        if (xMLDocument.nodeHandler != null) {
            xMLDocument.nodeHandler.reportNodeRead(xMLNode2);
            return this.xdkGetNextNode();
        }
        return xMLNode2;
    }

    void xdkSetNextNode(Object object) {
        if (this.isScalable() && object instanceof XMLNode) {
            this.xdkKeepNode();
            this.resetNodeFlag(4096);
        }
        this.data[(int)this.nodeId + 2] = object;
    }

    XMLNode xdkGetPrevNode() {
        return (XMLNode)this.data[(int)this.nodeId + 3];
    }

    void xdkSetPrevNode(XMLNode xMLNode) {
        this.data[(int)this.nodeId + 3] = xMLNode;
    }

    int xdkGetNodeArraySize() {
        if (this.isNodeFlag(2048)) {
            return 6;
        }
        return 4;
    }

    InfosetReader.Offset xdkGetOffset() {
        return (InfosetReader.Offset)this.data[(int)this.nodeId + 4];
    }

    InfosetReader xdkGetReader() {
        return (InfosetReader)this.data[(int)this.nodeId + 5];
    }

    void xdkSetOffset(InfosetReader.Offset offset, InfosetReader infosetReader) {
        this.data[(int)this.nodeId + 4] = offset;
        this.data[(int)this.nodeId + 5] = infosetReader;
    }
}

