/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CompoundEnumeration
implements Enumeration {
    private Enumeration _primEnum;
    private Enumeration _secEnum;
    private boolean _onPrimary;

    public CompoundEnumeration(Enumeration enumeration, Enumeration enumeration2) {
        if (enumeration == null || enumeration2 == null) {
            throw new IllegalArgumentException("enumeration can't be null");
        }
        this._primEnum = enumeration;
        this._secEnum = enumeration2;
        this._onPrimary = true;
    }

    public static Enumeration createEnumeration(Enumeration enumeration, Enumeration enumeration2) {
        if (enumeration == null) {
            return enumeration2;
        }
        if (enumeration2 == null) {
            return enumeration;
        }
        return new CompoundEnumeration(enumeration, enumeration2);
    }

    public boolean hasMoreElements() {
        if (this._onPrimary) {
            if (this._primEnum.hasMoreElements()) {
                return true;
            }
            this._onPrimary = false;
        }
        return this._secEnum.hasMoreElements();
    }

    public Object nextElement() {
        if (this._onPrimary) {
            if (this._primEnum.hasMoreElements()) {
                return this._primEnum.nextElement();
            }
            this._onPrimary = false;
        }
        if (!this._secEnum.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        return this._secEnum.nextElement();
    }
}

