/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.jce.provider.PhaosAlgorithmParametersSpi;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class RC2AlgorithmParametersSpi
extends PhaosAlgorithmParametersSpi {
    private RC2AlgorithmIdentifier algID;

    public RC2AlgorithmParametersSpi() {
        super("RC2");
    }

    RC2AlgorithmParametersSpi(AlgorithmIdentifier algID) throws NoSuchAlgorithmException {
        this();
        if (!algID.getOID().equals((Object)AlgID.RC2_CBC.getOID())) {
            throw new NoSuchAlgorithmException("Invalid algorithm identifier: " + algID);
        }
        try {
            this.algID = algID instanceof RC2AlgorithmIdentifier ? (RC2AlgorithmIdentifier)algID : new RC2AlgorithmIdentifier(Utils.toStream((Streamable)algID));
        }
        catch (IOException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
    }

    byte[] getIV() {
        return this.algID == null ? null : this.algID.getIV();
    }

    int getEffectiveKeyLength() {
        return this.algID == null ? 0 : this.algID.getEffectiveKeyLength();
    }

    protected byte[] engineGetEncoded() throws IOException {
        if (this.algID != null && this.algID.getParameters() != null) {
            return Utils.toBytes((Streamable)this.algID.getParameters());
        }
        return null;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.equals(RC2ParameterSpec.class)) {
            return new RC2ParameterSpec(this.getEffectiveKeyLength(), this.getIV());
        }
        if (paramSpec.equals(IvParameterSpec.class)) {
            return new IvParameterSpec(this.getIV());
        }
        throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.erase();
        if (paramSpec instanceof RC2ParameterSpec) {
            byte[] iv = ((RC2ParameterSpec)paramSpec).getIV();
            int effectiveKeyLength = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
            this.algID = new RC2AlgorithmIdentifier(iv, effectiveKeyLength);
        } else if (paramSpec instanceof IvParameterSpec) {
            byte[] iv = ((IvParameterSpec)paramSpec).getIV();
            this.algID = new RC2AlgorithmIdentifier(iv, 0);
        } else {
            throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
        }
    }

    protected void engineInit(byte[] params) throws IOException {
        this.erase();
        if (params == null) {
            return;
        }
        try {
            ASN1Object obj = ASN1Utils.inputASN1Object((byte[])params);
            this.algID = new RC2AlgorithmIdentifier(AlgID.RC2_CBC.getOID(), obj);
        }
        catch (AlgorithmIdentifierException ex) {
            throw new IOException(ex.toString());
        }
    }

    protected String engineToString() {
        return "RC2 Algorithm Parameters: IV=" + (this.getIV() != null ? Utils.toHexString((byte[])this.getIV()) : "") + ", effectiveKeyBits=" + this.getEffectiveKeyLength();
    }

    private void erase() {
        if (this.getIV() != null) {
            Utils.setArray((byte[])this.getIV(), (byte)0);
        }
        this.algID = null;
    }
}

