/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import oracle.security.crypto.core.MessageDigest;

public abstract class PhaosMessageDigestSpi
extends MessageDigestSpi {
    private MessageDigest md;

    protected PhaosMessageDigestSpi(MessageDigest md) {
        this.md = md;
    }

    protected void engineReset() {
        this.md.init();
    }

    protected int engineGetDigestLength() {
        return this.md.getDigestLength();
    }

    protected void engineUpdate(byte b) {
        this.md.update(b);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.md.update(input, offset, len);
    }

    protected byte[] engineDigest() {
        this.md.computeCurrent();
        byte[] result = this.md.getDigestBits();
        this.engineReset();
        return result;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        int digestLength = this.md.getDigestLength();
        if (len < digestLength) {
            throw new DigestException("Partial digests not supported");
        }
        if (buf.length < offset + digestLength) {
            throw new DigestException("Insufficient space in the output buffer");
        }
        byte[] res = this.engineDigest();
        System.arraycopy(res, 0, buf, offset, digestLength);
        return digestLength;
    }
}

