/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.PhaosAlgorithmParametersSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosBlockCipherSpi
extends CipherSpi {
    protected BlockCipher cipher;
    protected AlgorithmIdentifier algID;
    protected int mode = 0;
    private Padding.ID padding = Padding.PKCS5;
    private int opMode;
    protected RandomBitsSource random;
    private byte[] buffer;
    private int bufferPos;
    private boolean initialized = false;
    private static final int ENGINE_INIT_KEY_ALG_RND = 1;
    private static final int ENGINE_INIT_KEY_ALGSPEC_RND = 2;
    private static final int ENGINE_INIT_KEY_RND = 3;
    private int engineInitMethod;
    private int engineInitMode;
    private Key engineInitKey;
    private AlgorithmParameters engineInitParams;
    private SecureRandom engineInitRandom;
    private AlgorithmParameterSpec engineInitParamSpec;

    PhaosBlockCipherSpi(AlgorithmIdentifier algID) {
        this.algID = algID;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode.equalsIgnoreCase("ECB")) {
            this.mode = 0;
            this.algID = PhaosAlgorithmParametersSpi.getECBOID(this.algID.getOID());
        } else if (mode.equalsIgnoreCase("CBC")) {
            this.mode = 1;
            this.algID = PhaosAlgorithmParametersSpi.getCBCOID(this.algID.getOID());
        } else {
            throw new NoSuchAlgorithmException(mode + " not supported");
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("NoPadding")) {
            this.padding = Padding.NONE;
        } else if (padding.equalsIgnoreCase("PKCS5Padding") || padding.equalsIgnoreCase("PKCS5")) {
            this.padding = Padding.PKCS5;
        } else {
            throw new NoSuchPaddingException("Unknown padding: " + padding);
        }
    }

    protected void engineInit(int opMode, Key key, SecureRandom random) throws java.security.InvalidKeyException {
        RandomBitsSource randomBitsSource = this.random = random != null ? new SRRandomBitsSource(random) : RandomBitsSource.getDefault();
        if (this.algID instanceof CBCAlgorithmIdentifier) {
            try {
                this.algID = new CBCAlgorithmIdentifier(this.algID.getOID(), this.algID.getParameters());
            }
            catch (AlgorithmIdentifierException e) {
                throw new java.security.InvalidKeyException(e.toString());
            }
        } else {
            this.algID = new AlgorithmIdentifier(this.algID.getOID());
        }
        this.initialize(opMode, key);
        this.engineInitMethod = 3;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws java.security.InvalidKeyException, InvalidAlgorithmParameterException {
        RandomBitsSource randomBitsSource = this.random = random != null ? new SRRandomBitsSource(random) : RandomBitsSource.getDefault();
        if (paramSpec instanceof IvParameterSpec) {
            byte[] iv = ((IvParameterSpec)paramSpec).getIV();
            this.algID = new CBCAlgorithmIdentifier(this.algID.getOID(), iv);
        } else if (paramSpec instanceof RC2ParameterSpec) {
            byte[] iv = ((RC2ParameterSpec)paramSpec).getIV();
            int effectiveKeySize = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
            this.algID = new RC2AlgorithmIdentifier(iv, effectiveKeySize);
        }
        this.initialize(opMode, key);
        this.engineInitMethod = 2;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = paramSpec;
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws java.security.InvalidKeyException, InvalidAlgorithmParameterException {
        String alg = params.getAlgorithm();
        AlgorithmParameterSpec paramsSpec = null;
        try {
            paramsSpec = alg.equalsIgnoreCase("RC2") ? (AlgorithmParameterSpec)params.getParameterSpec(RC2ParameterSpec.class) : (AlgorithmParameterSpec)params.getParameterSpec(IvParameterSpec.class);
            this.engineInit(opMode, key, paramsSpec, random);
        }
        catch (InvalidParameterSpecException ex) {
            throw new InvalidAlgorithmParameterException("The given algorithm parameters are inappropriate");
        }
        this.engineInitMethod = 1;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = params;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    private void initialize(int opMode, Key key) throws java.security.InvalidKeyException {
        if (opMode != 2 && opMode != 1 && opMode != 4 && opMode != 3) {
            throw new IllegalStateException("Mode not supported: " + opMode);
        }
        this.checkIV(opMode);
        if (key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                if (this.cipher == null) {
                    this.cipher = (BlockCipher)Cipher.getInstance((AlgorithmIdentifier)this.algID, (SymmetricKey)PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key), (Padding.ID)this.padding);
                }
                this.cipher.initialize(this.algID, PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key), this.padding);
            }
            catch (InvalidKeyException ike) {
                throw new java.security.InvalidKeyException(ike.getMessage());
            }
            catch (AlgorithmIdentifierException aie) {
                throw new java.security.InvalidKeyException(aie.getMessage());
            }
            catch (CipherException ce) {
                throw new java.security.InvalidKeyException(ce.getMessage());
            }
        } else {
            throw new java.security.InvalidKeyException("can't initialize with key format '" + key.getFormat() + "' (supports RAW only)");
        }
        this.opMode = opMode;
        this.buffer = new byte[this.cipher.getBlockSize()];
        this.bufferPos = 0;
        this.initialized = true;
        if (!(this.mode != 1 || this.algID instanceof CBCAlgorithmIdentifier && ((CBCAlgorithmIdentifier)this.algID).getIV() != null)) {
            this.algID = this.cipher.getAlgID();
        }
    }

    private void reinitialize() {
        block6: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParams, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParamSpec, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 3) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitRandom);
                    break block6;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IllegalStateException(ex.toString());
            }
            catch (java.security.InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }

    protected void checkIV(int opMode) throws java.security.InvalidKeyException {
        if (!(opMode != 2 && opMode != 4 || this.mode != 1 || this.algID instanceof CBCAlgorithmIdentifier && ((CBCAlgorithmIdentifier)this.algID).getIV() != null || this.algID instanceof RC2AlgorithmIdentifier && ((RC2AlgorithmIdentifier)this.algID).getIV() != null)) {
            throw new java.security.InvalidKeyException("Invalid value for the IV: it is null");
        }
    }

    protected int engineGetBlockSize() {
        if (this.cipher == null) {
            try {
                return PhaosAlgorithmParametersSpi.getBlockSize(this.algID.getOID());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
        return this.cipher.getBlockSize();
    }

    protected int engineGetOutputSize(int inputLen) {
        int dataSizeToBeProcessed = inputLen + this.bufferPos;
        if (this.initialized && (this.opMode == 1 || this.opMode == 3) || !this.initialized) {
            int res = dataSizeToBeProcessed - dataSizeToBeProcessed % this.engineGetBlockSize();
            if (this.padding == Padding.NONE) {
                return res;
            }
            if (this.padding == Padding.PKCS5) {
                return res + this.engineGetBlockSize();
            }
            throw new IllegalStateException("Invalid padding: " + this.padding);
        }
        if (this.initialized && (this.opMode == 2 || this.opMode == 4)) {
            return dataSizeToBeProcessed;
        }
        throw new IllegalStateException("Invalid mode: DECRYPT, ENCRYPT, WRAP and UNWRAP modes only supported");
    }

    protected byte[] engineGetIV() {
        if (this.cipher == null) {
            return null;
        }
        this.algID = this.cipher.getAlgID();
        if (this.algID instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)this.algID).getIV();
        }
        if (this.algID instanceof RC2AlgorithmIdentifier) {
            return ((RC2AlgorithmIdentifier)this.algID).getIV();
        }
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        block7: {
            try {
                if (this.cipher == null) break block7;
                try {
                    AlgorithmIdentifier algID = this.cipher.getAlgID();
                    if (algID instanceof CBCAlgorithmIdentifier && ((CBCAlgorithmIdentifier)algID).getIV() != null) {
                        AlgorithmParameters alg = AlgorithmParameters.getInstance(PhaosAlgorithmParametersSpi.oidToString(algID.getOID()), "OracleJCE");
                        alg.init(new IvParameterSpec(((CBCAlgorithmIdentifier)algID).getIV()));
                        return alg;
                    }
                    if (algID instanceof RC2AlgorithmIdentifier && ((RC2AlgorithmIdentifier)algID).getIV() != null) {
                        AlgorithmParameters alg = AlgorithmParameters.getInstance(PhaosAlgorithmParametersSpi.oidToString(algID.getOID()), "OracleJCE");
                        alg.init(new RC2ParameterSpec(((RC2AlgorithmIdentifier)algID).getEffectiveKeyLength(), ((RC2AlgorithmIdentifier)algID).getIV()));
                        return alg;
                    }
                }
                catch (NoSuchProviderException ex) {
                    throw new RuntimeException(ex.toString());
                }
                catch (InvalidParameterSpecException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("unexpected NoSuchAlgorithmException:  " + ex.getMessage());
            }
        }
        return null;
    }

    protected byte[] engineUpdate(byte[] input, int offset, int len) {
        byte[] res;
        int blocksize;
        int currLen;
        int mod;
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        int dataSizeToBeProcessed = this.engineInitMode == 2 ? ((mod = (currLen = len + this.bufferPos) % (blocksize = this.engineGetBlockSize())) == 0 ? currLen - blocksize : currLen - mod) : len + this.bufferPos - (len + this.bufferPos) % this.engineGetBlockSize();
        if (dataSizeToBeProcessed > 0) {
            try {
                if (this.bufferPos == 0) {
                    res = this.compute(input, offset, dataSizeToBeProcessed, false);
                } else {
                    res = new byte[dataSizeToBeProcessed];
                    byte[] tmp = new byte[this.engineGetBlockSize()];
                    System.arraycopy(this.buffer, 0, tmp, 0, this.bufferPos);
                    System.arraycopy(input, offset, tmp, this.bufferPos, tmp.length - this.bufferPos);
                    byte[] firstShot = this.compute(tmp, 0, tmp.length, false);
                    System.arraycopy(firstShot, 0, res, 0, firstShot.length);
                    if (tmp.length != dataSizeToBeProcessed) {
                        byte[] secondShot = this.compute(input, offset + tmp.length - this.bufferPos, dataSizeToBeProcessed - tmp.length, false);
                        System.arraycopy(secondShot, 0, res, firstShot.length, secondShot.length);
                    }
                }
            }
            catch (BadPaddingException ex) {
                throw new IllegalStateException(ex.toString());
            }
            if (len > dataSizeToBeProcessed - this.bufferPos) {
                System.arraycopy(input, offset + dataSizeToBeProcessed - this.bufferPos, this.buffer, 0, len - (dataSizeToBeProcessed - this.bufferPos));
                this.bufferPos = len - (dataSizeToBeProcessed - this.bufferPos);
            } else {
                this.bufferPos = 0;
            }
        } else {
            System.arraycopy(input, offset, this.buffer, this.bufferPos, len);
            this.bufferPos += len;
            res = new byte[]{};
        }
        return res;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int saved = (inputLen + this.bufferPos) % this.engineGetBlockSize();
        if (saved == 0 && this.engineInitMode == 2) {
            saved = this.engineGetBlockSize();
        }
        if (output.length - outputOffset < inputLen + this.bufferPos - saved) {
            throw new ShortBufferException("The output buffer is too small");
        }
        byte[] res = this.engineUpdate(input, inputOffset, inputLen);
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    protected byte[] engineDoFinal(byte[] input, int offset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] res;
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        int dataSizeToBeProcessed = inputLen + this.bufferPos;
        if (dataSizeToBeProcessed > 0) {
            if (this.bufferPos == 0) {
                res = this.compute(input, offset, dataSizeToBeProcessed, true);
            } else {
                if (this.engineGetBlockSize() >= dataSizeToBeProcessed) {
                    byte[] tmp = new byte[dataSizeToBeProcessed];
                    System.arraycopy(this.buffer, 0, tmp, 0, this.bufferPos);
                    if (input != null) {
                        System.arraycopy(input, offset, tmp, this.bufferPos, inputLen);
                    }
                    res = this.compute(tmp, 0, dataSizeToBeProcessed, true);
                } else {
                    byte[] tmp = new byte[this.engineGetBlockSize()];
                    System.arraycopy(this.buffer, 0, tmp, 0, this.bufferPos);
                    System.arraycopy(input, offset, tmp, this.bufferPos, tmp.length - this.bufferPos);
                    byte[] firstShot = this.compute(tmp, 0, tmp.length, false);
                    byte[] secondShot = this.compute(input, offset + tmp.length - this.bufferPos, dataSizeToBeProcessed - tmp.length, true);
                    res = new byte[firstShot.length + secondShot.length];
                    System.arraycopy(firstShot, 0, res, 0, firstShot.length);
                    System.arraycopy(secondShot, 0, res, firstShot.length, secondShot.length);
                }
                this.bufferPos = 0;
            }
        } else {
            res = this.compute(new byte[0], 0, 0, true);
        }
        this.initialized = false;
        this.reinitialize();
        return res;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length - outputOffset < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("The output buffer is too small");
        }
        byte[] res = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    private byte[] compute(byte[] input, int offset, int inputLen, boolean pad) throws BadPaddingException {
        try {
            if (this.opMode == 1) {
                return this.cipher.encrypt(input, offset, inputLen, pad);
            }
            if (this.opMode == 2) {
                return this.cipher.decrypt(input, offset, inputLen, pad);
            }
            throw new IllegalStateException("Illegal mode: " + this.mode);
        }
        catch (CipherException ex) {
            throw new BadPaddingException(ex.toString());
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, java.security.InvalidKeyException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 4) {
            throw new IllegalStateException("Illegal use: cipher initialized for wrapping only");
        }
        if (!(key instanceof java.security.PrivateKey) && !(key instanceof SecretKey)) {
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        try {
            if (key instanceof java.security.PrivateKey) {
                return this.cipher.wrapKey(PhaosJCEKeyTranslator.jcePrivateKeyToPhaos((java.security.PrivateKey)key));
            }
            if (key instanceof SecretKey) {
                return this.cipher.wrapKey(PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            }
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws java.security.InvalidKeyException, NoSuchAlgorithmException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 3) {
            throw new IllegalStateException("Illegal use: cipher initialized for unwrapping only");
        }
        try {
            if (wrappedKeyType == 2) {
                PrivateKey privKey = this.cipher.unwrapPrivateKey(wrappedKey);
                return PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(privKey);
            }
            if (wrappedKeyType == 3) {
                SymmetricKey symKey = this.cipher.unwrapSymmetricKey(wrappedKey, new AlgorithmIdentifier(PhaosAlgorithmParametersSpi.stringToOid(wrappedKeyAlgorithm)));
                return new SecretKeyImpl(symKey, wrappedKeyAlgorithm);
            }
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
    }

    protected int engineGetKeySize(Key key) throws java.security.InvalidKeyException {
        if (key == null || !"RAW".equals(key.getFormat())) {
            throw new java.security.InvalidKeyException("Key is not in a valid format");
        }
        return PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key).keySize() * 8;
    }
}

