/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;

public class PKCS8KeyStoreSpi
extends KeyStoreSpi {
    private byte[] contents;
    private byte[] encKey;
    private PrivateKey key;
    private String label = "Key";
    private PrivateKeyPKCS8 pkcs8 = new PrivateKeyPKCS8();

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias != null && !this.label.equals(alias)) {
            return null;
        }
        return PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(this.pkcs8.getKey(new String(password)));
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        throw new RuntimeException("Method not supported");
    }

    public Certificate engineGetCertificate(String alias) {
        throw new RuntimeException("Method not supported");
    }

    public Date engineGetCreationDate(String alias) {
        throw new RuntimeException("This method is not supported");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("The key is not a private key");
        }
        this.label = alias;
        this.pkcs8.setPrivateKey(PhaosJCEKeyTranslator.jcePrivateKeyToPhaos((PrivateKey)key));
        if (password != null) {
            this.pkcs8.setPassword(new String(password));
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported");
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported");
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Operation not supported");
    }

    public Enumeration engineAliases() {
        Vector<String> vec = new Vector<String>();
        vec.addElement(this.label);
        return vec.elements();
    }

    public boolean engineContainsAlias(String alias) {
        return this.label.equals(alias);
    }

    public int engineSize() {
        return this.key != null || this.encKey != null ? 1 : 0;
    }

    public boolean engineIsKeyEntry(String alias) {
        return true;
    }

    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null) {
            this.pkcs8.setPassword(new String(password));
        }
        this.pkcs8.output(stream);
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            return;
        }
        this.pkcs8.input(stream);
        if (password != null) {
            this.pkcs8.setPassword(new String(password));
        }
    }
}

