/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.provider.PhaosKeyPairGeneratorSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public class DSAKeyPairGeneratorSpi
extends PhaosKeyPairGeneratorSpi
implements DSAKeyPairGenerator {
    public DSAKeyPairGeneratorSpi() throws AlgorithmIdentifierException {
        super(KeyPairGenerator.getInstance((AlgorithmIdentifier)AlgID.dsa));
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof java.security.interfaces.DSAParams)) {
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec: " + params);
        }
        this.initialize((java.security.interfaces.DSAParams)((Object)params), random);
    }

    public void initialize(java.security.interfaces.DSAParams params, SecureRandom random) throws InvalidParameterException {
        try {
            DSAParams p = new DSAParams(params.getP(), params.getQ(), params.getG());
            this.kpg.setRandomBitsSource((RandomBitsSource)(random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random)));
            this.kpg.setAlgID(new AlgorithmIdentifier(AlgID.dsa.getOID(), (ASN1Object)p));
            this.initialized = true;
        }
        catch (AlgorithmIdentifierException ex) {
            throw new InvalidParameterException(ex.toString());
        }
    }

    public void initialize(int modLen, boolean genParams, SecureRandom random) throws InvalidParameterException {
        DSAParams params;
        if (genParams) {
            params = oracle.security.crypto.core.DSAKeyPairGenerator.generateParameters((int)modLen, (RandomBitsSource)(random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random)));
        } else if (modLen == 512 || modLen == 768 || modLen == 1024) {
            params = oracle.security.crypto.core.DSAKeyPairGenerator.getParameters((int)modLen, null);
        } else {
            throw new InvalidParameterException("No default DSA parameters for the modLen specified: " + modLen);
        }
        this.initialize(new DSAParameterSpec(params.getP(), params.getQ(), params.getG()), random);
    }
}

