/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import oracle.security.crypto.core.DHParameterGenerator;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class DHAlgorithmParameterGeneratorSpi
extends AlgorithmParameterGeneratorSpi {
    private DHParameterGenerator gen = new DHParameterGenerator();
    private boolean initialized = false;

    protected void engineInit(int size, SecureRandom random) {
        if (random != null) {
            this.gen.initialize(size, 160, (RandomBitsSource)new SRRandomBitsSource(random));
        } else {
            this.gen.initialize(size, 160);
        }
        this.initialized = true;
    }

    protected void engineInit(AlgorithmParameterSpec genParamsSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (genParamsSpec instanceof DHGenParameterSpec) {
            DHGenParameterSpec dhParams = (DHGenParameterSpec)genParamsSpec;
            if (random != null) {
                this.gen.initialize(dhParams.getPrimeSize(), dhParams.getExponentSize(), (RandomBitsSource)new SRRandomBitsSource(random));
            } else {
                this.gen.initialize(dhParams.getPrimeSize(), dhParams.getExponentSize());
            }
            this.initialized = true;
        }
        throw new InvalidAlgorithmParameterException("Invalid parameter");
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (!this.initialized) {
            throw new IllegalStateException("The Generator is not initialized");
        }
        DHParams p = this.gen.generateParameters();
        try {
            AlgorithmParameters algParam = AlgorithmParameters.getInstance("DH", "OracleJCE");
            algParam.init(Utils.toBytes((Streamable)p));
            return algParam;
        }
        catch (NoSuchProviderException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

