/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.provider.PhaosBlockCipherSpi;

public class AESSpi
extends PhaosBlockCipherSpi {
    public AESSpi() {
        super(AlgID.aes128_ECB);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.updateAlgID(key);
        super.engineInit(opMode, key, params, random);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.updateAlgID(key);
        super.engineInit(opMode, key, paramSpec, random);
    }

    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        this.updateAlgID(key);
        super.engineInit(opMode, key, random);
    }

    private void updateAlgID(Key key) throws InvalidKeyException {
        block5: {
            SymmetricKey k = PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key);
            int bitLength = k.getBitLength();
            try {
                if (bitLength == 128) {
                    this.algID = this.mode == 0 ? new AlgorithmIdentifier(AlgID.aes128_ECB.getOID(), this.algID.getParameters()) : new CBCAlgorithmIdentifier(AlgID.aes128_CBC.getOID(), this.algID.getParameters());
                    break block5;
                }
                if (bitLength == 192) {
                    this.algID = this.mode == 0 ? new AlgorithmIdentifier(AlgID.aes192_ECB.getOID(), this.algID.getParameters()) : new CBCAlgorithmIdentifier(AlgID.aes192_CBC.getOID(), this.algID.getParameters());
                    break block5;
                }
                if (bitLength == 256) {
                    this.algID = this.mode == 0 ? new AlgorithmIdentifier(AlgID.aes256_ECB.getOID(), this.algID.getParameters()) : new CBCAlgorithmIdentifier(AlgID.aes256_CBC.getOID(), this.algID.getParameters());
                    break block5;
                }
                throw new InvalidKeyException("Key length not supported: " + bitLength);
            }
            catch (AlgorithmIdentifierException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

