/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValue
implements ASN1Object {
    private ASN1Sequence contents;
    private ASN1ObjectID type = null;
    private ASN1Object value = null;

    public AttributeTypeAndValue(ASN1ObjectID type, ASN1Object value) {
        this.type = type;
        this.value = value;
    }

    public AttributeTypeAndValue(InputStream is) throws IOException {
        this.input(is);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public void input(InputStream is) throws IOException {
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.type = new ASN1ObjectID((InputStream)seq);
        this.value = ASN1Utils.inputASN1Object((InputStream)seq);
        seq.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.type);
            s.addElement(this.value);
            this.contents = s;
        }
        return this.contents;
    }
}

