/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleConnectionCacheEventListener
implements ConnectionEventListener,
Serializable {
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    protected OracleImplicitConnectionCache implicitCache = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:46_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleConnectionCacheEventListener() {
        this(null);
    }

    public OracleConnectionCacheEventListener(OracleImplicitConnectionCache oracleImplicitConnectionCache) {
        this.implicitCache = oracleImplicitConnectionCache;
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (this.implicitCache != null) {
                this.implicitCache.reusePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            if (this.implicitCache != null) {
                this.implicitCache.closePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

