/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:36_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSetImpl;
        this.metadata = null;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n2;
        this.rsetConcurency = n3;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.beginColumnIndex = ScrollableResultSet.needIdentifier(n2, n3) ? 1 : 0;
        this.columnCount = 0;
        this.wasNull = -1;
        this.rsetCache = scrollRsetStatement.getResultSetCache();
        if (this.rsetCache == null) {
            this.rsetCache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.rsetCache.clear();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
        }
        this.currentRow = 0;
        this.numRowsCached = 0;
        this.allRowsCached = false;
        this.lastRefetchSz = 0;
        this.refetchRowids = null;
        this.refetchStmt = null;
        this.usrFetchDirection = 1000;
        this.getInternalMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.refetchStmt != null) {
                this.refetchStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            if (this.refetchRowids != null) {
                this.refetchRowids.removeAllElements();
            }
            this.resultSet = null;
            this.scrollStmt = null;
            this.refetchStmt = null;
            this.refetchRowids = null;
            this.metadata = null;
            try {
                if (this.rsetCache != null) {
                    this.rsetCache.clear();
                    this.rsetCache.close();
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            }
            finally {
                this.rsetCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.wasNull == -1) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24);
            }
            return this.wasNull == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return (Statement)((Object)this.scrollStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBeginColumnIndex() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.beginColumnIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getResultSet() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeRowInCache(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.isEmptyResultSet() && this.isValidRow(n2)) {
                this.removeCachedRowAt(n2);
                --this.numRowsCached;
                if (n2 >= this.currentRow) {
                    --this.currentRow;
                }
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshRowsInCache(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl = null;
            int n5 = 0;
            n5 = this.get_refetch_size(n2, n3, n4);
            try {
                if (n5 > 0) {
                    if (n5 != this.lastRefetchSz) {
                        if (this.refetchStmt != null) {
                            this.refetchStmt.close();
                        }
                        this.refetchStmt = this.prepare_refetch_statement(n5);
                        this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                        this.lastRefetchSz = n5;
                    }
                    this.prepare_refetch_binds(this.refetchStmt, n5);
                    oracleResultSetImpl = (OracleResultSetImpl)this.refetchStmt.executeQuery();
                    this.save_refetch_results(oracleResultSetImpl, n2, n5, n4);
                }
            }
            finally {
                if (oracleResultSetImpl != null) {
                    oracleResultSetImpl.close();
                }
            }
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return !this.isEmptyResultSet() && this.currentRow < 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.currentRow == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.isEmptyResultSet()) {
                this.currentRow = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.isEmptyResultSet()) {
                this.currentRow = this.getLastRow() + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = 1;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.getLastRow();
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isValidRow(this.currentRow)) {
                return this.currentRow;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 == 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "absolute(" + n2 + ")");
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            if (n2 > 0) {
                this.currentRow = n2;
            } else if (n2 < 0) {
                this.currentRow = this.getLastRow() + 1 + n2;
            }
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isEmptyResultSet()) {
                return false;
            }
            if (this.isValidRow(this.currentRow)) {
                this.currentRow += n2;
                return this.isValidRow(this.currentRow);
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 82, "relative");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isEmptyResultSet()) {
                return false;
            }
            this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
            return this.isValidRow(this.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            this.wasNull = -1;
            if (!this.isValidRow(this.currentRow)) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.wasNull = (datum = this.getCachedDatumValueAt(this.currentRow, n2 + this.beginColumnIndex)) == null ? 1 : 0;
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                switch (this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex)) {
                    case 2005: {
                        CLOB cLOB = (CLOB)datum;
                        return cLOB.getSubString(1L, (int)cLOB.length());
                    }
                }
                return datum.stringValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.booleanValue();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.byteValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.intValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.longValue();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.doubleValue();
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return ((RAW)datum).shareBytes();
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Date date = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case -101: {
                        date = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                        break;
                    }
                    case -102: {
                        date = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                        break;
                    }
                    default: {
                        date = datum.dateValue();
                    }
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Time time = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case 93: {
                        time = ((TIMESTAMP)datum).timeValue();
                        break;
                    }
                    case -101: {
                        time = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                        break;
                    }
                    case -102: {
                        time = ((TIMESTAMPLTZ)datum).timeValue(this.connection);
                        break;
                    }
                    default: {
                        time = datum.timeValue();
                    }
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Timestamp timestamp = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case 93: {
                        timestamp = ((TIMESTAMP)datum).timestampValue();
                        break;
                    }
                    case -101: {
                        timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                        break;
                    }
                    case -102: {
                        timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, ((OracleStatement)this.scrollStmt).getDefaultCalendar());
                        break;
                    }
                    default: {
                        timestamp = datum.timestampValue();
                    }
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    public Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.connection.getTypeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object = null;
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                int n3 = this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex);
                switch (n3) {
                    case 2002: {
                        object = ((STRUCT)datum).toJdbc(map);
                        break;
                    }
                    case 91: {
                        if (this.connection.mapDateToTimestamp) {
                            object = datum.toJdbc();
                            break;
                        }
                        object = datum.dateValue();
                        break;
                    }
                    default: {
                        object = datum.toJdbc();
                    }
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Date date = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case 93: {
                        date = new Date(((TIMESTAMP)datum).timestampValue(calendar).getTime());
                        break;
                    }
                    case -101: {
                        date = new Date(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                        break;
                    }
                    case -102: {
                        date = new Date(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar).getTime());
                        break;
                    }
                    case 91: {
                        date = ((DATE)datum).dateValue(calendar);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDate");
                    }
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Time time = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case 93: {
                        time = new Time(((TIMESTAMP)datum).timestampValue(calendar).getTime());
                        break;
                    }
                    case -101: {
                        time = new Time(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                        break;
                    }
                    case -102: {
                        time = new Time(((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar).getTime());
                        break;
                    }
                    case 91: {
                        time = ((DATE)datum).timeValue(calendar);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTime");
                    }
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            Timestamp timestamp = null;
            if (datum != null) {
                ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
                switch (resultSetMetaData.getColumnType(n2 + this.beginColumnIndex)) {
                    case 93: {
                        timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        break;
                    }
                    case -101: {
                        timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                        break;
                    }
                    case -102: {
                        timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar);
                        break;
                    }
                    case 91: {
                        timestamp = ((DATE)datum).timestampValue(calendar);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTimestamp");
                    }
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL = null;
            int n3 = this.getInternalMetadata().getColumnType(n2 + this.beginColumnIndex);
            int n4 = SQLUtil.getInternalType(n3);
            if (n4 == 96 || n4 == 1 || n4 == 8) {
                try {
                    uRL = new URL(this.getString(n2));
                }
                catch (MalformedURLException malformedURLException) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 136);
                }
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Conversion to java.net.URL not supported.");
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                if (datum instanceof TIMESTAMP) {
                    return TIMESTAMP.toDATE(datum.getBytes());
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10);
            }
            return this.resultSet.findColumn(string) - this.beginColumnIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 == 1000) {
                this.usrFetchDirection = n2;
            } else if (n2 == 1001 || n2 == 1002) {
                this.usrFetchDirection = n2;
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
            } else {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return 1000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.resultSet.getFetchSize();
        }
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsetConcurency;
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow");
        }
        if (this.isValidRow(this.currentRow)) {
            int n2 = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 82, "refreshRow");
        }
    }

    public void setCurrentRowValueAt(Object object, int n2, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.currentRow, n2, object2);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
        }
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.numRowsCached != 0) {
            return false;
        }
        if (this.numRowsCached == 0 && this.allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int n2) throws SQLException {
        if (n2 > 0 && n2 <= this.numRowsCached) {
            return true;
        }
        if (n2 <= 0) {
            return false;
        }
        return this.cacheRowAt(n2);
    }

    private boolean cacheRowAt(int n2) throws SQLException {
        while (this.numRowsCached < n2 && this.resultSet.next()) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                byte[] byArray = this.resultSet.privateGetBytes(i2 + 1);
                this.putCachedValueAt(this.numRowsCached + 1, i2 + 1, byArray);
            }
            ++this.numRowsCached;
        }
        if (this.numRowsCached < n2) {
            this.allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.resultSet.next()) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.putCachedValueAt(this.numRowsCached + 1, i2 + 1, this.resultSet.privateGetBytes(i2 + 1));
            }
            ++this.numRowsCached;
        }
        this.allRowsCached = true;
        return this.numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            int n2 = this.resultSet.statement.numberOfDefinePositions;
            this.columnCount = this.resultSet.statement.accessors != null && n2 > 0 ? n2 : this.getInternalMetadata().getColumnCount();
        }
        return this.columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.resultSet.getMetaData();
        }
        return this.metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.allRowsCached) {
            this.cacheAllRows();
        }
        return this.numRowsCached;
    }

    private int get_refetch_size(int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        int n6 = 0;
        if (this.refetchRowids == null) {
            this.refetchRowids = new Vector(10);
        } else {
            this.refetchRowids.removeAllElements();
        }
        while (n6 < n3 && this.isValidRow(n2 + n6 * n5)) {
            this.refetchRowids.addElement(this.getCachedDatumValueAt(n2 + n6 * n5, 1));
            ++n6;
        }
        return n6;
    }

    private OraclePreparedStatement prepare_refetch_statement(int n2) throws SQLException {
        if (n2 < 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, n2));
        return (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = this.scrollStmt.copyBinds(oraclePreparedStatement, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            oraclePreparedStatement.setROWID(n3 + i2 + 1, (ROWID)this.refetchRowids.elementAt(i2));
        }
    }

    private void save_refetch_results(OracleResultSetImpl oracleResultSetImpl, int n2, int n3, int n4) throws SQLException {
        int n5;
        int n6 = n5 = n4 == 1001 ? -1 : 1;
        while (oracleResultSetImpl.next()) {
            ROWID rOWID = oracleResultSetImpl.getROWID(1);
            boolean bl = false;
            int n7 = n2;
            while (!bl && n7 < n2 + n3 * n5) {
                if (((ROWID)this.getCachedDatumValueAt(n7, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n7 += n5;
            }
            if (!bl) continue;
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.putCachedValueAt(n7, i2 + 1, oracleResultSetImpl.privateGetBytes(i2 + 1));
            }
        }
    }

    private Object getCachedValueAt(int n2, int n3) throws SQLException {
        try {
            return this.rsetCache.get(n2, n3);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            return null;
        }
    }

    private Datum getCachedDatumValueAt(int n2, int n3) throws SQLException {
        Object object = null;
        try {
            object = this.rsetCache.get(n2, n3);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        Datum datum = null;
        if (object != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n4 = this.getInternalMetadata().getColumnType(n3);
                int n5 = this.getInternalMetadata().getColumnDisplaySize(n3);
                int n6 = this.scrollStmt.getMaxFieldSize();
                if (n6 > 0 && n6 < n5) {
                    n5 = n6;
                }
                String string = null;
                if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n3);
                }
                int n7 = SQLUtil.getInternalType(n4);
                short s2 = this.resultSet.statement.accessors[n3 - 1].formOfUse;
                datum = s2 == 2 && (n7 == 96 || n7 == 1 || n7 == 8 || n7 == 112) ? SQLUtil.makeNDatum(this.connection, (byte[])object, n7, string, s2, n5) : SQLUtil.makeDatum((OracleConnection)this.connection, (byte[])object, n7, string, n5);
                try {
                    this.rsetCache.put(n2, n3, datum);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                }
            } else {
                try {
                    this.rsetCache.put(n2, n3, null);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                }
            }
        }
        return datum;
    }

    private void putCachedValueAt(int n2, int n3, Object object) throws SQLException {
        try {
            this.rsetCache.put(n2, n3, object);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    private void removeCachedRowAt(int n2) throws SQLException {
        try {
            this.rsetCache.remove(n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    public static boolean needIdentifier(int n2, int n3) {
        return (n2 != 1003 || n3 != 1007) && (n2 != 1004 || n3 != 1007);
    }

    public static boolean needCache(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public static boolean supportRefreshRow(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    int getFirstUserColumnIndex() {
        return this.beginColumnIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            return null;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }
}

