/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int elementInternalType;
    int maxNumberOfElements;
    int elementMaxLen;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:35_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    PlsqlIndexTableAccessor(OracleStatement oracleStatement, int n2, int n3, int n4, int n5, short s2, boolean bl) throws SQLException {
        this.init(oracleStatement, 998, 998, s2, bl);
        this.elementInternalType = n3;
        this.maxNumberOfElements = n5;
        this.elementMaxLen = n4;
        this.initForDataAccess(n2, n4, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        switch (this.elementInternalType) {
            case 1: 
            case 96: {
                this.internalTypeMaxLength = 2000;
                this.elementMaxLen = (n3 == 0 ? this.internalTypeMaxLength : n3) + 1;
                this.ibtCharLength = this.elementMaxLen * this.maxNumberOfElements;
                this.elementInternalType = 9;
                break;
            }
            case 6: {
                this.internalTypeMaxLength = 21;
                this.elementMaxLen = this.internalTypeMaxLength + 1;
                this.ibtByteLength = this.elementMaxLen * this.maxNumberOfElements;
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
            }
        }
    }

    Object[] getPlsqlIndexTable(int n2) throws SQLException {
        Object[] objectArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n3 = (sArray[this.ibtMetaIndex + 4] >> 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n4 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                objectArray = new String[n3];
                char[] cArray = this.statement.ibtBindChars;
                for (int i2 = 0; i2 < n3; ++i2) {
                    objectArray[i2] = sArray[this.ibtIndicatorIndex + i2] == -1 ? null : new String(cArray, n4 + 1, cArray[n4] >> 1);
                    n4 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                objectArray = new BigDecimal[n3];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (sArray[this.ibtIndicatorIndex + i3] == -1) {
                        objectArray[i3] = null;
                    } else {
                        byte by = byArray[n4];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n4 + 1, byArray2, 0, by);
                        objectArray[i3] = oracle.sql.NUMBER.toBigDecimal(byArray2);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
            }
        }
        return objectArray;
    }

    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        Datum[] datumArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n3 = (sArray[this.ibtMetaIndex + 4] >> 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n4 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                datumArray = new CHAR[n3];
                CharacterSet characterSet = CharacterSet.make(2000);
                char[] cArray = this.statement.ibtBindChars;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (sArray[this.ibtIndicatorIndex + i2] == -1) {
                        datumArray[i2] = null;
                    } else {
                        char c2 = cArray[n4];
                        byte[] byArray = new byte[c2];
                        DBConversion.javaCharsToUcs2Bytes(cArray, n4 + 1, byArray, 0, c2 >> 1);
                        datumArray[i2] = new CHAR(byArray, characterSet);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                datumArray = new NUMBER[n3];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (sArray[this.ibtIndicatorIndex + i3] == -1) {
                        datumArray[i3] = null;
                    } else {
                        byte by = byArray[n4];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n4 + 1, byArray2, 0, by);
                        datumArray[i3] = new NUMBER(byArray2);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
            }
        }
        return datumArray;
    }
}

