/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

abstract class CharCommonAccessor
extends Accessor {
    int internalMaxLengthNewer;
    int internalMaxLengthOlder;
    static final int MAX_NB_CHAR_PLSQL = 32766;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:27_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharCommonAccessor() {
    }

    void setOffsets(int n2) {
        this.columnIndex = this.statement.defineCharSubRange;
        this.statement.defineCharSubRange = this.columnIndex + n2 * this.charLength;
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5, boolean bl, int n6, int n7) throws SQLException {
        if (bl) {
            if (n2 != 23) {
                n2 = 1;
            }
            if (n4 == -1 || n4 < oracleStatement.maxFieldSize) {
                n4 = oracleStatement.maxFieldSize;
            }
        }
        this.init(oracleStatement, n2, n3, s2, bl);
        if (bl && oracleStatement.connection.defaultnchar) {
            this.formOfUse = (short)2;
        }
        this.internalMaxLengthNewer = n6;
        this.internalMaxLengthOlder = n7;
        this.initForDataAccess(n5, n4, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9, short s2, int n10, int n11) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDescribe(n2, n4, bl, n5, n6, n7, n8, n9, s2, null);
        int n12 = oracleStatement.maxFieldSize;
        if (n12 != 0 && n12 <= n4) {
            n4 = n12;
        }
        this.internalMaxLengthNewer = n10;
        this.internalMaxLengthOlder = n11;
        this.initForDataAccess(0, n4, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? this.internalMaxLengthNewer : this.internalMaxLengthOlder;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.charLength = this.internalTypeMaxLength + 1;
    }

    int getInt(int n2) throws SQLException {
        int n3 = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                n3 = Integer.parseInt(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return n3;
    }

    boolean getBoolean(int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        return bigDecimal != null && bigDecimal.signum() != 0;
    }

    short getShort(int n2) throws SQLException {
        short s2 = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                s2 = Short.parseShort(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return s2;
    }

    byte getByte(int n2) throws SQLException {
        byte by = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                by = Byte.parseByte(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return by;
    }

    long getLong(int n2) throws SQLException {
        long l2 = 0L;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                l2 = Long.parseLong(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return l2;
    }

    float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                f2 = Float.parseFloat(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return f2;
    }

    double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                d2 = Double.parseDouble(this.getString(n2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return d2;
    }

    BigDecimal getBigDecimal(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                String string = this.getString(n2);
                if (string != null) {
                    bigDecimal = new BigDecimal(string.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        }
        return bigDecimal;
    }

    BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal.setScale(n3, 6);
        }
        return bigDecimal;
    }

    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            string = new String(this.rowSpaceChar, n3 + 1, n4);
        }
        return string;
    }

    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            date = Date.valueOf(this.getString(n2).trim());
        }
        return date;
    }

    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            time = Time.valueOf(this.getString(n2).trim());
        }
        return time;
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            timestamp = Timestamp.valueOf(this.getString(n2).trim());
        }
        return timestamp;
    }

    byte[] getBytes(int n2) throws SQLException {
        return this.getBytesInternal(n2);
    }

    byte[] getBytesInternal(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            DBConversion dBConversion = this.statement.connection.conversion;
            byte[] byArray2 = new byte[n4 * 6];
            int n5 = this.formOfUse == 2 ? dBConversion.javaCharsToNCHARBytes(this.rowSpaceChar, n3 + 1, byArray2, 0, n4) : dBConversion.javaCharsToCHARBytes(this.rowSpaceChar, n3 + 1, byArray2, 0, n4);
            byArray = new byte[n5];
            System.arraycopy(byArray2, 0, byArray, 0, n5);
        }
        return byArray;
    }

    InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.CharsToStream(this.rowSpaceChar, n3 + 1, n4, 10);
        }
        return inputStream;
    }

    InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.CharsToStream(this.rowSpaceChar, n3 + 1, n4 << 1, 11);
        }
        return inputStream;
    }

    Reader getCharacterStream(int n2) throws SQLException {
        CharArrayReader charArrayReader = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            charArrayReader = new CharArrayReader(this.rowSpaceChar, n3 + 1, n4);
        }
        return charArrayReader;
    }

    InputStream getBinaryStream(int n2) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.charLength * n2;
            int n4 = this.rowSpaceChar[n3] >> 1;
            if (n4 > this.internalTypeMaxLength) {
                n4 = this.internalTypeMaxLength;
            }
            DBConversion dBConversion = this.statement.connection.conversion;
            byte[] byArray = new byte[n4 * 6];
            int n5 = this.formOfUse == 2 ? dBConversion.javaCharsToNCHARBytes(this.rowSpaceChar, n3 + 1, byArray, 0, n4) : dBConversion.javaCharsToCHARBytes(this.rowSpaceChar, n3 + 1, byArray, 0, n4);
            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n5);
        }
        return byteArrayInputStream;
    }

    Object getObject(int n2) throws SQLException {
        return this.getString(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getString(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getCHAR(n2);
    }

    CHAR getCHAR(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CharacterSet characterSet = this.formOfUse == 2 ? this.statement.connection.conversion.getDriverNCharSetObj() : this.statement.connection.conversion.getDriverCharSetObj();
        return new CHAR(byArray, characterSet);
    }

    URL getURL(int n2) throws SQLException {
        URL uRL = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            try {
                uRL = new URL(this.getString(n2));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 136);
            }
        }
        return uRL;
    }
}

