/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchObjectException;
import oracle.dss.util.xml.PropertyNode;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectNode
extends BaseObjectNode {
    protected String m_key;
    protected boolean m_isRef;

    ObjectNode(ObjectScope objectScope, Node node) {
        super(objectScope, node);
        this.m_key = ((Element)node).getAttribute("id");
        String string = ((Element)node).getAttribute("idref");
        if (string != "") {
            this.m_isRef = true;
            this.m_key = string;
        } else {
            this.m_isRef = false;
        }
    }

    public ObjectNode(String string) {
        super(string);
    }

    public ObjectNode(String string, Object object, ObjectScope objectScope) {
        super(string);
        this.m_scope = objectScope;
        this.initBuffer();
        if (object == null) {
            this.addProperty("xsi:null", "true");
        } else if (objectScope.isObjectExists(object)) {
            this.m_isRef = true;
            this.m_key = objectScope.getID(object);
            this.m_buffer.append(" idref=\"");
            this.m_buffer.append(this.m_key);
            this.m_buffer.append("\"");
        } else {
            this.m_isRef = false;
            this.m_key = objectScope.addObject(object);
            this.m_buffer.append(" id=\"");
            this.m_buffer.append(this.m_key);
            this.m_buffer.append("\"");
        }
    }

    public ObjectNode(Object object, ObjectScope objectScope) {
        this(object.getClass().getName(), object, objectScope);
    }

    public void addContainer(ContainerNode containerNode) {
        this.addChild(containerNode);
    }

    public ContainerNode getContainer(String string) {
        Element element = (Element)((XMLElement)this.m_node).getChildrenByTagName(string).item(0);
        if (element == null) {
            return null;
        }
        return new ContainerNode(this.m_scope, element);
    }

    public void addProperty(PropertyNode propertyNode) {
        if (!this.m_isRef) {
            super.addProperty(propertyNode);
        }
    }

    public void addProperty(String string, String string2, boolean bl) {
        if (!this.m_isRef) {
            super.addProperty(string, string2, bl);
        }
    }

    public void addProperty(ObjectNode objectNode) {
        if (!this.m_isRef) {
            this.addChild(objectNode);
        }
    }

    public void addProperty(String string, ObjectNode objectNode) {
        if (!this.m_isRef && string != null) {
            this.initVector();
            this.initPost();
            if (!this.m_closed) {
                this.m_nodes.addElement(String.valueOf(String.valueOf("<")) + string + ">");
                this.m_nodes.addElement(objectNode);
                this.m_nodes.addElement(String.valueOf(String.valueOf("</")) + string + ">");
                this.m_post.append(this.m_name).append(">");
                this.m_post.setCharAt(0, '<');
                this.m_post.setCharAt(1, '/');
                this.m_closed = true;
            } else {
                this.m_nodes.addElement(String.valueOf(String.valueOf("<")) + string + ">");
                this.m_nodes.addElement(objectNode);
                this.m_nodes.addElement(String.valueOf(String.valueOf("</")) + string + ">");
            }
        }
    }

    public ObjectNode getPropertyValueAsObjectNode(String string, boolean bl) {
        Element element = (Element)((XMLElement)this.m_node).getChildrenByTagName(string).item(0);
        if (element == null) {
            return null;
        }
        if (bl) {
            return new ObjectNode(this.m_scope, element);
        }
        Node node = element.getFirstChild();
        if (node instanceof Element) {
            return new ObjectNode(this.m_scope, node);
        }
        return null;
    }

    public ObjectNode getPropertyValueAsObjectNode(String string) {
        return this.getPropertyValueAsObjectNode(string, false);
    }

    public ObjectNode getPropertyValueAsObjectNode() {
        Element element = this.getFirstElement();
        if (element != null) {
            return new ObjectNode(this.m_scope, element);
        }
        return null;
    }

    public String getID() {
        return this.m_key;
    }

    public Object getReference() throws NoSuchObjectException {
        Object object = this.m_scope.getObject(this.m_key);
        if (object == null) {
            throw new NoSuchObjectException(this.m_key, this.m_scope);
        }
        return this.m_scope.getObject(this.m_key);
    }

    public boolean isReference() {
        return this.m_isRef;
    }

    public boolean registerObject(Object object) {
        return this.m_scope.addObject(this.m_key, object);
    }
}

