/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.util.StringTokenizer;
import oracle.dss.util.BASE64Decoder;
import oracle.dss.util.BASE64Encoder;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import org.w3c.dom.Node;

public class MIMENode
extends ObjectNode {
    private String m_primaryType;
    private String m_subtype;
    private boolean m_compress;
    private byte[] m_bytes;
    private String m_txt;
    private static final String ENCODE_SCHEME = "Base64";

    MIMENode(ObjectScope objectScope, Node node) {
        super(objectScope, node);
        try {
            this.m_compress = this.getPropertyValueAsBoolean("Compressed");
            String string = this.getPropertyValueAsString("Content-Type");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.hasMoreTokens()) {
                this.m_primaryType = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_subtype = stringTokenizer.nextToken();
            }
            String string2 = this.getPropertyValueAsString("Content");
            if (this.m_primaryType.equals("text")) {
                this.m_txt = string2;
            } else {
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                this.m_bytes = bASE64Decoder.decode(string2);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MIMENode(ObjectNode objectNode) {
        this(objectNode.getScope(), objectNode.getDOMElement());
    }

    public MIMENode(String string, String string2, String string3, String string4, boolean bl) {
        super(string);
        this.init(string2, string3, string4, bl);
    }

    public MIMENode(String string, byte[] byArray, String string2, String string3, boolean bl) {
        super(string);
        this.m_bytes = byArray;
        String string4 = null;
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            string4 = bASE64Encoder.encode(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.init(string4, string2, string3, bl);
    }

    private void init(String string, String string2, String string3, boolean bl) {
        this.m_primaryType = string2;
        this.m_subtype = string3;
        this.m_compress = bl;
        this.addProperty("Content-Type", String.valueOf(string2) + "/" + string3);
        this.addProperty("Content-Transfer-Encoding", ENCODE_SCHEME);
        this.addProperty("Compressed", bl);
        this.addProperty("Content", string, false);
    }

    public void useCompression(boolean bl) {
        this.m_compress = bl;
    }

    public void setPrimaryType(String string) {
        this.m_primaryType = string;
    }

    public String getPrimaryType() {
        return this.m_primaryType;
    }

    public void setSubtype(String string) {
        this.m_subtype = string;
    }

    public String getSubtype() {
        return this.m_subtype;
    }

    public byte[] getBinary() {
        return this.m_bytes;
    }

    public String getText() {
        return this.m_txt;
    }
}

