/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NumericOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutComponent;

public class LayoutSpreadTable
extends SpreadTable
implements LayoutComponent {
    private final int _DROP_FEEDBACK_SIZE = 4;
    private final int _PIVOT_SIZE = 10;
    private final int _ROW_HEADER_WIDTH = 25;
    private ColumnDS _columnHeaderDS = null.new ColumnDS();
    private EmptyDS _gridDS = null.new EmptyDS();
    private NumericOneDModel _rowHeaderDS = new NumericOneDModel(0);
    private TableDragDropAdapter _dragDrop;
    private Layout.PopupManager _popupManager;
    private int m_edge;
    int _dragIndex = -1;
    int _dropIndex = -1;
    private ListenerManager _pivotListeners;
    private boolean _ignoreReshape;
    private boolean _swapping;
    private Layout m_layout;
    private ComponentListener _componentListener;

    public LayoutSpreadTable() {
        this.setModels((TwoDModel)this._gridDS, (OneDModel)this._columnHeaderDS, (OneDModel)this._rowHeaderDS);
        this.setRowHeaderWidth(25);
        this._dragDrop = new TableDragDropAdapter(this);
        this.getGrid().setPreferredColumnsOnScreen(5);
        this._componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                LayoutSpreadTable.this._setSizes();
            }
        };
        this.addComponentListener(this._componentListener);
    }

    public void setItems(String[] stringArray) {
        this.freezeRepaints();
        this.getColumnHeader().freezeRepaints();
        this.getGrid().freezeRepaints();
        try {
            int n = this._columnHeaderDS.getItemCount();
            this._columnHeaderDS.removeItems(0, n);
            this._columnHeaderDS.addItems(0, stringArray);
            int n2 = stringArray == null ? 0 : stringArray.length;
            this._gridDS.setColumnCount(n2);
            this._setSizes();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unfreezeRepaints();
            this.getColumnHeader().unfreezeRepaints();
            this.getGrid().unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
        this.getColumnHeader().unfreezeRepaints();
        this.getGrid().unfreezeRepaints();
        this.invalidate();
        this.getGrid().invalidate();
        this.getColumnHeader().invalidate();
    }

    public String getItem(int n) {
        return this._columnHeaderDS.getElement(n);
    }

    public String[] getItems() {
        String[] stringArray = new String[this._columnHeaderDS.getItemCount()];
        int n = 0;
        while (n < this._columnHeaderDS.getItemCount()) {
            stringArray[n] = this.getItem(n);
            ++n;
        }
        return stringArray;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public void setEdge(int n) {
        this.m_edge = n;
    }

    public int getSelectedIndex() {
        Header header = this.getColumnHeader();
        return header.getSelection().getSingleItem();
    }

    public void clearSelection() {
        Header header = this.getColumnHeader();
        try {
            header.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public synchronized void addPivotListener(PivotListener pivotListener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)pivotListener);
    }

    public synchronized void removePivotListener(PivotListener pivotListener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)pivotListener);
        }
    }

    public void cleanup() {
        this.removeComponentListener(this._componentListener);
        this.setModels(null, null, null);
        this._dragDrop.cleanup();
        this._columnHeaderDS = null;
        this._gridDS = null;
        this._rowHeaderDS = null;
        this._pivotListeners = null;
        this._dragDrop = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getHeight();
        super.setBounds(n, n2, n3, n4);
        if (this._ignoreReshape) {
            return;
        }
        n4 = this.getHeight();
        if (n4 == n5) {
            return;
        }
        this._ignoreReshape = true;
        try {
            int n6 = this.getDefaultRowHeight();
            int n7 = n6 == 0 ? 0 : n4 / n6;
            this._gridDS.setRowCount(n7);
            int n8 = this._rowHeaderDS.getItemCount();
            if (n8 != n7) {
                this._rowHeaderDS.removeItems(0, n8);
                this._rowHeaderDS.addItems(0, n7);
            }
            Object var10_9 = null;
            this._ignoreReshape = false;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this._ignoreReshape = false;
            throw throwable;
        }
    }

    public Header createRowHeader(OneDModel oneDModel) {
        return null.new RowHeader(oneDModel);
    }

    public Grid createGrid(TwoDModel twoDModel) {
        return new ExtendedGrid(twoDModel);
    }

    public Header createColumnHeader(OneDModel oneDModel) {
        return new ColumnHeader(oneDModel);
    }

    public void firePivotEvent(Object object, int n, Object object2, int n2) {
        PivotEvent pivotEvent = new PivotEvent(object, 2001, object2, n, n2);
        this.processEvent((AWTEvent)pivotEvent);
    }

    public void fireSwapEvent(Object object, int n, Object object2, int n2) {
        PivotEvent pivotEvent = new PivotEvent(object, 2002, object2, n, n2);
        this.processEvent((AWTEvent)pivotEvent);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
        this.getColumnHeader().requestFocus();
    }

    public Dimension layoutCanvas() {
        if (this.getGrid().getColumnCount() != 0 || this.getParent() == null) {
            return super.layoutCanvas();
        }
        Dimension dimension = this.getParent().getSize();
        --dimension.width;
        return dimension;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processPivotEvent(PivotEvent pivotEvent) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PivotListener)enumeration.nextElement()).pivot(pivotEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((PivotListener)enumeration.nextElement()).swap(pivotEvent);
                }
                break;
            }
        }
    }

    void scrollColumnIntoView(int n) {
        ((ExtendedGrid)this.getGrid()).scrollColumnIntoView(n);
        ((ColumnHeader)this.getColumnHeader()).scrollItemIntoView(n);
    }

    void setDragItem(int n) {
        this._dragIndex = n;
        this.repaint();
    }

    void setDropLocation(int n, boolean bl) {
        if (this._dropIndex != n || this._swapping != bl) {
            int n2 = !bl ? -1 : (n == -1 ? -1 : (n == this._dragIndex ? -1 : n));
            ((ColumnHeader)this.getColumnHeader()).setSwapItem(n2);
            this._swapping = bl;
            if (n == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != n) {
                this._dropIndex = n;
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == n || this._dragIndex == n - 1)) {
                    n = -1;
                }
                this._dropIndex = n;
            }
            this.getColumnHeader().repaint();
            this.getGrid().repaint();
        }
    }

    int getElementCount() {
        return this._columnHeaderDS.getItemCount();
    }

    void paintDropFeedback(Graphics graphics) {
        if (this._swapping) {
            return;
        }
        Rectangle rectangle = this.getInnerBounds();
        Dimension dimension = this.getColumnHeader().getCanvasSize();
        boolean bl = this.getActualReadingDirection() == 1;
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n = this.getElementCount();
        int n2 = this._dropIndex < n ? this.getColumnHeader().getItemPosition(this._dropIndex) : (this._dropIndex == n && n != 0 ? this.getColumnHeader().getItemPosition(this._dropIndex - 1) + this.getColumnHeader().getItemSize(this._dropIndex - 1) : 0);
        int n3 = n2 - 2;
        int n4 = -this.getCanvasOriginX();
        if (n3 < rectangle.x + n4) {
            n3 = rectangle.x + n4;
        }
        if (n3 + 4 > rectangle.width + n4) {
            n3 = rectangle.width + n4 - 4;
        }
        if (bl) {
            graphics.fillRect(n3, 0, 4, rectangle.height);
        } else {
            graphics.fillRect(n3, 0, 4, rectangle.height);
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    protected boolean isSwap(Point point) {
        int n = -1;
        Header header = this.getColumnHeader();
        n = header.getItemAt(point.x, point.y);
        if (n == -1) {
            return false;
        }
        if (!this._canPivot(n)) {
            return false;
        }
        int n2 = header.getItemPosition(n);
        int n3 = header.getItemSize(n);
        if (point.x < n2 + 10) {
            return false;
        }
        return point.x <= n2 + n3 - 10;
    }

    protected void setLayoutPanel(Layout layout) {
        this.m_layout = layout;
    }

    protected Layout getLayoutPanel() {
        return this.m_layout;
    }

    private boolean _canPivot(int n) {
        boolean bl = true;
        if (this.m_layout != null && this.m_layout.getCanPivot(this.getEdge(), n) == 0) {
            bl = false;
        }
        return bl;
    }

    private int _getPrevPivotableIndex(int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (this._canPivot(n2)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private void _setSizes() {
        Header header = this.getColumnHeader();
        Painter painter = header.getDefaultPainter();
        BorderPainter borderPainter = header.getHeaderItemBorderPainter();
        ImmInsets immInsets = borderPainter.getInsets(this.getPaintContext());
        ImmInsets immInsets2 = header.getAppearance().getInsets();
        int n = immInsets.left + immInsets.right + immInsets2.left + immInsets2.right + 4;
        int n2 = this._columnHeaderDS.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            PaintContext paintContext = header.getItemPaintContext(n3);
            int n4 = painter.getPreferredSize((PaintContext)paintContext).width;
            this.setColumnWidth(n3, n4 + n);
            ++n3;
        }
    }

    private class TableDragDropAdapter
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        LayoutSpreadTable m_table;
        DropTarget _headerTarget;
        DropTarget _gridTarget;
        DragGestureRecognizer _recognizer;

        public TableDragDropAdapter(LayoutSpreadTable layoutSpreadTable2) {
            this.m_table = layoutSpreadTable2;
            Header header = this.m_table.getColumnHeader();
            this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)header, 2, (DragGestureListener)this);
            this._headerTarget = new DropTarget((Component)header, (DropTargetListener)this);
            this._gridTarget = new DropTarget((Component)this.m_table.getGrid(), (DropTargetListener)this);
        }

        public void cleanup() {
            this._headerTarget.setActive(false);
            this._headerTarget.setComponent(null);
            this._gridTarget.setActive(false);
            this._gridTarget.setComponent(null);
            this._recognizer.removeDragGestureListener((DragGestureListener)this);
            this._recognizer = null;
            this._headerTarget = null;
            this._gridTarget = null;
            this.m_table = null;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this._acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            boolean bl = this._isSwap(dropTargetDragEvent.getLocation());
            int n = this._getIndex(dropTargetDragEvent.getLocation(), bl);
            this._setDropLocation(n, bl);
        }

        public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._setDropLocation(-1, false);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.acceptDrop(1);
            this._setDropLocation(-1, false);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = null;
            try {
                object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            catch (IOException iOException) {
                object = null;
            }
            if (object != null && object instanceof PivotTransfer) {
                boolean bl = this._isSwap(dropTargetDropEvent.getLocation());
                int n = this._getIndex(dropTargetDropEvent.getLocation(), bl);
                if (n != -1) {
                    PivotTransfer pivotTransfer = (PivotTransfer)object;
                    Object object2 = pivotTransfer.getSource();
                    int n2 = pivotTransfer.getIndex();
                    LayoutSpreadTable layoutSpreadTable = this.m_table;
                    int n3 = n;
                    if (!bl && object2 == layoutSpreadTable && n3 > n2) {
                        --n3;
                    }
                    if (!bl) {
                        this.m_table.firePivotEvent(object2, n2, layoutSpreadTable, n3);
                    } else {
                        this.m_table.fireSwapEvent(object2, n2, layoutSpreadTable, n3);
                    }
                }
            }
            dropTargetDropEvent.dropComplete(object != null);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Header header = this.m_table.getColumnHeader();
            if (this.m_table.getElementCount() == 0) {
                return;
            }
            Point point = dragGestureEvent.getDragOrigin();
            int n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return;
            }
            if (!LayoutSpreadTable.this._canPivot(n)) {
                return;
            }
            point.x = 5;
            point.y -= header.getItemPosition(n);
            point.y = -point.y;
            Image image = null;
            this.m_table.setDragItem(n);
            dragGestureEvent.startDrag(null, image, point, PivotTransfer.createTransferable((Object)this.m_table, (int)n), (DragSourceListener)this);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.m_table.setDragItem(-1);
        }

        private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.m_table.isEnabled()) {
                return false;
            }
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            if (dataFlavorArray == null) {
                return false;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        void _setDropLocation(int n, boolean bl) {
            this.m_table.setDropLocation(n, bl);
        }

        boolean _isSwap(Point point) {
            return this.m_table.isSwap(point);
        }

        private int _getIndex(Point point, boolean bl) {
            int n = -1;
            Header header = this.m_table.getColumnHeader();
            boolean bl2 = this.m_table.getActualReadingDirection() == 1;
            point = header.convertOuterToCanvas(point.x, point.y);
            n = header.getItemAt(point.x, point.y);
            if (!bl) {
                if (n == -1) {
                    int n2 = header.getItemCount();
                    int n3 = header.getGeometryManager().getTotalSize();
                    n = point.x > n3 && n2 != 0 ? LayoutSpreadTable.this._getPrevPivotableIndex(n2 - 1) + 1 : 0;
                } else if ((n = LayoutSpreadTable.this._getPrevPivotableIndex(n)) == -1) {
                    n = 0;
                } else {
                    int n4 = header.getItemPosition(n);
                    int n5 = header.getItemSize(n);
                    if (bl2) {
                        if (point.x > n4 + n5 / 2) {
                            ++n;
                        }
                    } else if (point.x < n4 + n5 / 2) {
                        ++n;
                    }
                }
            }
            return n;
        }
    }

    private class EmptyDS
    extends AbstractTwoDModel {
        private int _columnCount;
        private int _rowCount;

        EmptyDS() {
        }

        public void setColumnCount(int n) {
            int n2 = this._columnCount;
            int n3 = n - n2;
            this._columnCount = n;
            if (n3 > 0) {
                this.fireModelEvent(2001, 0, n3);
            } else if (n3 < 0) {
                this.fireModelEvent(2002, 0, -n3);
            }
        }

        public int getColumnCount() {
            return this._columnCount;
        }

        public void setRowCount(int n) {
            int n2 = this._rowCount;
            int n3 = n - n2;
            this._rowCount = n;
            if (n3 > 0) {
                this.fireModelEvent(2004, 0, n3);
            } else if (n3 < 0) {
                this.fireModelEvent(2005, 0, -n3);
            }
        }

        public int getRowCount() {
            return this._rowCount;
        }

        public Object getData(int n, int n2) {
            return null;
        }

        public void setData(int n, int n2, Object object) {
        }
    }

    private class ExtendedGrid
    extends Grid {
        public ExtendedGrid(TwoDModel twoDModel) {
            super(twoDModel);
            this.setGridSelectionManager(null);
        }

        public Dimension layoutCanvas() {
            if (this.getColumnCount() != 0 || this.getParent() == null) {
                return super.layoutCanvas();
            }
            Dimension dimension = this.getParent().getSize();
            --dimension.width;
            return dimension;
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
            LayoutSpreadTable.this.requestFocus();
        }

        public void scrollColumnIntoView(int n) {
            super.scrollColumnIntoView(n);
        }

        public void paintCanvasInterior(Graphics graphics) {
            super.paintCanvasInterior(graphics);
            if (LayoutSpreadTable.this._dropIndex != -1) {
                LayoutSpreadTable.this.paintDropFeedback(graphics);
            }
        }
    }

    private class RowHeader
    extends Header {
        public RowHeader(OneDModel oneDModel) {
            super(oneDModel, 1);
            this.setCanMoveItems(false);
            this.setCanResizeItems(false);
            this.setHeaderSelectionManager(null);
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected int getItemPaintState(int n, int n2) {
            return n & 0xFFFFFFFD;
        }
    }

    private class ColumnDS
    extends ArrayOneDModel {
        public ColumnDS() {
            super(0);
        }

        public String getElement(int n) {
            return (String)super.getData(n);
        }

        public Object getData(int n) {
            return this.getElement(n);
        }
    }

    private class ColumnHeader
    extends Header
    implements ActionListener {
        private Color _foreColor;
        private Color _selForeColor;
        private Color _backColor;
        private Color _selBackColor;
        private final String COMMAND_LEFT = "LEFT";
        private final String COMMAND_RIGHT = "RIGHT";
        private final String COMMAND_POPUP = "SHOW_POPUP";

        public ColumnHeader(OneDModel oneDModel) {
            super(oneDModel, 0);
            this.enableEvents(4L);
            this.setDrawSelected(true);
            this.setCanMoveItems(false);
            this.setCanResizeItems(false);
            Appearance appearance = this.getAppearance();
            appearance.setHorizontalJustify(3);
            appearance.setVerticalJustify(1);
            this.setAppearance(appearance);
            this.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(1));
            this._foreColor = appearance.getForeground();
            this._selForeColor = appearance.getSelectForeground();
            this._backColor = appearance.getBackground();
            this._selBackColor = appearance.getSelectBackground();
            this._registerKeyStrokes();
        }

        protected Dimension layoutCanvas() {
            if (this.getItemCount() != 0 || this.getParent() == null) {
                return super.layoutCanvas();
            }
            return new Dimension(this.getParent().getSize().width - 1, this.getPreferredHeaderSize());
        }

        public void paintCanvasInterior(Graphics graphics) {
            super.paintCanvasInterior(graphics);
            if (LayoutSpreadTable.this._dropIndex != -1) {
                LayoutSpreadTable.this.paintDropFeedback(graphics);
            }
        }

        void setSwapItem(int n) {
            int n2 = 0;
            while (n2 < this.getItemCount()) {
                Appearance appearance = super.getItemAppearance(n2);
                if (n2 == n) {
                    PivotHeader pivotHeader = new PivotHeader();
                    EWTPivotHeaderUI eWTPivotHeaderUI = pivotHeader.getPivotHeaderUI();
                    Color color = eWTPivotHeaderUI.getSwapForegroundColor((JComponent)pivotHeader, appearance);
                    appearance.setForeground(color);
                    appearance.setSelectForeground(color);
                    color = eWTPivotHeaderUI.getSwapBackgroundColor((JComponent)pivotHeader, appearance);
                    appearance.setBackground(color);
                    appearance.setSelectBackground(color);
                } else {
                    appearance.setForeground(this._foreColor);
                    appearance.setSelectForeground(this._selForeColor);
                    appearance.setBackground(this._backColor);
                    appearance.setSelectBackground(this._selBackColor);
                }
                this.setItemAppearance(n2, appearance);
                ++n2;
            }
        }

        public boolean isFocusTraversable() {
            return LayoutSpreadTable.this.getElementCount() != 0;
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = LayoutSpreadTable.this.getElementCount();
            if (n2 == 0) {
                return;
            }
            if ("LEFT".equals(actionEvent.getActionCommand())) {
                int n3 = LayoutSpreadTable.this.getSelectedIndex() - 1;
                if (n3 < 0) {
                    n3 = 0;
                }
                this.setSelectedIndex(n3);
                LayoutSpreadTable.this.scrollColumnIntoView(n3);
            } else if ("RIGHT".equals(actionEvent.getActionCommand())) {
                int n4 = LayoutSpreadTable.this.getSelectedIndex() + 1;
                if (n4 > n2 - 1) {
                    n4 = n2 - 1;
                }
                this.setSelectedIndex(n4);
                LayoutSpreadTable.this.scrollColumnIntoView(n4);
            } else if ("SHOW_POPUP".equals(actionEvent.getActionCommand()) && (n = LayoutSpreadTable.this.getSelectedIndex()) > -1 && n < LayoutSpreadTable.this.getElementCount()) {
                String string = (String)this.getModel().getData(n);
                Point point = new Point();
                point.x = this.getItemPosition(n);
                point.y = this.getPreferredHeaderSize();
                if (LayoutSpreadTable.this._popupManager != null) {
                    LayoutSpreadTable.this._popupManager.createPopup(LayoutSpreadTable.this, string, (JComponent)((Object)this), point);
                }
            }
        }

        public void scrollItemIntoView(int n) {
            super.scrollItemIntoView(n);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            int n = focusEvent.getID();
            int n2 = -1;
            switch (n) {
                case 1004: {
                    n2 = LayoutSpreadTable.this.getSelectedIndex();
                    if (n2 != -1 || LayoutSpreadTable.this.getElementCount() == 0) break;
                    n2 = 0;
                    break;
                }
                case 1005: {
                    n2 = focusEvent.isTemporary() ? LayoutSpreadTable.this.getSelectedIndex() : -1;
                }
            }
            this.setSelectedIndex(n2);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501 && LayoutSpreadTable.this.getElementCount() != 0) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    mouseEvent.consume();
                    String string = (String)this.getModel().getData(this.getItemAt(mouseEvent.getX(), mouseEvent.getY()));
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    LayoutSpreadTable.this._popupManager.createPopup(LayoutSpreadTable.this, string, (JComponent)((Object)this), point);
                    return;
                }
                super.requestFocus();
            }
            super.processMouseEvent(mouseEvent);
        }

        void setSelectedIndex(int n) {
            try {
                if (n == -1) {
                    LayoutSpreadTable.this.getColumnHeader().deselectAll();
                } else {
                    LayoutSpreadTable.this.getColumnHeader().setSelection(new OneDSelection(n));
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        private void _registerKeyStrokes() {
            ColumnHeader columnHeader = this;
            int n = 0;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 0);
            this.registerKeyboardAction(columnHeader, "LEFT", keyStroke, n);
            keyStroke = KeyStroke.getKeyStroke(39, 0);
            this.registerKeyboardAction(columnHeader, "RIGHT", keyStroke, n);
            keyStroke = KeyStroke.getKeyStroke(121, 1);
            this.registerKeyboardAction(columnHeader, "SHOW_POPUP", keyStroke, n);
        }
    }
}

