/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.gui.layout.ColumnHeader;
import oracle.dss.util.gui.layout.DataPointGrid;
import oracle.dss.util.gui.layout.LayoutComponent;
import oracle.dss.util.gui.layout.LayoutPageItem;
import oracle.dss.util.gui.layout.LayoutPagingComponent;
import oracle.dss.util.gui.layout.LayoutPivotingEvent;
import oracle.dss.util.gui.layout.LayoutPivotingListener;
import oracle.dss.util.gui.layout.LayoutSpreadTable;
import oracle.dss.util.gui.layout.RowHeader;
import oracle.dss.util.help.HelpContext;

public class Layout
extends JPanel
implements DataDirectorListener,
HelpContext {
    protected LayoutContext m_layoutContext;
    protected LayoutAccess m_layoutAccess;
    protected DataDirector m_dataDirector;
    protected DataAccess m_dataAccess;
    protected PageComponentListener m_pageComponentListener;
    protected Vector m_vLayerNames;
    protected boolean m_bPagingControlVisible;
    protected boolean m_bHideAvailable;
    protected MultiLineLabel m_descLabel;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected JPanel m_topPanel;
    protected JPanel m_chkBoxHolderPanel;
    protected JCheckBox m_showPageItemsChkBox;
    protected JLabel m_pagingLabel;
    protected JPanel m_pagingControlPanel;
    protected JLabel m_pagingControlLabel;
    private StatusBar statusBar;
    private JLabel m_statusLabel;
    protected String m_rPageItems = "";
    protected LayoutPagingComponent m_pageEdgeLayers;
    protected PopupManager m_popupManager;
    protected Vector m_hiddenDimensions;
    protected Vector m_layoutPivotingListeners;
    protected ComponentListener m_componentListener;
    protected ResourceBundle m_rBundle;
    protected boolean m_hidePagingControl;
    protected String m_description;
    protected ErrorHandler m_eh;
    protected static final String m_method_pPivot = "performPivot";
    protected static final String m_method_getELayers = "getEdgeLayers";
    protected static final String m_method_initHDims = "initHiddenDimensions";
    public static final int HIDDEN_EDGE = 3;
    public static final String PAGEEDGEVISIBLE_CHANGED = "PageEdgeVisibleChanged";
    protected boolean m_bDelayChangesToLayoutAccess;
    protected boolean m_bCanPivotSupported;
    protected boolean m_bSuperCalled = true;
    protected String m_memberMetadataLabelType = "longName";
    protected String m_layerMetadataLabelType = "dimLongName";
    private ArrowBox arrowBox;

    public Layout() {
        this.init();
    }

    protected void updateTextUsingCorrectLocale() {
        this.m_descLabel.setText(this.getDescriptionText());
        this.m_showPageItemsChkBox.setText(StringUtils.stripMnemonic((String)this.m_rBundle.getString("Show Page Items")));
        this.m_showPageItemsChkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rBundle.getString("Show Page Items")));
        this.m_rPageItems = this.m_rBundle.getString("Page items:");
        this.m_pagingLabel.setText(StringUtils.stripMnemonic((String)this.m_rPageItems));
        this.m_pagingLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rPageItems));
        this.m_popupManager.updateTextUsingCorrectLocale();
    }

    public void setDelayChangesToLayoutAccess(boolean bl) {
        this.m_bDelayChangesToLayoutAccess = bl;
    }

    private void init() {
        this.updateResourceBundle(null);
        this.m_pageComponentListener = new PageComponentListener();
        this.m_popupManager = new PopupManager(this.m_pageComponentListener);
        this.m_popupManager.setShowHideMenuItem(this.isHideAvailable());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_topPanel = new JPanel();
        this.m_topPanel.setLayout(new BoxLayout(this.m_topPanel, 1));
        this.m_descLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
        this.m_descLabel.setPreferredAspectRatio(0.0f);
        this.m_descLabel.setAlignmentX(0.0f);
        this.m_topPanel.add((Component)this.m_descLabel);
        this.m_topPanel.add(Box.createVerticalStrut(15));
        this.m_showPageItemsChkBox = new JCheckBox();
        this.m_showPageItemsChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Layout.this.setPagingControlVisible(itemEvent.getStateChange() == 1);
            }
        });
        this.m_chkBoxHolderPanel = new JPanel();
        this.m_chkBoxHolderPanel.setLayout(new BoxLayout(this.m_chkBoxHolderPanel, 0));
        this.m_chkBoxHolderPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_showPageItemsChkBox.getPreferredSize().height));
        this.m_chkBoxHolderPanel.setMaximumSize(this.m_chkBoxHolderPanel.getPreferredSize());
        this.m_chkBoxHolderPanel.setMinimumSize(this.m_chkBoxHolderPanel.getPreferredSize());
        this.m_chkBoxHolderPanel.add(this.m_showPageItemsChkBox);
        this.m_chkBoxHolderPanel.setAlignmentX(0.0f);
        this.m_topPanel.add(this.m_chkBoxHolderPanel);
        this.m_pageEdgeLayers = new LayoutPagingComponent(2);
        this.m_pagingLabel = new JLabel();
        this.m_pagingControlPanel = this.createPagingComponentPanel(this.m_pageEdgeLayers, this.m_pagingLabel);
        this.m_pageEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_pageEdgeLayers.setMouseListener(this.m_popupManager);
        this.m_topPanel.add(this.m_pagingControlPanel);
        this.m_showPageItemsChkBox.setSelected(true);
        this.add(this.m_topPanel);
        this.statusBar = new StatusBar();
        this.m_statusLabel = new JLabel(){

            public void setText(String string) {
                if (string == this.getText()) {
                    return;
                }
                String string2 = this.getText();
                super.setText(string);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
                }
            }
        };
        this.statusBar.setAlignmentX(0.0f);
        this.statusBar.setPreferredSize(new Dimension(0, 0));
        this.statusBar.setMinimumSize(this.statusBar.getPreferredSize());
        this.statusBar.setMaximumSize(this.statusBar.getPreferredSize());
        this.statusBar.add((Component)this.m_statusLabel);
        this.statusBar.setVisible(false);
        this.add((Component)this.statusBar);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Layout.this.getDescriptionText() != null) {
                    Layout.this.m_statusLabel.setText(Layout.this.getDescriptionText());
                }
            }
        };
        this.addComponentListener(componentAdapter);
        AncestorListener ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (Layout.this.getDescriptionText() != null) {
                    Layout.this.m_statusLabel.setText(Layout.this.getDescriptionText());
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        };
        this.addAncestorListener(ancestorListener);
    }

    public String getDescriptionText() {
        return this.m_description;
    }

    public void setDescriptionText(String string) {
        this.m_description = string;
        if (this.m_descLabel != null) {
            this.m_descLabel.setText(string);
        }
    }

    public void setPagingControlVisible(boolean bl) {
        this.m_bPagingControlVisible = bl;
        this.firePropertyChange(PAGEEDGEVISIBLE_CHANGED, !bl, bl);
    }

    public boolean isPagingControlVisible() {
        return this.m_bPagingControlVisible;
    }

    public void setHideAvailable(boolean bl) {
        this.m_bHideAvailable = bl;
        if (this.m_popupManager != null) {
            this.m_popupManager.setShowHideMenuItem(bl);
        }
    }

    public boolean isHideAvailable() {
        return this.m_bHideAvailable;
    }

    public void setLayoutContext(LayoutContext layoutContext) {
        this.m_layoutContext = layoutContext;
        this.setLayoutAccess(this.m_layoutContext.createCubeLayoutAccess());
    }

    public LayoutContext getLayoutContext() {
        return this.m_layoutContext;
    }

    public void setLayoutAccess(LayoutAccess layoutAccess) {
        if (this.m_layoutAccess == layoutAccess) {
            return;
        }
        if (this.m_layoutAccess != null) {
            this.m_layoutAccess.release();
        }
        this.m_layoutAccess = layoutAccess;
        this.m_layoutAccess.setCursorEvaluation(false);
        if (this.m_layoutAccess.getDataSource() != null) {
            this.m_dataDirector = this.m_layoutAccess.getDataSource().createCubeDataDirector();
            if (this.m_dataDirector != null) {
                this.m_dataDirector.removeDataDirectorListener(this);
                this.m_dataDirector.addDataDirectorListener(this);
            }
        }
        if (this.m_dataAccess == null) {
            return;
        }
        this.updateLayerDisplay();
    }

    public LayoutAccess getLayoutAccess() {
        return this.m_layoutAccess;
    }

    public boolean apply() {
        if (this.m_layoutContext != null) {
            return this.m_layoutContext.applyLayoutAccess(this.m_layoutAccess, true);
        }
        return false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
    }

    public void addLayoutPivotingListener(LayoutPivotingListener layoutPivotingListener) {
        if (this.m_layoutPivotingListeners == null) {
            this.m_layoutPivotingListeners = new Vector();
        }
        this.m_layoutPivotingListeners.addElement(layoutPivotingListener);
    }

    public void removeLayoutPivotingListener(LayoutPivotingListener layoutPivotingListener) {
        if (this.m_layoutPivotingListeners != null) {
            this.m_layoutPivotingListeners.removeElement(layoutPivotingListener);
        }
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            return String.valueOf(this.getClass().getName()) + "_PageCtrl";
        }
        return String.valueOf(this.getClass().getName()) + "_NoPageCtrl";
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void viewDataChanged(DataChangedEvent dataChangedEvent) {
        this.setDataAccess(dataChangedEvent.getDataAccess());
    }

    public void viewDataAvailable(DataAvailableEvent dataAvailableEvent) {
        this.setDataAccess(dataAvailableEvent.getDataAccess());
    }

    public void waitDataAvailable(WaitDataAvailableEvent waitDataAvailableEvent) {
    }

    public boolean isShowing() {
        boolean bl = super.isShowing();
        if (bl && this.m_statusLabel != null) {
            this.m_statusLabel.setText("");
        }
        return bl;
    }

    private void setDataAccess(DataAccess dataAccess) {
        LayerMetadataMap layerMetadataMap;
        this.m_dataAccess = dataAccess;
        if (dataAccess == null) {
            return;
        }
        if (!this.m_bDelayChangesToLayoutAccess) {
            this.updateLayerDisplay();
        }
        if (this.m_dataDirector != null && (layerMetadataMap = this.m_dataDirector.getSupportedLayerMetadataMap()) != null) {
            this.m_bCanPivotSupported = layerMetadataMap.contains("dimCanPivot");
        }
    }

    protected void resizeDescriptionLabel() {
        int n = this.getToolkit().getFontMetrics(this.m_descLabel.getFont()).stringWidth(this.m_descLabel.getText());
        int n2 = 1;
        if (this.getSize().width < n + 20) {
            n2 = n / (this.getSize().width - 20);
            int n3 = Math.abs(n / (this.getSize().width - 20));
            if (n3 > 0) {
                ++n2;
            }
        }
        this.m_descLabel.setPreferredRows(n2);
        this.m_descLabel.setMinimumRows(this.m_descLabel.getPreferredRows());
        this.m_descLabel.setMaximumRows(this.m_descLabel.getPreferredRows());
    }

    protected boolean performPivot(int n, int n2, int n3, int n4, boolean bl) {
        block14: {
            int n5 = -1;
            try {
                int n6;
                if (bl) {
                    if (n == n2) {
                        n5 = n3 < n4 ? 3 : 2;
                    } else {
                        n6 = 0;
                        if (n2 < this.m_dataAccess.getEdgeCount()) {
                            try {
                                n6 = this.m_dataAccess.getLayerCount(n2);
                            }
                            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                                boolean bl2 = false;
                                return bl2;
                            }
                        }
                        if (n4 == 0 && n6 == 0) {
                            n5 = 4;
                        } else if (n4 >= n6) {
                            --n4;
                            n5 = 3;
                        } else {
                            n5 = 2;
                        }
                    }
                } else {
                    n5 = 1;
                }
                if (this.m_dataDirector != null && (n6 = this.m_dataDirector.pivotOK(n, n2, n3, n4, n5)) != 0) {
                    boolean bl3 = this.m_dataDirector.pivot(n, n2, n3, n4, n5);
                    return bl3;
                }
            }
            catch (Exception exception) {
                if (this.m_eh == null) break block14;
                this.m_eh.error(exception, this.getClass().getName(), m_method_pPivot);
            }
        }
        return false;
    }

    protected void addLayersToPagingComponent(PagingComponent pagingComponent, int n, boolean bl, boolean bl2) {
        this.addLayersToPagingComponent(pagingComponent, n, bl, bl2, true);
    }

    protected void addLayersToPagingComponent(PagingComponent pagingComponent, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        if (pagingComponent != null) {
            if (bl) {
                pagingComponent.removeAll();
            }
            if (!bl2 && n == this.m_layoutAccess.getMeasureEdge()) {
                bl4 = true;
            }
            Vector vector = this.getEdgeLayers(n);
            int n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                block10: {
                    String string = (String)enumeration.nextElement();
                    try {
                        if (!bl3 && this.m_layoutAccess.isSpecialDimension(n, n2, "time")) {
                            ++n2;
                            continue;
                        }
                        if (!bl4 || !this.m_layoutAccess.isSpecialDimension(n, n2, "measure")) {
                            pagingComponent.add((Component)((Object)new LayoutPageItem((String)this.m_vLayerNames.elementAt(n2), string)));
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.m_eh == null) break block10;
                        this.m_eh.error(throwable, this.getClass().getName(), "addLayersToPagingComponent");
                    }
                }
                ++n2;
            }
        }
        if (this.m_pageEdgeLayers != null && this.m_pageEdgeLayers.getItems().length != 0) {
            this.m_pagingControlPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_pagingControlPanel.getPreferredSize().height));
            this.m_pagingControlPanel.setMaximumSize(this.m_pagingControlPanel.getPreferredSize());
            this.m_pagingControlPanel.setMinimumSize(this.m_pagingControlPanel.getPreferredSize());
        } else {
            this.m_pagingControlPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_pagingLabel.getFont()).getHeight() + 23));
            this.m_pagingControlPanel.setMaximumSize(this.m_pagingControlPanel.getPreferredSize());
            this.m_pagingControlPanel.setMinimumSize(this.m_pagingControlPanel.getPreferredSize());
        }
    }

    public void setMemberMetadataLabelType(String string) {
        if (!this._isMemberMetadataLabelTypeValid(string)) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid member metadata label type", this.getClass().getName(), "public void setMemberMetadataLabelType(String type)");
            }
            return;
        }
        this.m_memberMetadataLabelType = string;
        if (this.m_dataAccess != null) {
            this.updateLayerDisplay();
        }
    }

    public String getMemberMetadataLabelType() {
        return this.m_memberMetadataLabelType;
    }

    public void setLayerMetadataLabelType(String string) {
        if (!this._isLayerMetadataLabelTypeValid(string)) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid layer metadata label type", this.getClass().getName(), "public void setLayerMetadataLabelType(String type)");
            }
            return;
        }
        this.m_layerMetadataLabelType = string;
        if (this.m_dataAccess != null) {
            this.updateLayerDisplay();
        }
    }

    public String getLayerMetadataLabelType() {
        return this.m_layerMetadataLabelType;
    }

    public void hidePagingControlOptions() {
        this.m_topPanel.remove(this.m_chkBoxHolderPanel);
        this.setPagingControlVisible(false);
        this.m_hidePagingControl = true;
        this.revalidate();
    }

    private boolean _isMemberMetadataLabelTypeValid(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("longName") || string.equals("mediumName") || string.equals("value") || string.equals("shortName");
    }

    private boolean _isLayerMetadataLabelTypeValid(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("dimLongName") || string.equals("dimMediumName") || string.equals("dimName") || string.equals("dimShortName");
    }

    protected Vector getEdgeLayers(int n) {
        Vector<String> vector;
        block5: {
            vector = new Vector<String>();
            try {
                if (this.m_dataAccess != null) {
                    int n2 = this.m_dataAccess.getLayerCount(n);
                    this.m_vLayerNames = new Vector();
                    int n3 = 0;
                    while (n3 < n2) {
                        Object object = this.m_dataAccess.getLayerMetadata(n, n3, "dimName");
                        Object object2 = this.m_dataAccess.getLayerMetadata(n, n3, this.getLayerMetadataLabelType());
                        if (object != null && object2 != null) {
                            vector.addElement(object2.toString());
                            this.m_vLayerNames.addElement(object.toString());
                        }
                        ++n3;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.m_eh == null) break block5;
                this.m_eh.error(throwable, this.getClass().getName(), m_method_getELayers);
            }
        }
        return vector;
    }

    protected void updateLayerDisplay() {
        this.initHiddenDimensions();
    }

    protected void initHiddenDimensions() {
        block6: {
            if (this.m_dataAccess != null) {
                int n = this.m_dataAccess.getEdgeCount();
                this.m_hiddenDimensions = new Vector();
                try {
                    if (3 < n) {
                        int n2 = this.m_dataAccess.getLayerCount(3);
                        int n3 = 0;
                        while (n3 < n2) {
                            Object object = this.m_dataAccess.getLayerMetadata(3, n3, "dimName");
                            if (object != null) {
                                this.m_hiddenDimensions.addElement(new String(object.toString()));
                            }
                            ++n3;
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.m_eh == null) break block6;
                    this.m_eh.error(exception, this.getClass().getName(), m_method_initHDims);
                }
            }
        }
    }

    protected JPanel createPagingComponentPanel(PagingComponent pagingComponent, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel.setLabelFor((Component)pagingComponent);
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        pagingComponent.setSwapAllowed(true);
        pagingComponent.addPivotListener((PagingPivotListener)this.m_pageComponentListener);
        this.arrowBox = new ArrowBox((Component)pagingComponent);
        jPanel.add((Component)this.arrowBox);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return jPanel;
    }

    protected void updateResourceBundle(Locale locale) {
        if (locale != null) {
            this.m_rBundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale);
            this.updateTextUsingCorrectLocale();
        } else {
            this.m_rBundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
        }
    }

    protected boolean processLayoutPivotingEvent(Object object, Object object2, int n, int n2, boolean bl) {
        if (object != null && object instanceof LayoutComponent) {
            LayoutPivotingEvent layoutPivotingEvent;
            int n3 = ((LayoutComponent)object).getEdge();
            int n4 = 3;
            if (object2 != null && object2 instanceof LayoutComponent) {
                n4 = ((LayoutComponent)object2).getEdge();
            }
            if (!this.fireLayoutPivotingEvent(layoutPivotingEvent = new LayoutPivotingEvent(this, n3, n4, n, n2, !bl))) {
                return false;
            }
            if (!this.m_bDelayChangesToLayoutAccess) {
                this.performPivot(n3, n4, n, n2, bl);
                this.fireLayoutPivotedEvent(layoutPivotingEvent);
            }
        }
        return true;
    }

    protected void fireLayoutPivotedEvent(LayoutPivotingEvent layoutPivotingEvent) {
        if (this.m_layoutPivotingListeners != null) {
            Enumeration enumeration = this.m_layoutPivotingListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((LayoutPivotingListener)enumeration.nextElement()).layoutPivoted(layoutPivotingEvent);
            }
        }
    }

    protected boolean fireLayoutPivotingEvent(LayoutPivotingEvent layoutPivotingEvent) {
        if (this.m_layoutPivotingListeners != null) {
            Enumeration enumeration = this.m_layoutPivotingListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((LayoutPivotingListener)enumeration.nextElement()).layoutPivoting(layoutPivotingEvent);
                if (!layoutPivotingEvent.isConsumed()) continue;
                return false;
            }
        }
        return true;
    }

    protected int getCanPivot(int n, int n2) {
        int n3;
        block6: {
            n3 = 1;
            if (this.m_bCanPivotSupported) {
                try {
                    Object object = this.m_dataAccess.getLayerMetadata(n, n2, "dimCanPivot");
                    if (object != null && object instanceof Integer) {
                        n3 = (Integer)object;
                    }
                }
                catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                    if (this.m_eh != null) {
                        this.m_eh.log("edge out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), "createPopup");
                    }
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    if (this.m_eh == null) break block6;
                    this.m_eh.log("layer out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), "createPopup");
                }
            }
        }
        return n3;
    }

    private class EnterToSpaceMenu
    extends JMenu {
        public EnterToSpaceMenu(String string) {
            super(string);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.setKeyCode(32);
            }
            super.processKeyEvent(keyEvent);
        }
    }

    public class PageComponentListener
    implements PagingPivotListener {
        public void pivot(PagingPivotEvent pagingPivotEvent) {
            this.processPagingPivotEvent(pagingPivotEvent, true);
        }

        public void swap(PagingPivotEvent pagingPivotEvent) {
            this.processPagingPivotEvent(pagingPivotEvent, false);
        }

        private void processPagingPivotEvent(PagingPivotEvent pagingPivotEvent, boolean bl) {
            int n;
            int n2;
            Object object;
            if (pagingPivotEvent.getSourceIndex() == -1 || pagingPivotEvent.getDestinationIndex() == -1) {
                return;
            }
            Object object2 = pagingPivotEvent.getSource();
            if (!Layout.this.processLayoutPivotingEvent(object2, object = pagingPivotEvent.getDestination(), n2 = pagingPivotEvent.getSourceIndex(), n = pagingPivotEvent.getDestinationIndex(), bl)) {
                return;
            }
            if (Layout.this.m_bDelayChangesToLayoutAccess) {
                PagingComponent pagingComponent = (PagingComponent)object2;
                PagingComponent pagingComponent2 = (PagingComponent)object;
                LayoutPageItem layoutPageItem = (LayoutPageItem)pagingComponent.getItem(pagingPivotEvent.getSourceIndex());
                if (bl) {
                    pagingComponent.remove((Component)((Object)layoutPageItem));
                    if (pagingComponent2 != null) {
                        if (pagingComponent == pagingComponent2) {
                            pagingComponent2.add((Component)((Object)layoutPageItem), pagingPivotEvent.getDestinationIndex());
                        } else {
                            pagingComponent2.add((Component)((Object)new LayoutPageItem(layoutPageItem.getName(), layoutPageItem.getText())), pagingPivotEvent.getDestinationIndex());
                        }
                    }
                } else {
                    LayoutPageItem layoutPageItem2 = (LayoutPageItem)pagingComponent2.getItem(pagingPivotEvent.getDestinationIndex());
                    pagingComponent.remove((Component)((Object)layoutPageItem));
                    pagingComponent2.remove((Component)((Object)layoutPageItem2));
                    if (pagingComponent != pagingComponent2) {
                        pagingComponent.add((Component)((Object)new LayoutPageItem(layoutPageItem2.getName(), layoutPageItem2.getText())), pagingPivotEvent.getSourceIndex());
                        pagingComponent2.add((Component)((Object)new LayoutPageItem(layoutPageItem.getName(), layoutPageItem.getText())), pagingPivotEvent.getDestinationIndex());
                    } else if (pagingPivotEvent.getSourceIndex() > pagingPivotEvent.getDestinationIndex()) {
                        pagingComponent2.add((Component)((Object)layoutPageItem), pagingPivotEvent.getDestinationIndex());
                        pagingComponent.add((Component)((Object)layoutPageItem2), pagingPivotEvent.getSourceIndex());
                    } else {
                        pagingComponent.add((Component)((Object)layoutPageItem2), pagingPivotEvent.getSourceIndex());
                        pagingComponent2.add((Component)((Object)layoutPageItem), pagingPivotEvent.getDestinationIndex());
                    }
                }
            }
        }
    }

    public class PopupManager
    extends MouseAdapter
    implements ActionListener {
        private String moveTo = "";
        private String moveAbove = "";
        private String moveBelow = "";
        private String moveLeft = "";
        private String moveRight = "";
        private String hide = "";
        private String swap = "";
        private Object[] lcs = new Object[4];
        private String[] lcNames = new String[4];
        private PagingPivotListener m_pagingPivotListener;
        private PivotListener m_pivotListener;
        private boolean m_showHideMenuItem = true;

        protected void updateTextUsingCorrectLocale() {
            this.moveTo = Layout.this.m_rBundle.getString("Move to");
            this.moveAbove = Layout.this.m_rBundle.getString("Move above");
            this.moveBelow = Layout.this.m_rBundle.getString("Move below");
            this.moveLeft = Layout.this.m_rBundle.getString("Move left");
            this.moveRight = Layout.this.m_rBundle.getString("Move right");
            this.hide = Layout.this.m_rBundle.getString("Hide");
            this.swap = Layout.this.m_rBundle.getString("Swap with");
            this.setPageName(Layout.this.m_rBundle.getString("Page"));
        }

        public void setShowHideMenuItem(boolean bl) {
            this.m_showHideMenuItem = bl;
        }

        public boolean isShowHideMenuItem() {
            return this.m_showHideMenuItem;
        }

        public void setPivotListener(PivotListener pivotListener) {
            this.m_pivotListener = pivotListener;
        }

        public void setPageLayoutComponent(LayoutComponent layoutComponent) {
            this.lcs[0] = layoutComponent;
        }

        public void setRowLayoutComponent(LayoutComponent layoutComponent) {
            this.lcs[1] = layoutComponent;
        }

        public void setColumnLayoutComponent(LayoutComponent layoutComponent) {
            this.lcs[2] = layoutComponent;
        }

        public void setMeasureLayoutComponent(LayoutComponent layoutComponent) {
            this.lcs[3] = layoutComponent;
        }

        public void setPageName(String string) {
            this.lcNames[0] = string;
        }

        public void setRowName(String string) {
            this.lcNames[1] = string;
        }

        public void setColumnName(String string) {
            this.lcNames[2] = string;
        }

        public void setMeasureName(String string) {
            this.lcNames[3] = string;
        }

        public PopupManager() {
        }

        public PopupManager(PagingPivotListener pagingPivotListener) {
            this();
            this.m_pagingPivotListener = pagingPivotListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("SHOW_POPUP")) {
                PageItem pageItem = (PageItem)actionEvent.getSource();
                LayoutComponent layoutComponent = (LayoutComponent)((Object)pageItem.getParent());
                Point point = new Point(0, pageItem.getHeight());
                this.createPopup(layoutComponent, pageItem.getText(), (JComponent)pageItem, point);
            } else if (actionEvent.getSource() instanceof PivotMenuItem) {
                Object object = ((PivotMenuItem)actionEvent.getSource()).getPivotEvent();
                if (object instanceof PagingPivotEvent) {
                    PagingPivotEvent pagingPivotEvent = (PagingPivotEvent)object;
                    if (pagingPivotEvent.getID() == 2002) {
                        this.m_pagingPivotListener.swap(pagingPivotEvent);
                    } else if (pagingPivotEvent.getID() == 2001) {
                        this.m_pagingPivotListener.pivot(pagingPivotEvent);
                    }
                } else if (object instanceof PivotEvent) {
                    PivotEvent pivotEvent = (PivotEvent)object;
                    if (pivotEvent.getID() == 2002) {
                        this.m_pivotListener.swap(pivotEvent);
                    } else if (pivotEvent.getID() == 2001) {
                        this.m_pivotListener.pivot(pivotEvent);
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Container container;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (container = ((Component)mouseEvent.getSource()).getParent()) instanceof PageItem) {
                PageItem pageItem = (PageItem)container;
                LayoutComponent layoutComponent = (LayoutComponent)((Object)pageItem.getParent());
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.createPopup(layoutComponent, pageItem.getText(), (JComponent)pageItem, point);
            }
        }

        public void createPopup(LayoutComponent layoutComponent, String string, JComponent jComponent, Point point) {
            PivotMenuItem pivotMenuItem;
            Object object;
            boolean bl;
            int n;
            int n2;
            JPopupMenu jPopupMenu;
            PivotInfo[] pivotInfoArray;
            block52: {
                pivotInfoArray = null;
                String[] stringArray = null;
                String string2 = string;
                jPopupMenu = new JPopupMenu();
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                stringArray = layoutComponent.getItems();
                n2 = -1;
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
                if (Layout.this.getCanPivot(layoutComponent.getEdge(), n2) == 0) {
                    return;
                }
                bl = false;
                if (Layout.this.m_layoutAccess != null) {
                    try {
                        if (layoutComponent != null && Layout.this.m_layoutAccess.isSpecialDimension(layoutComponent.getEdge(), n2, "measure")) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        if (Layout.this.m_eh == null) break block52;
                        Layout.this.m_eh.error(exception, this.getClass().getName(), "createPopup");
                    }
                }
            }
            String string3 = this.swap;
            EnterToSpaceMenu enterToSpaceMenu = null.new EnterToSpaceMenu(string3);
            int n3 = 0;
            while (n3 < this.lcs.length) {
                if (this.lcs[n3] != null && (!(layoutComponent instanceof DataPointGrid) && (this.lcs[n3] instanceof RowHeader || this.lcs[n3] instanceof ColumnHeader || this.lcs[n3] instanceof PagingComponent || this.lcs[n3] instanceof LayoutSpreadTable) || this.lcs[n3] instanceof DataPointGrid && this.lcs[n3] == layoutComponent)) {
                    pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, false);
                    n = 0;
                    while (pivotInfoArray != null && n < pivotInfoArray.length) {
                        object = this.lcs[n3] instanceof PagingComponent ? new PagingPivotEvent((Object)layoutComponent, 2002, this.lcs[n3], n2, pivotInfoArray[n].getIndex()) : new PivotEvent((Object)layoutComponent, 2002, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                        pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                        pivotMenuItem.setPivotEvent(object);
                        pivotMenuItem.addActionListener(this);
                        enterToSpaceMenu.add(pivotMenuItem);
                        ++n;
                    }
                }
                ++n3;
            }
            if (pivotInfoArray != null && pivotInfoArray.length > 0) {
                jPopupMenu.add(enterToSpaceMenu);
            }
            String string4 = this.moveLeft;
            String string5 = this.moveRight;
            String string6 = this.moveAbove;
            String string7 = this.moveBelow;
            EnterToSpaceMenu enterToSpaceMenu2 = null.new EnterToSpaceMenu(string4);
            EnterToSpaceMenu enterToSpaceMenu3 = null.new EnterToSpaceMenu(string5);
            EnterToSpaceMenu enterToSpaceMenu4 = null.new EnterToSpaceMenu(string6);
            EnterToSpaceMenu enterToSpaceMenu5 = null.new EnterToSpaceMenu(string7);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            n3 = 0;
            while (n3 < this.lcs.length) {
                if (this.lcs[n3] != null && (!(layoutComponent instanceof DataPointGrid) && !(this.lcs[n3] instanceof DataPointGrid) || this.lcs[n3] instanceof DataPointGrid && this.lcs[n3] == layoutComponent)) {
                    if (this.lcs[n3] instanceof RowHeader || this.lcs[n3] instanceof LayoutSpreadTable) {
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex()) {
                                bl2 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu2.add(pivotMenuItem);
                            }
                            ++n;
                        }
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex() + 1) {
                                bl3 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex() + 1);
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu3.add(pivotMenuItem);
                            }
                            ++n;
                        }
                    } else if (this.lcs[n3] instanceof PagingComponent) {
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex()) {
                                bl2 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PagingPivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu2.add(pivotMenuItem);
                            }
                            ++n;
                        }
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex() + 1) {
                                bl3 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PagingPivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex() + 1);
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu3.add(pivotMenuItem);
                            }
                            ++n;
                        }
                    } else if (this.lcs[n3] instanceof ColumnHeader) {
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex()) {
                                bl4 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu4.add(pivotMenuItem);
                            }
                            ++n;
                        }
                        pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                        n = 0;
                        while (pivotInfoArray != null && n < pivotInfoArray.length) {
                            if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex() + 1) {
                                bl5 = true;
                                pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex() + 1);
                                pivotMenuItem.setPivotEvent(object);
                                pivotMenuItem.addActionListener(this);
                                enterToSpaceMenu5.add(pivotMenuItem);
                            }
                            ++n;
                        }
                    } else if (this.lcs[n3] instanceof DataPointGrid) {
                        DataPointGrid dataPointGrid = (DataPointGrid)this.lcs[n3];
                        if (dataPointGrid.getOrientation() == 0) {
                            pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                            n = 0;
                            while (pivotInfoArray != null && n < pivotInfoArray.length) {
                                if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex()) {
                                    bl2 = true;
                                    pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                    object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                                    pivotMenuItem.setPivotEvent(object);
                                    pivotMenuItem.addActionListener(this);
                                    enterToSpaceMenu2.add(pivotMenuItem);
                                }
                                ++n;
                            }
                            pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                            n = 0;
                            while (pivotInfoArray != null && n < pivotInfoArray.length) {
                                if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex() + 1) {
                                    bl3 = true;
                                    pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                    object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex() + 1);
                                    pivotMenuItem.setPivotEvent(object);
                                    pivotMenuItem.addActionListener(this);
                                    enterToSpaceMenu3.add(pivotMenuItem);
                                }
                                ++n;
                            }
                        } else if (dataPointGrid.getOrientation() == 1) {
                            pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                            n = 0;
                            while (pivotInfoArray != null && n < pivotInfoArray.length) {
                                if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex()) {
                                    bl4 = true;
                                    pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                    object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex());
                                    pivotMenuItem.setPivotEvent(object);
                                    pivotMenuItem.addActionListener(this);
                                    enterToSpaceMenu4.add(pivotMenuItem);
                                }
                                ++n;
                            }
                            pivotInfoArray = this.getPivotInfoList(((LayoutComponent)this.lcs[n3]).getEdge(), ((LayoutComponent)this.lcs[n3]).getItems(), string, true);
                            n = 0;
                            while (pivotInfoArray != null && n < pivotInfoArray.length) {
                                if (this.lcs[n3] != layoutComponent || n2 != pivotInfoArray[n].getIndex() + 1) {
                                    bl5 = true;
                                    pivotMenuItem = null.new PivotMenuItem(pivotInfoArray[n].getText());
                                    object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, pivotInfoArray[n].getIndex() + 1);
                                    pivotMenuItem.setPivotEvent(object);
                                    pivotMenuItem.addActionListener(this);
                                    enterToSpaceMenu5.add(pivotMenuItem);
                                }
                                ++n;
                            }
                        }
                    }
                }
                ++n3;
            }
            if (bl2) {
                jPopupMenu.add(enterToSpaceMenu2);
            }
            if (bl3) {
                jPopupMenu.add(enterToSpaceMenu3);
            }
            if (bl4) {
                jPopupMenu.add(enterToSpaceMenu4);
            }
            if (bl5) {
                jPopupMenu.add(enterToSpaceMenu5);
            }
            n3 = 0;
            while (n3 < this.lcs.length) {
                if (this.lcs[n3] != null && !(this.lcs[n3] instanceof DataPointGrid) && this.lcs[n3] != layoutComponent && !(layoutComponent instanceof DataPointGrid)) {
                    string3 = this.moveTo;
                    string3 = MessageFormat.format(string3, this.lcNames[n3]);
                    pivotMenuItem = null.new PivotMenuItem(string3);
                    if (this.lcs[n3] instanceof PagingComponent) {
                        object = new PagingPivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, 0);
                        pivotMenuItem.setPivotEvent(object);
                        pivotMenuItem.addActionListener(this);
                        jPopupMenu.add(pivotMenuItem);
                    } else {
                        object = new PivotEvent((Object)layoutComponent, 2001, this.lcs[n3], n2, 0);
                        pivotMenuItem.setPivotEvent(object);
                        pivotMenuItem.addActionListener(this);
                        jPopupMenu.add(pivotMenuItem);
                    }
                }
                ++n3;
            }
            if (this.m_showHideMenuItem && !bl) {
                pivotMenuItem = null.new PivotMenuItem(this.hide);
                object = new PagingPivotEvent((Object)layoutComponent, 2001, null, n2, 0);
                pivotMenuItem.setPivotEvent(object);
                pivotMenuItem.addActionListener(this);
                jPopupMenu.add(pivotMenuItem);
            }
            MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)jComponent, (int)point.x, (int)point.y);
        }

        private PivotInfo[] getPivotInfoList(int n, String[] stringArray, String string, boolean bl) {
            PivotInfo[] pivotInfoArray;
            int n2 = stringArray.length;
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                if (string.equals(stringArray[n5])) {
                    n3 = n5;
                }
                if (Layout.this.getCanPivot(n, n5) == 1) {
                    ++n4;
                }
                ++n5;
            }
            int n6 = 0;
            if (bl) {
                if (n3 == -1) {
                    pivotInfoArray = new PivotInfo[n4];
                    n5 = 0;
                    while (n5 < n2) {
                        if (Layout.this.getCanPivot(n, n5) != 0) {
                            PivotInfo pivotInfo = null.new PivotInfo();
                            pivotInfo.setText(stringArray[n5]);
                            pivotInfo.setIndex(n5);
                            pivotInfoArray[n6++] = pivotInfo;
                        }
                        ++n5;
                    }
                } else {
                    pivotInfoArray = new PivotInfo[n4 - 1];
                    n5 = 0;
                    while (n5 < n2) {
                        if (Layout.this.getCanPivot(n, n5) != 0 && n5 != n3) {
                            PivotInfo pivotInfo = null.new PivotInfo();
                            pivotInfo.setText(stringArray[n5]);
                            if (n5 < n3) {
                                pivotInfo.setIndex(n5);
                            } else {
                                pivotInfo.setIndex(n5 - 1);
                            }
                            pivotInfoArray[n6++] = pivotInfo;
                        }
                        ++n5;
                    }
                }
            } else if (n3 == -1) {
                pivotInfoArray = new PivotInfo[n4];
                n5 = 0;
                while (n5 < n2) {
                    if (Layout.this.getCanPivot(n, n5) != 0) {
                        PivotInfo pivotInfo = null.new PivotInfo();
                        pivotInfo.setText(stringArray[n5]);
                        pivotInfo.setIndex(n5);
                        pivotInfoArray[n6++] = pivotInfo;
                    }
                    ++n5;
                }
            } else {
                pivotInfoArray = new PivotInfo[n4 - 1];
                int n7 = 0;
                n5 = 0;
                while (n5 < n2) {
                    if (Layout.this.getCanPivot(n, n5) != 0 && n5 != n3) {
                        PivotInfo pivotInfo = null.new PivotInfo();
                        pivotInfo.setText(stringArray[n5]);
                        pivotInfo.setIndex(n5);
                        pivotInfoArray[n7] = pivotInfo;
                        ++n7;
                    }
                    ++n5;
                }
                if (n7 == 0) {
                    pivotInfoArray = null;
                }
            }
            return pivotInfoArray;
        }
    }

    class PivotInfo {
        private String m_text;
        private int m_index;

        PivotInfo() {
        }

        public String getText() {
            return this.m_text;
        }

        public void setText(String string) {
            this.m_text = string;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void setIndex(int n) {
            this.m_index = n;
        }
    }

    class PivotMenuItem
    extends JMenuItem {
        private Object m_pivotEvent;

        public PivotMenuItem(String string) {
            super(string);
        }

        public Object getPivotEvent() {
            return this.m_pivotEvent;
        }

        public void setPivotEvent(Object object) {
            this.m_pivotEvent = object;
        }
    }

    protected class LayoutPivotListener
    implements PivotListener {
        protected LayoutPivotListener() {
        }

        public void pivot(PivotEvent pivotEvent) {
            this.processPivotEvent(pivotEvent, true);
        }

        public void swap(PivotEvent pivotEvent) {
            this.processPivotEvent(pivotEvent, false);
        }

        private void processPivotEvent(PivotEvent pivotEvent, boolean bl) {
            Object object = pivotEvent.getSource();
            Object object2 = pivotEvent.getDestination();
            int n = pivotEvent.getSourceIndex();
            int n2 = pivotEvent.getDestinationIndex();
            Layout.this.processLayoutPivotingEvent(object, object2, n, n2, bl);
        }
    }
}

