/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import oracle.dss.util.PagingControlAttributes;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.Layout;

public class CrosstabLayout
extends Layout {
    protected Crosstab m_crosstab;
    private boolean m_bMeasuresPivotable = true;
    private Layout.PopupManager m_measuresPopupManager;
    private PagingControlAttributes m_pca;

    public CrosstabLayout() {
        this.init();
        this.updateTextUsingCorrectLocale();
    }

    protected void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        String string = this.m_rBundle.getString("Measures");
        this.m_popupManager.setRowName(this.m_rBundle.getString("Row"));
        this.m_popupManager.setColumnName(this.m_rBundle.getString("Column"));
        this.m_popupManager.setMeasureName(string);
        this.m_measuresPopupManager.setMeasureName(string);
        this.m_measuresPopupManager.updateTextUsingCorrectLocale();
    }

    private void init() {
        Layout.LayoutPivotListener layoutPivotListener = new Layout.LayoutPivotListener(this);
        this.m_popupManager.setPivotListener(layoutPivotListener);
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_crosstab = new Crosstab();
        this.m_crosstab.addPivotListener(new Layout.LayoutPivotListener(this));
        this.m_crosstab.setPopupManager(this.m_popupManager);
        this.m_measuresPopupManager = new Layout.PopupManager(this);
        this.m_measuresPopupManager.setPivotListener(layoutPivotListener);
        this.m_measuresPopupManager.setShowHideMenuItem(false);
        this.setMeasuresPivotable(true);
        this.m_crosstab.setAlignmentX(0.0f);
        this.add(this.m_crosstab);
        this.m_componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CrosstabLayout.this.resizeDescriptionLabel();
            }
        };
        this.addComponentListener(this.m_componentListener);
    }

    public void setPagingControlAttributes(PagingControlAttributes pagingControlAttributes) {
        this.m_pca = pagingControlAttributes;
        if (this.m_pca != null) {
            this.m_showPageItemsChkBox.setSelected(this.m_pca.isPagingControlVisible());
        }
    }

    public boolean apply() {
        if (this.m_pca != null) {
            this.m_pca.setPagingControlVisible(this.m_bPagingControlVisible);
        }
        return super.apply();
    }

    public String getDescriptionText() {
        if (this.m_description != null && this.m_description.length() > 0) {
            return this.m_description;
        }
        return this.m_rBundle.getString("crosstabLayoutDesc");
    }

    public void setMeasuresPivotable(boolean bl) {
        this.m_bMeasuresPivotable = bl;
        if (bl) {
            this.m_crosstab.setGridPopupManager(this.m_popupManager);
        } else {
            this.m_crosstab.setGridPopupManager(this.m_measuresPopupManager);
            this.m_popupManager.setMeasureLayoutComponent(null);
        }
    }

    public boolean isMeasuresPivotable() {
        return this.m_bMeasuresPivotable;
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            return String.valueOf(this.getClass().getName()) + "_PageCtrl";
        }
        return String.valueOf(this.getClass().getName()) + "_NoPageCtrl";
    }

    protected void updateLayerDisplay() {
        super.updateLayerDisplay();
        this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, true);
        Vector vector = this.getEdgeLayers(1);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Vector vector2 = this.getEdgeLayers(0);
        Object[] objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        this.m_crosstab.getColumnHeader().setItems((String[])objectArray2);
        this.m_crosstab.getRowHeader().setItems((String[])objectArray);
        int n = this.m_layoutAccess.getMeasureEdge();
        if (n == 1) {
            this.m_crosstab.setDataPointOrientation(1);
        } else {
            this.m_crosstab.setDataPointOrientation(0);
        }
        this.m_crosstab.getDataPointGrid().setItems(this.m_layoutAccess.getMeasures(this.getMemberMetadataLabelType()));
    }

    protected boolean performPivot(int n, int n2, int n3, int n4, boolean bl) {
        block9: {
            int n5 = -1;
            if (n == n2 && n == -1) {
                try {
                    if (super.performPivot(n, n2, n3, n4, bl)) break block9;
                    String[] stringArray = null;
                    if (this.m_layoutAccess != null && (stringArray = this.m_layoutAccess.getMeasures("value")) != null) {
                        int n6 = stringArray.length;
                        if (n3 > -1 && n3 < n6 && n4 > -1 && n4 < n6) {
                            Object[] objectArray = new String[n6];
                            Vector<String> vector = new Vector<String>();
                            int n7 = 0;
                            while (n7 < n6) {
                                vector.addElement(stringArray[n7]);
                                ++n7;
                            }
                            String string = stringArray[n3];
                            String string2 = stringArray[n4];
                            if (bl) {
                                vector.removeElementAt(n3);
                                vector.insertElementAt(string, n4);
                            } else {
                                vector.setElementAt(string2, n3);
                                vector.setElementAt(string, n4);
                            }
                            vector.copyInto(objectArray);
                            this.m_layoutAccess.setMeasures((String[])objectArray);
                            boolean bl2 = true;
                            return bl2;
                        }
                    }
                    break block9;
                }
                catch (Exception exception) {
                    if (this.m_eh != null) {
                        this.m_eh.error(exception, this.getClass().getName(), "performPivot");
                    }
                    break block9;
                }
            }
            return super.performPivot(n, n2, n3, n4, bl);
        }
        return false;
    }
}

