/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.beans.PropertyVetoException;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.util.gui.layout.AbstractCrosstabHeader;
import oracle.dss.util.gui.layout.Crosstab;

public class ColumnHeader
extends AbstractCrosstabHeader {
    public ColumnHeader(Crosstab crosstab, int n) {
        super(crosstab, 0, n);
        this.getRowHeader().setCanResizeItems(false);
        this.setRowHeaderWidth(10);
        this.getGrid().setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
    }

    public int getSelectedIndex() {
        OneDSelection oneDSelection = this.getGrid().getSelection().getRowSelection();
        if (oneDSelection.isEmpty()) {
            return -1;
        }
        return oneDSelection.getSingleItem();
    }

    public void setItems(String[] stringArray) {
        super.setItems(stringArray);
        int n = 0;
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.getElementWidth(this.getItem(n3));
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        this.setDefaultColumnWidth(n);
    }

    public void setColumnWidth(int n) {
        this.setDefaultColumnWidth(n - this.getRowHeaderWidth() - 2);
    }

    protected AbstractCrosstabHeader.CrosstabModel createModel() {
        return new ColumnModel();
    }

    protected void selectionChanged() {
        this.getCrosstab().columnSelectionChanged();
    }

    protected TwoDSelection getNewFocusSelection() {
        return new TwoDSelection(0, true);
    }

    protected void focusLost() {
        try {
            this.getRowHeader().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private class ColumnModel
    extends AbstractCrosstabHeader.CrosstabModel {
        private int _columnCount;

        ColumnModel() {
        }

        public int getColumnCount() {
            return this._columnCount;
        }

        protected AbstractPivotHeaderCell createCell(int n, int n2) {
            return null.new AbstractCrosstabHeader.ExtendedCell(0, 1, n, 1, this.getElement(n));
        }

        protected void fireEvents(int n, int n2) {
            int n3 = n2 - n;
            if (n3 > 0) {
                this.fireModelEvent(2004, 0, n3);
            } else if (n3 < 0) {
                this.fireModelEvent(2005, 0, -n3);
            }
            if (n2 != 0 && this._columnCount == 0) {
                this._columnCount = 1;
                this.fireModelEvent(2001, 0, 1);
            } else if (n2 == 0 && this._columnCount != 0) {
                this._columnCount = 0;
                this.fireModelEvent(2002, 0, 1);
            }
        }
    }
}

