/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeaderInputHandler;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutComponent;

abstract class AbstractCrosstabHeader
extends PivotHeader
implements LayoutComponent {
    public static final int SELECTOR_SIZE = 10;
    private Crosstab _crosstab;
    private int _edge;
    private CrosstabModel _model;
    private UIListener _listener;
    private Layout.PopupManager _popupManager;
    private static final int _PIVOT_SIZE = 6;

    public AbstractCrosstabHeader(Crosstab crosstab, int n, int n2) {
        super(NullTwoDModel.getTwoDModel(), n);
        this._crosstab = crosstab;
        this._edge = n2;
        this._model = this.createModel();
        this.setModel((TwoDModel)this._model);
        this.setGridFocusTraversable(true);
        this._listener = new UIListener();
        this.setInputHandler((CellInputHandler)this._listener);
        this.addPropertyChangeListener(this._listener);
        this.getGrid().addFocusListener((FocusListener)this._listener);
    }

    public abstract int getSelectedIndex();

    public void setItems(String[] stringArray) {
        this.getCrosstabModel().setItems(stringArray);
        this.invalidate();
    }

    public String getItem(int n) {
        return this.getCrosstabModel().getElement(n);
    }

    public void clearSelection() {
        try {
            this.getGrid().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getItemCount() {
        return this.getCrosstabModel().getRowCount();
    }

    public void cleanup() {
        this.getGrid().removeFocusListener((FocusListener)this._listener);
        this.removePropertyChangeListener(this._listener);
        this.setModel(NullTwoDModel.getTwoDModel());
        this.setInputHandler(null);
        this._crosstab = null;
        this._model = null;
        this._listener = null;
    }

    public int getEdge() {
        return this._edge;
    }

    public void setEdge(int n) {
        this._edge = n;
    }

    public String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable() && this.getItemCount() != 0;
    }

    protected Crosstab getCrosstab() {
        return this._crosstab;
    }

    protected CrosstabModel getCrosstabModel() {
        return this._model;
    }

    protected int getElementWidth(String string) {
        int n = 0;
        Font font = this.getFont();
        if (font != null) {
            SingleAppearanceManager singleAppearanceManager = (SingleAppearanceManager)this.getAppearanceManager();
            ImmInsets immInsets = singleAppearanceManager.getAppearance().getInsets();
            int n2 = immInsets.left + immInsets.right + 6;
            String string2 = string;
            if (string2 != null) {
                n = this.getFontMetrics(font).stringWidth(string2) + n2;
            }
        }
        return n;
    }

    protected boolean isSwap(Point point, boolean bl) {
        int n = -1;
        if (this.getOrientation() == 0) {
            Header header = this.getRowHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n2 = header.getItemPosition(n);
            int n3 = header.getItemSize(n);
            if (point.y < n2 + 6) {
                return false;
            }
            if (point.y > n2 + n3 - 6) {
                return false;
            }
        } else {
            Header header = this.getColumnHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n4 = header.getItemPosition(n);
            int n5 = this.getRowHeight(n);
            if (point.y < n4 + 6) {
                return false;
            }
            if (point.y > n4 + n5 - 6) {
                return false;
            }
        }
        return true;
    }

    protected abstract CrosstabModel createModel();

    protected abstract void selectionChanged();

    protected abstract void focusLost();

    protected abstract TwoDSelection getNewFocusSelection();

    protected void firePivotEvent(Object object, int n, Object object2, int n2) {
        this._crosstab.firePivotEvent(object, n, object2, n2);
    }

    protected void fireSwapEvent(Object object, int n, Object object2, int n2) {
        this._crosstab.fireSwapEvent(object, n, object2, n2);
    }

    private class UIListener
    extends PivotHeaderInputHandler
    implements PropertyChangeListener,
    FocusListener {
        UIListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selection".equals(propertyChangeEvent.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(propertyChangeEvent.getNewValue())) {
                AbstractCrosstabHeader.this.selectionChanged();
            }
        }

        public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    AbstractCrosstabHeader.this._crosstab.axisItemToDataPoint(AbstractCrosstabHeader.this, n2);
                    mouseEvent.consume();
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                mouseEvent.consume();
                String string = ((CrosstabModel)AbstractCrosstabHeader.this.getModel()).getElement(n2);
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < n) {
                    n3 += AbstractCrosstabHeader.this.getGrid().getColumnWidth(n5);
                    ++n5;
                }
                n5 = 0;
                while (n5 < n2) {
                    n4 += AbstractCrosstabHeader.this.getGrid().getRowHeight(n5);
                    ++n5;
                }
                Point point = new Point(n3 + mouseEvent.getX(), n4 + mouseEvent.getY());
                if (AbstractCrosstabHeader.this._popupManager != null) {
                    AbstractCrosstabHeader.this._popupManager.createPopup(AbstractCrosstabHeader.this, string, (JComponent)((Object)AbstractCrosstabHeader.this), point);
                }
                AbstractCrosstabHeader.this.getGrid().requestFocus(n, n2, null);
                try {
                    TwoDSelection twoDSelection = new TwoDSelection(n, n2);
                    AbstractCrosstabHeader.this.getGrid().setSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            super.mousePressed(mouseEvent, grid, n, n2);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                keyEvent.consume();
                PivotHeader pivotHeader = this.getHeader(grid);
                Point point = new Point();
                point.x = 0;
                point.y = AbstractCrosstabHeader.this.getRowHeight(0) * (n2 + 1);
                String string = ((CrosstabModel)AbstractCrosstabHeader.this.getModel()).getElement(n2);
                AbstractCrosstabHeader.this._popupManager.createPopup(AbstractCrosstabHeader.this, string, (JComponent)((Object)AbstractCrosstabHeader.this), point);
            }
            super.keyPressed(keyEvent, grid, n, n2);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (AbstractCrosstabHeader.this.getGrid().getRowCount() != 0) {
                AbstractCrosstabHeader.this.getGrid().requestFocus(0, 0, (AWTEvent)focusEvent);
                try {
                    TwoDSelection twoDSelection = AbstractCrosstabHeader.this.getNewFocusSelection();
                    AbstractCrosstabHeader.this.getGrid().setSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                try {
                    AbstractCrosstabHeader.this.getGrid().deselectAll();
                    AbstractCrosstabHeader.this.focusLost();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected class ExtendedCell
    extends PivotHeaderCell {
        private String _item;

        public ExtendedCell(int n, int n2, int n3, int n4, String string) {
            super(n, n2, n3, n4, null);
            this._item = string;
        }

        public Object getData() {
            return this._item;
        }
    }

    protected abstract class CrosstabModel
    extends AbstractTwoDModel {
        private ArrayOneDModel _itemStore = new ArrayOneDModel(0);
        private ArrayOneDModel _bigCellStore = new ArrayOneDModel(0);

        public abstract int getColumnCount();

        public String getElement(int n) {
            return (String)this._itemStore.getData(n);
        }

        public void setItems(String[] stringArray) {
            int n;
            int n2 = this._itemStore.getItemCount();
            this._itemStore.removeItems(0, n2);
            this._bigCellStore.removeItems(0, n2);
            int n3 = n = stringArray == null ? 0 : stringArray.length;
            if (n != 0) {
                this._itemStore.addItems(0, (Object[])stringArray);
                this._bigCellStore.addItems(0, n);
                this._updateBigCellStore();
            }
            this.fireEvents(n2, n);
        }

        public int getRowCount() {
            return this._bigCellStore.getItemCount();
        }

        public Object getData(int n, int n2) {
            if (n2 < this._bigCellStore.getItemCount()) {
                return this._bigCellStore.getData(n2);
            }
            return null;
        }

        public void setData(int n, int n2, Object object) {
        }

        protected abstract AbstractPivotHeaderCell createCell(int var1, int var2);

        protected abstract void fireEvents(int var1, int var2);

        private void _updateBigCellStore() {
            int n = this._itemStore.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                this._bigCellStore.setData(n2, (Object)this.createCell(n2, n));
                ++n2;
            }
        }
    }
}

