/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

public class ViewTextField
extends JTextField {
    protected boolean m_Underline;
    protected boolean m_DoubleUnderline;
    protected boolean m_StrikeThrough;
    protected FontMetrics m_fm;
    protected int m_baseline;

    public ViewTextField() {
        this.init();
    }

    public ViewTextField(String string) {
        super(string);
        this.init();
    }

    public ViewTextField(int n) {
        super(n);
        this.init();
    }

    public ViewTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public ViewTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    private void init() {
        this.setUnderline(false);
        this.setDoubleUnderline(false);
        this.setStrikeThrough(false);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isUnderline() || this.isDoubleUnderline() || this.isStrikeThrough()) {
            String string = this.getText();
            Border border = this.getBorder();
            Insets insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.m_fm = this.getToolkit().getFontMetrics(this.getFont());
            this.m_baseline = this.m_fm.getMaxAscent();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getWidth() - insets.right - insets.left;
            int n4 = this.getHeight() - insets.bottom - insets.top;
            n2 = insets.top + (n4 - this.m_fm.getHeight()) / 2;
            this.drawAlignedString(graphics, string, insets.left, n2, n3);
        }
    }

    protected void drawAlignedString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = this.m_fm.stringWidth(string);
        if (this.getHorizontalAlignment() != 2) {
            if (this.getHorizontalAlignment() == 0) {
                n += (n3 - n4) / 2;
            } else if (this.getHorizontalAlignment() == 4) {
                n = n + n3 - n4;
            }
        }
        this.drawEnhancedAdornments(this.m_fm, graphics, n, n2 + this.m_baseline, n4, this.isUnderline(), this.isDoubleUnderline(), this.isStrikeThrough());
    }

    protected void drawEnhancedAdornments(FontMetrics fontMetrics, Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
        } else if (bl2) {
            graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
            graphics.drawLine(n, n2 + 2 + 2, n + n3, n2 + 2 + 2);
        }
        if (bl3) {
            graphics.drawLine(n, n2 - fontMetrics.getAscent() / 2, n + n3, n2 - fontMetrics.getAscent() / 2);
        }
    }

    public boolean isUnderline() {
        return this.m_Underline;
    }

    public boolean isDoubleUnderline() {
        return this.m_DoubleUnderline;
    }

    public boolean isStrikeThrough() {
        return this.m_StrikeThrough;
    }

    public void setUnderline(boolean bl) {
        this.m_Underline = bl;
    }

    public void setDoubleUnderline(boolean bl) {
        this.m_DoubleUnderline = bl;
    }

    public void setStrikeThrough(boolean bl) {
        this.m_StrikeThrough = bl;
    }
}

