/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LightWeightComboBox
extends JComboBox {
    public static final String SEPARATOR = "|";
    public static String JAVA_VERSION_1_4 = "1.4";
    private int m_nPreviouslySelectedIndex;

    public LightWeightComboBox() {
        this.init();
    }

    public LightWeightComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init();
    }

    public LightWeightComboBox(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public LightWeightComboBox(Vector vector) {
        super(vector);
        this.init();
    }

    public void showPopup() {
        this.setPreviouslySelectedIndex(this.getSelectedIndex());
        super.showPopup();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.isPopupVisible();
        if (bl) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this.hidePopup();
                    this.setSelectedIndex(this.getPreviouslySelectedIndex());
                    break;
                }
                case 10: 
                case 32: {
                    if (keyEvent.getID() != 402) break;
                    this.hidePopup();
                    this.setSelectedIndex(LightWeightComboBox.getPopupSelectedIndex(this));
                }
            }
        } else if (keyEvent.getID() == 402 && (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 32 && !this.isEditable())) {
            this.showPopup();
        }
        switch (keyEvent.getKeyCode()) {
            case 115: {
                if (!this.isPopupVisible()) {
                    this.setPreviouslySelectedIndex(this.getSelectedIndex());
                }
                if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) && this.isEditable()) break;
                super.processKeyEvent(keyEvent);
                break;
            }
            case 27: {
                if (!bl) {
                    super.processKeyEvent(keyEvent);
                    break;
                }
                keyEvent.consume();
                break;
            }
            case 32: {
                break;
            }
            case 10: {
                if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) && !this.isPopupVisible()) {
                    if (this.isEditable()) {
                        keyEvent.consume();
                    }
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.processKeyEvent(keyEvent);
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
            }
            default: {
                super.processKeyEvent(keyEvent);
            }
        }
        if (SEPARATOR.equals(this.getItemAt(LightWeightComboBox.getPopupSelectedIndex(this)))) {
            this.processKeyEvent(new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
        if ((!this.isEditable() || bl) && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 0) {
            keyEvent.consume();
        }
    }

    public void setSelectedIndex(int n) {
        if (n != -1) {
            super.setSelectedIndex(n);
        }
    }

    public static boolean isPriorVersion(String string) {
        boolean bl = false;
        String string2 = System.getProperty("java.version");
        if (string2 != null && string2.compareTo(string) < 0) {
            bl = true;
        }
        return bl;
    }

    public static JList getList(JComboBox jComboBox) {
        Accessible accessible;
        JList<Object> jList = null;
        if (jComboBox != null && (accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0)) != null && accessible instanceof ComboPopup) {
            jList = ((ComboPopup)((Object)accessible)).getList();
        }
        return jList;
    }

    public static int getPopupSelectedIndex(JComboBox jComboBox) {
        int n = -1;
        JList jList = LightWeightComboBox.getList(jComboBox);
        if (jList != null) {
            n = jList.getSelectedIndex();
        }
        return n;
    }

    public static Object getPopupSelectedItem(JComboBox jComboBox) {
        Object var1_1 = null;
        JList jList = LightWeightComboBox.getList(jComboBox);
        if (jList != null) {
            var1_1 = jList.getSelectedValue();
        }
        return var1_1;
    }

    public int getPreviouslySelectedIndex() {
        return this.m_nPreviouslySelectedIndex;
    }

    public void setPreviouslySelectedIndex(int n) {
        this.m_nPreviouslySelectedIndex = n;
    }

    private void init() {
        if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4)) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        } else {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }
        this.setEditor(null.new LightWeightComboBoxEditor(this));
    }

    protected static class BorderlessTextField
    extends JTextField {
        JComboBox m_jComboBoxParent;

        public BorderlessTextField(String string, int n, JComboBox jComboBox) {
            super(string, n);
            this.setComboBoxParent(jComboBox);
        }

        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }

        public void setBorder(Border border) {
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            boolean bl2 = false;
            JComboBox jComboBox = this.getComboBoxParent();
            if (jComboBox != null) {
                bl2 = jComboBox.isPopupVisible();
                if (jComboBox.isEditable()) {
                    jComboBox.processKeyEvent(keyEvent);
                    if (keyEvent.getKeyCode() == 10) {
                        keyEvent.consume();
                        bl = true;
                    }
                }
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    if (!bl2 || LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4)) break;
                    keyEvent.consume();
                    bl = true;
                    break;
                }
                case 10: {
                    jComboBox.setSelectedItem(this.getText());
                    if (LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) || bl2) break;
                    keyEvent.consume();
                    this.getComboBoxParent().putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.processKeyEvent(keyEvent);
                    this.getComboBoxParent().putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                    bl = true;
                }
            }
            if (!bl) {
                super.processKeyEvent(keyEvent);
            }
        }

        public JComboBox getComboBoxParent() {
            return this.m_jComboBoxParent;
        }

        public void setComboBoxParent(JComboBox jComboBox) {
            this.m_jComboBoxParent = jComboBox;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new BorderlessTextAccessibleJTextField();
            }
            return this.accessibleContext;
        }

        protected class BorderlessTextAccessibleJTextField
        extends JTextField.AccessibleJTextField {
            protected BorderlessTextAccessibleJTextField() {
                super(BorderlessTextField.this);
            }

            public Document setAccessibleDocument() {
                Document document = BorderlessTextField.this.getDocument();
                try {
                    JComboBox jComboBox = BorderlessTextField.this.getComboBoxParent();
                    if (jComboBox != null && jComboBox.isEditable()) {
                        String string = null;
                        Object object = LightWeightComboBox.getPopupSelectedItem(jComboBox);
                        if (object != null) {
                            string = object.toString();
                        }
                        if (string != null) {
                            PlainDocument plainDocument = new PlainDocument();
                            plainDocument.insertString(0, string, null);
                            BorderlessTextField.this.setDocument(plainDocument);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return document;
            }

            public String getAtIndex(int n, int n2) {
                String string = null;
                Document document = this.setAccessibleDocument();
                string = super.getAtIndex(n, n2);
                if (!document.equals(BorderlessTextField.this.getDocument())) {
                    BorderlessTextField.this.setDocument(document);
                }
                return string;
            }

            public int getCharCount() {
                Document document = this.setAccessibleDocument();
                int n = super.getCharCount();
                if (!document.equals(BorderlessTextField.this.getDocument())) {
                    BorderlessTextField.this.setDocument(document);
                }
                return n;
            }
        }
    }

    public class LightWeightComboBoxEditor
    extends BasicComboBoxEditor {
        public LightWeightComboBoxEditor(JComboBox jComboBox) {
            this.editor = new BorderlessTextField("", 9, jComboBox);
            this.editor.setBorder(null);
        }
    }
}

