/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dss.util.help.HelpContext;

public class BIFontPane
extends FontPane
implements ItemListener,
HelpContext {
    protected JToggleButton auto;
    protected JToggleButton rotate_0;
    protected JToggleButton rotate_90;
    protected JToggleButton rotate_270;
    protected JPanel textRotationBar;
    protected JLabel rotationlabel;
    protected TitledPane pane;
    protected int oldValue;
    protected String m_strHelpContextID;
    protected int m_rotateMask;
    private ResourceBundle rBundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    private boolean m_bSuperCalled = true;
    public static final String TEXT_ROTATION = "textRotation";
    public static final int BUTTON_ROTATE_AUTO = 1;
    public static final int BUTTON_ROTATE_0 = 2;
    public static final int BUTTON_ROTATE_90 = 4;
    public static final int BUTTON_ROTATE_270 = 8;
    public static final int ROTATE_AUTO = 0;
    public static final int ROTATE_0 = 1;
    public static final int ROTATE_90 = 2;
    public static final int ROTATE_270 = 3;

    public BIFontPane() {
        this.getFontBackgroundColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        this.getFontColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        Component component = this._createTextRotationComponent();
        this.setExtraComponent(component);
        if (component.getParent() instanceof Container) {
            Container container = component.getParent();
            container.remove(component);
            container.add("Center", component);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = itemEvent.getSource() == this.rotate_0 ? 1 : (itemEvent.getSource() == this.rotate_90 ? 2 : (itemEvent.getSource() == this.rotate_270 ? 3 : 0));
            this.firePropertyChange(TEXT_ROTATION, this.oldValue, n);
            this.oldValue = n;
        }
    }

    public void setRotationButtonMask(int n) {
        this.m_rotateMask = n;
        this.textRotationBar.removeAll();
        if ((n & 1) != 0) {
            this.textRotationBar.add(this.auto);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((n & 2) != 0) {
            this.textRotationBar.add(this.rotate_0);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((n & 4) != 0) {
            this.textRotationBar.add(this.rotate_90);
            this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        }
        if ((n & 8) != 0) {
            this.textRotationBar.add(this.rotate_270);
        }
        this.pane.setVisible(n != 0);
        this.revalidate();
    }

    public int getTextRotation() {
        if (this.rotate_0.isSelected()) {
            return 1;
        }
        if (this.rotate_90.isSelected()) {
            return 2;
        }
        if (this.rotate_270.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void setTextRotation(int n) {
        if (n == 1) {
            this.rotate_0.setSelected(true);
            this.oldValue = 1;
        }
        if (n == 2) {
            this.rotate_90.setSelected(true);
            this.oldValue = 2;
        }
        if (n == 3) {
            this.rotate_270.setSelected(true);
            this.oldValue = 3;
        }
        if (n == 0) {
            this.auto.setSelected(true);
            this.oldValue = 0;
        }
    }

    public String getHelpContextID() {
        String string = "oracle.dss.util.gui.BiFontPane";
        int n = this.getStyleButtonMask();
        int n2 = this.getAlignmentButtonMask();
        int n3 = this.getColorComponentMask();
        if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) == 0 && (n & 8) == 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) == 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            string = "oracle.dss.util.gui.BiFontPane_A";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) != 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) != 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            string = "oracle.dss.util.gui.BiFontPane_B";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) != 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) != 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            string = "oracle.dss.util.gui.BiFontPane_C";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            string = "oracle.dss.util.gui.BiFontPane_D";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            string = "oracle.dss.util.gui.BiFontPane_E";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) == 0 && (n2 & 4) == 0 && (n2 & 8) == 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) == 0 && (this.m_rotateMask & 8) == 0) {
            string = "oracle.dss.util.gui.BiFontPane_F";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) == 0 && (n2 & 4) == 0 && (n2 & 8) == 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) != 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            string = "oracle.dss.util.gui.BiFontPane_G";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 8) != 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) == 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            string = "oracle.dss.util.gui.BiFontPane_H";
        } else if ((n & 1) != 0 && (n & 2) != 0 && (n & 4) != 0 && (n & 8) == 0 && (n2 & 2) == 0 && (n2 & 4) == 0 && (n2 & 8) == 0 && (n2 & 0x10) == 0 && (n2 & 0x40) == 0 && (n2 & 0x80) == 0 && (n2 & 0x100) == 0 && (n3 & 1) != 0 && (n3 & 2) == 0 && (this.m_rotateMask & 1) == 0 && (this.m_rotateMask & 2) != 0 && (this.m_rotateMask & 4) != 0 && (this.m_rotateMask & 8) != 0) {
            string = "oracle.dss.util.gui.BiFontPane_I";
        }
        return string;
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.auto.setText(this.rBundle.getString("Automatic"));
        this.rotationlabel.setText(this.rBundle.getString("Orientation"));
        this.rotate_0.getAccessibleContext().setAccessibleName(this.rBundle.getString("0 degree"));
        this.rotate_90.getAccessibleContext().setAccessibleName(this.rBundle.getString("90 degree"));
        this.rotate_270.getAccessibleContext().setAccessibleName(this.rBundle.getString("270 degree"));
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    }

    private ImageIcon _getImageIcon(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.util.gui.BIFontPane"), (String)string));
    }

    private Component _createTextRotationComponent() {
        this.textRotationBar = new JPanel();
        this.textRotationBar.setLayout(new BoxLayout(this.textRotationBar, 0));
        this.textRotationBar.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.auto = new JToggleButton(this.rBundle.getString("Automatic"));
        this.rotate_0 = new JToggleButton();
        this.rotate_0.getAccessibleContext().setAccessibleName(this.rBundle.getString("0 degree"));
        this.rotate_90 = new JToggleButton();
        this.rotate_90.getAccessibleContext().setAccessibleName(this.rBundle.getString("90 degree"));
        this.rotate_270 = new JToggleButton();
        this.rotate_270.getAccessibleContext().setAccessibleName(this.rBundle.getString("270 degree"));
        this.auto.addItemListener(this);
        this.rotate_0.addItemListener(this);
        this.rotate_90.addItemListener(this);
        this.rotate_270.addItemListener(this);
        this.rotate_0.setIcon(this._getImageIcon("images/0 degrees.gif"));
        this.rotate_90.setIcon(this._getImageIcon("images/90 degrees.gif"));
        this.rotate_270.setIcon(this._getImageIcon("images/270 degrees.gif"));
        this.textRotationBar.add(this.auto);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_0);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_90);
        this.textRotationBar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.textRotationBar.add(this.rotate_270);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.auto);
        buttonGroup.add(this.rotate_0);
        buttonGroup.add(this.rotate_90);
        buttonGroup.add(this.rotate_270);
        this.rotationlabel = new JLabel(this.rBundle.getString("Orientation"));
        this.pane = new TitledPane((Component)this.rotationlabel, (Component)this.textRotationBar);
        return this.pane;
    }

    protected void setCustomColorsEnabled(boolean bl) {
        if (bl) {
            this.getFontBackgroundColorChoice().setEditAllowed(true);
            this.getFontBackgroundColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontBackgroundColorChoice()));
            this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(true);
            this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(true);
            this.getFontColorChoice().setEditAllowed(true);
            this.getFontColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontColorChoice()));
            this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(true);
            this.getFontColorChoice().getColorPalettePane().setEditVisible(true);
        } else {
            this.getFontBackgroundColorChoice().setEditAllowed(false);
            this.getFontBackgroundColorChoice().setCustomColorPalette(null);
            this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(false);
            this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(false);
            this.getFontColorChoice().setEditAllowed(false);
            this.getFontColorChoice().setCustomColorPalette(null);
            this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(false);
            this.getFontColorChoice().getColorPalettePane().setEditVisible(false);
        }
    }

    private TwoDModel _createCustomPalette(ColorChoice colorChoice) {
        TwoDModel twoDModel = colorChoice.getColorPalette();
        ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(twoDModel.getColumnCount(), 2);
        return arrayTwoDModel;
    }
}

