/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.BIException;

public class BIExceptionPanel
extends JPanel
implements ListSelectionListener {
    private Throwable m_exception;
    private String m_message;
    private boolean m_detailVisible;
    private JList m_expList;
    private JTextArea m_stkTxtArea;
    private JPanel m_expStackPanel;
    private JDialog m_dialog;
    private ResourceBundle m_bundle;
    private Dimension m_prevDim;

    public BIExceptionPanel(JDialog jDialog, Throwable throwable, String string, ResourceBundle resourceBundle) {
        this.m_dialog = jDialog;
        this.m_exception = throwable;
        this.m_bundle = resourceBundle;
        this.m_message = string;
        this.init();
    }

    public void init() {
        this.m_detailVisible = false;
        String string = this.m_bundle.getString("Show Details");
        final JButton jButton = new JButton(StringUtils.stripMnemonic((String)string));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_expList = new JList();
        this.m_stkTxtArea = new JTextArea(10, 20);
        this.m_stkTxtArea.setEditable(false);
        this.setLayout(new BoxLayout(this, 1));
        JButton jButton2 = new JButton(new ImageIcon(ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/ewt/olaf/icons/Error.gif")));
        jButton2.setFocusPainted(false);
        jButton2.setHorizontalAlignment(2);
        jButton2.setVerticalAlignment(1);
        jButton2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel(new BorderLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_message);
        jPanel.add((Component)jButton2, "West");
        jPanel.add((Component)multiLineLabel, "Center");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jButton);
        this.add(jPanel2);
        this.m_expStackPanel = new JPanel(new BorderLayout(5, 5));
        this.add(this.m_expStackPanel);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (m_detailVisible) {
                    jButton.setText(StringUtils.stripMnemonic((String)m_bundle.getString("Show Details")));
                } else {
                    jButton.setText(StringUtils.stripMnemonic((String)m_bundle.getString("Hide Details")));
                }
                this.showHideDetail();
            }
        });
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Throwable throwable = this.m_exception instanceof BIException ? ((BIException)((Object)this.m_exception)).elementAt(this.m_expList.getSelectedIndex()) : this.m_exception;
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            this.m_stkTxtArea.setText(stringWriter.toString());
        }
        this.m_stkTxtArea.setCaretPosition(0);
    }

    public void showHideDetail() {
        if (!this.m_detailVisible) {
            Object object;
            Object object2;
            this.m_prevDim = this.m_dialog.getSize();
            if (this.m_exception instanceof BIException) {
                object2 = new Vector<String>(((BIException)((Object)this.m_exception)).size());
                object = ((BIException)((Object)this.m_exception)).elements();
                while (object.hasMoreElements()) {
                    ((Vector)object2).addElement(((Throwable)object.nextElement()).getLocalizedMessage());
                }
                this.m_expList.setListData(object2);
            } else {
                this.m_expList.setListData(new Object[]{this.m_exception.getLocalizedMessage()});
            }
            this.m_expList.setBackground(UIManager.getColor("darkLook"));
            this.m_expList.addListSelectionListener(this);
            object2 = this.m_bundle.getString("Exception chain");
            object = new JLabel(StringUtils.stripMnemonic((String)object2));
            ((JLabel)object).setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)object2));
            ((JLabel)object).setLabelFor(this.m_expList);
            JScrollPane jScrollPane = new JScrollPane(this.m_expList);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)object, "North");
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            jPanel.setPreferredSize(new Dimension(500, 150));
            this.m_expStackPanel.add((Component)jPanel, "North");
            String string = this.m_bundle.getString("Stack trace");
            JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
            jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            jLabel.setLabelFor(this.m_stkTxtArea);
            JScrollPane jScrollPane2 = new JScrollPane(this.m_stkTxtArea);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jLabel, "North");
            jPanel2.add((Component)jScrollPane2, "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.m_expStackPanel.add((Component)jPanel2, "Center");
            this.m_expList.setSelectedIndex(0);
            this.m_dialog.pack();
            this.m_dialog.show();
            this.m_detailVisible = true;
        } else {
            this.m_expStackPanel.removeAll();
            this.m_dialog.setSize(this.m_prevDim);
            this.m_dialog.show();
            this.m_detailVisible = false;
        }
    }
}

