/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.BIException;
import oracle.dss.util.gui.BIExceptionPanel;
import oracle.dss.util.help.HelpContext;

public class BIExceptionDialog
extends JEWTDialog
implements HelpContext {
    private Throwable m_exception;
    private String m_errMsg;
    private ResourceBundle m_bundle;
    private String m_strHelpContextID;
    private HelpProvider m_helpProvider;
    private boolean m_bHelpEnabled;

    public BIExceptionDialog(Frame frame, Throwable throwable, String string, String string2, Locale locale) {
        super(frame);
        this.m_exception = throwable;
        this.init(locale, string, string2);
    }

    public BIExceptionDialog(Dialog dialog, Throwable throwable, String string, String string2, Locale locale) {
        super(dialog);
        this.m_exception = throwable;
        this.init(locale, string, string2);
    }

    private void init(Locale locale, String string, String string2) {
        if (locale != null) {
            this.loadResources(locale);
        } else {
            this.loadResources(Locale.getDefault());
        }
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setTitle(this.m_bundle.getString("BIException Dialog"));
        }
        this.m_errMsg = string2 != null ? string2 : this.m_bundle.getString("An application error has occured");
        this.setButtonMask(5);
        String string3 = this.m_bundle.getString("Save");
        JButton jButton = new JButton(StringUtils.stripMnemonic((String)string3));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string3));
        this.addCustomButton(jButton);
        String string4 = this.m_bundle.getString("OK");
        this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)string4));
        this.setDefaultButton(1);
        this.setContent(new BIExceptionPanel((JDialog)((Object)this), this.m_exception, this.m_errMsg, this.m_bundle));
        this.setResizable(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BIExceptionDialog.this.saveStackTrace();
            }
        });
    }

    private void saveStackTrace() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                if (this.m_exception instanceof BIException) {
                    int n2 = ((BIException)((Object)this.m_exception)).size();
                    int n3 = 0;
                    while (n3 < n2) {
                        ((BIException)((Object)this.m_exception)).elementAt(n3).printStackTrace(printWriter);
                        ++n3;
                    }
                } else {
                    this.m_exception.printStackTrace(printWriter);
                }
                String string = stringWriter.toString();
                fileWriter.write(string, 0, string.length());
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadResources(Locale locale) {
        try {
            this.m_bundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void display() {
        this.runDialog();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)this.m_helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        String string = "To add items to the query of your Presentation, select the items from the Available list and move them to the Selected list.";
        BIExceptionDialog bIExceptionDialog = new BIExceptionDialog(new Frame(), (Throwable)new Exception("Not good."), null, string, null);
        bIExceptionDialog.display();
        System.exit(0);
    }
}

